/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JLabel;
import org.sikuli.guide.SxClickable;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxButton
extends SxClickable {
    Font f = new Font("sansserif", 1, 18);
    JLabel label = null;

    public SxButton(String name) {
        super(new Region(0, 0, 0, 0));
        this.init(name);
    }

    private void init(String name) {
        this.PADDING_Y = 10;
        this.PADDING_X = 10;
        this.fontSize = 18;
        this.setName(name);
        this.setColors(null, null, null, null, Color.WHITE);
        this.mouseOverColor = new Color(0.3f, 0.3f, 0.3f);
        this.layout = Visual.Layout.BOTTOM;
    }

    @Override
    public void setName(String name) {
        if (this.label == null) {
            super.setName(name);
            this.label = new JLabel(name);
            this.add(this.label);
        }
        this.label.setFont(new Font("sansserif", 1, this.fontSize));
        this.label.setForeground(this.colorText);
        Dimension s = this.label.getPreferredSize();
        this.label.setLocation(this.PADDING_X / 2, this.PADDING_Y / 2);
        this.label.setSize(s);
        s.height += this.PADDING_Y;
        s.width += this.PADDING_X;
        this.setActualSize(s);
    }

    @Override
    public void updateComponent() {
        this.setName(this.name);
        this.setLocationRelative(this.layout);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Color cb = null;
        cb = this.isMouseOver() ? this.mouseOverColor : this.colorFront;
        g2d.setColor(cb);
        RoundRectangle2D.Float roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getActualWidth() - 1, this.getActualHeight() - 1, this.PADDING_X, this.PADDING_Y);
        g2d.fill(roundedRectangle);
        g2d.setColor(cb);
        g2d.draw(roundedRectangle);
        roundedRectangle = new RoundRectangle2D.Float(1.0f, 1.0f, this.getActualWidth() - 3, this.getActualHeight() - 3, this.PADDING_X, this.PADDING_Y);
        g2d.setColor(this.colorFrame);
        g2d.draw(roundedRectangle);
        this.label.paintComponents(g);
    }
}

