/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.util.Date;
import org.sikuli.basics.Debug;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.ObserverCallBack;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;

public class Device {
    static RunTime runTime = RunTime.get();
    private static String me = "Device: ";
    private static final int lvl = 3;
    private Object device = null;
    private String devName = "Device";
    protected boolean inUse = false;
    protected boolean keep = false;
    protected Object owner = null;
    private boolean blocked = false;
    private boolean suspended = false;
    protected Location lastPos = null;
    protected boolean isMouse = false;
    protected int MouseMovedIgnore = 0;
    protected int MouseMovedShow = 1;
    protected int MouseMovedPause = 2;
    protected int MouseMovedAction = 3;
    protected int mouseMovedResponse = this.MouseMovedIgnore;
    protected boolean MouseMovedHighlight = true;
    protected ObserverCallBack mouseMovedCallback = null;
    protected ObserverCallBack callback = null;
    private boolean shouldRunCallback = false;
    static boolean shouldTerminate = false;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public static void setShouldTerminate() {
        shouldTerminate = true;
        Device.log(3, "setShouldTerminate: request issued", new Object[0]);
    }

    public boolean isShouldRunCallback() {
        return this.shouldRunCallback;
    }

    public void setShouldRunCallback(boolean shouldRunCallback) {
        this.shouldRunCallback = shouldRunCallback;
    }

    protected Device(Mouse m) {
        this.device = m;
        this.devName = "Mouse";
    }

    protected Device(Screen s) {
        this.device = s;
        this.devName = "Screen";
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isNotLocal(Object owner) {
        return owner instanceof Region ? ((Region)owner).isOtherScreen() : owner instanceof Location && ((Location)owner).isOtherScreen();
    }

    public boolean block() {
        return this.block(null);
    }

    public boolean block(Object owner) {
        if (this.use(owner)) {
            this.blocked = true;
            return true;
        }
        return false;
    }

    public boolean unblock() {
        return this.unblock(null);
    }

    public boolean unblock(Object ownerGiven) {
        if (ownerGiven == null) {
            ownerGiven = this.device;
        } else if (this.isNotLocal(ownerGiven)) {
            return false;
        }
        if (this.blocked && this.owner == ownerGiven) {
            this.blocked = false;
            this.let(ownerGiven);
            return true;
        }
        return false;
    }

    protected boolean use() {
        return this.use(null);
    }

    protected synchronized boolean use(Object owner) {
        if (owner == null) {
            owner = this;
        } else if (this.isNotLocal(owner)) {
            return false;
        }
        if ((this.blocked || this.inUse) && this.owner == owner) {
            return true;
        }
        while (this.inUse) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.inUse) {
            this.inUse = true;
            try {
                this.checkLastPos();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.checkShouldRunCallback();
            if (shouldTerminate) {
                shouldTerminate = false;
                throw new AssertionError((Object)"aborted by unknown source");
            }
            this.keep = false;
            this.owner = owner;
            Device.log(4, "%s: use start: %s", this.devName, owner);
            return true;
        }
        Device.log(-1, "synch problem - use start: %s", owner);
        return false;
    }

    protected synchronized boolean keep(Object ownerGiven) {
        if (ownerGiven == null) {
            ownerGiven = this;
        } else if (this.isNotLocal(ownerGiven)) {
            return false;
        }
        if (this.inUse && this.owner == ownerGiven) {
            this.keep = true;
            Device.log(4, "%s: use keep: %s", this.devName, ownerGiven);
            return true;
        }
        return false;
    }

    protected boolean let() {
        return this.let(null);
    }

    protected synchronized boolean let(Object owner) {
        if (owner == null) {
            owner = this;
        } else if (this.isNotLocal(owner)) {
            return false;
        }
        if (this.inUse && this.owner == owner) {
            if (this.keep) {
                this.keep = false;
                return true;
            }
            if (this.isMouse) {
                this.lastPos = this.getLocation();
            }
            this.inUse = false;
            this.owner = null;
            this.notify();
            Device.log(4, "%s: use stop: %s", this.devName, owner);
            return true;
        }
        return false;
    }

    protected Location getLocation() {
        PointerInfo mp = MouseInfo.getPointerInfo();
        if (mp != null) {
            return new Location(MouseInfo.getPointerInfo().getLocation());
        }
        Debug.error("Mouse: not possible to get mouse position (PointerInfo == null)", new Object[0]);
        return null;
    }

    private void checkLastPos() throws UnsupportedOperationException {
        if (this.lastPos == null) {
            return;
        }
        Location pos = this.getLocation();
        if (pos != null && (this.lastPos.x != pos.x || this.lastPos.y != pos.y)) {
            Device.log(3, "%s: moved externally: now (%d,%d) was (%d,%d) (mouseMovedResponse %d)", this.devName, pos.x, pos.y, this.lastPos.x, this.lastPos.y, this.mouseMovedResponse);
            if (this.mouseMovedResponse > 0 && this.MouseMovedHighlight) {
                Device.showMousePos(pos.getPoint());
            }
            if (this.mouseMovedResponse == this.MouseMovedPause) {
                while (pos.x > 0 && pos.y > 0) {
                    Device.delay(500);
                    pos = this.getLocation();
                    if (!this.MouseMovedHighlight) continue;
                    Device.showMousePos(pos.getPoint());
                }
                if (pos.x < 1) {
                    return;
                }
                throw new UnsupportedOperationException("Terminating in MouseMovedResponse = Pause");
            }
            if (this.mouseMovedResponse == this.MouseMovedAction && this.mouseMovedCallback != null) {
                this.mouseMovedCallback.happened(new ObserveEvent("MouseMoved", ObserveEvent.Type.GENERIC, this.lastPos, new Location(pos), null, new Date().getTime()));
                if (shouldTerminate) {
                    shouldTerminate = false;
                    throw new AssertionError((Object)"aborted by Sikulix.MouseMovedCallBack");
                }
            }
        }
    }

    private void checkShouldRunCallback() {
        if (this.shouldRunCallback && this.callback != null) {
            this.callback.happened(new ObserveEvent("DeviceGeneric", ObserveEvent.Type.GENERIC, null, null, null, new Date().getTime()));
            if (shouldTerminate) {
                shouldTerminate = false;
                throw new AssertionError((Object)"aborted by Sikulix.GenericDeviceCallBack");
            }
        }
    }

    public void setCallback(Object givenCallBack) {
        if (givenCallBack != null) {
            this.callback = new ObserverCallBack(givenCallBack, ObserveEvent.Type.GENERIC);
        }
    }

    private static void showMousePos(Point pos) {
        Location lPos = new Location(pos);
        Region inner = lPos.grow(20).highlight();
        Device.delay(500);
        lPos.grow(40).highlight(1);
        Device.delay(500);
        inner.highlight();
    }

    protected static void delay(int time) {
        if (time == 0) {
            return;
        }
        if (time < 10) {
            time *= 1000;
        }
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

