/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import org.sikuli.basics.Debug;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Image;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.ObserverCallBack;
import org.sikuli.script.Region;
import org.sikuli.script.SikuliException;

public class FindFailed
extends SikuliException {
    public static FindFailedResponse defaultFindFailedResponse = FindFailedResponse.ABORT;
    public static final FindFailedResponse PROMPT = FindFailedResponse.PROMPT;
    public static final FindFailedResponse RETRY = FindFailedResponse.RETRY;
    public static final FindFailedResponse SKIP = FindFailedResponse.SKIP;
    public static final FindFailedResponse ABORT = FindFailedResponse.ABORT;
    public static final FindFailedResponse HANDLE = FindFailedResponse.HANDLE;
    private static Object ffHandler = null;
    private static Object imHandler = null;
    private static Object defaultHandler = null;

    public FindFailed(String message) {
        super(message);
        this._name = "FindFailed";
    }

    public static String createdefault(Region reg, Image img) {
        String msg = "";
        msg = img.isText() ? String.format("%s as text", img.getName()) : (img.getSize().width < 0 && img.getSize().height < 0 ? String.format("%s not loaded", img.getName()) : String.format("%s in %s", img, reg));
        return msg;
    }

    public static FindFailedResponse getResponse() {
        return defaultFindFailedResponse;
    }

    public static FindFailedResponse setResponse(FindFailedResponse response) {
        defaultFindFailedResponse = response;
        return defaultFindFailedResponse;
    }

    public static FindFailedResponse setHandler(Object observer) {
        if (observer != null && (observer.getClass().getName().contains("org.python") || observer.getClass().getName().contains("org.jruby"))) {
            observer = new ObserverCallBack(observer, ObserveEvent.Type.FINDFAILED);
        } else {
            ((ObserverCallBack)observer).setType(ObserveEvent.Type.FINDFAILED);
        }
        ffHandler = observer;
        Debug.log(3, "Setting Default FindFailedHandler", new Object[0]);
        return defaultFindFailedResponse;
    }

    protected void setFindFailedHandler(Object handler) {
        ffHandler = this.setHandler(handler, ObserveEvent.Type.FINDFAILED);
    }

    public void setImageMissingHandler(Object handler) {
        imHandler = this.setHandler(handler, ObserveEvent.Type.MISSING);
    }

    private Object setHandler(Object handler, ObserveEvent.Type type) {
        defaultFindFailedResponse = HANDLE;
        if (handler != null && (handler.getClass().getName().contains("org.python") || handler.getClass().getName().contains("org.jruby"))) {
            handler = new ObserverCallBack(handler, type);
        } else {
            ((ObserverCallBack)handler).setType(type);
        }
        return handler;
    }

    public static Object getFindFailedHandler() {
        return ffHandler;
    }

    public static Object getImageMissingHandler() {
        return imHandler;
    }

    public static FindFailedResponse reset() {
        defaultFindFailedResponse = ABORT;
        ffHandler = null;
        imHandler = null;
        return defaultFindFailedResponse;
    }
}

