/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.natives.FindInput;
import org.sikuli.natives.FindResult;
import org.sikuli.natives.FindResults;
import org.sikuli.natives.Vision;
import org.sikuli.script.IScreen;
import org.sikuli.script.Image;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.TextRecognizer;

public class Finder
implements Iterator<Match> {
    static RunTime runTime = RunTime.get();
    private Region _region = null;
    private Pattern _pattern = null;
    private Image _image = null;
    private FindInput _findInput = new FindInput();
    private FindResults _results = null;
    private int _cur_result_i;
    private boolean repeating = false;
    private boolean valid = true;
    private boolean screenFinder = true;
    private static String me;
    private static int lvl;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public Finder() {
    }

    public Finder(String imageFilename) throws IOException {
        this(imageFilename, null);
    }

    public Finder(String imageFilename, Region region) throws IOException {
        Image img = Image.create(imageFilename);
        if (img.isValid()) {
            this._findInput.setSource(Image.convertBufferedImageToMat(img.get()));
            this._region = region;
            this.screenFinder = false;
        } else {
            Finder.log(-1, "imagefile not found:\n%s", imageFilename);
            this.valid = false;
        }
    }

    public Finder(BufferedImage bimg) {
        this._findInput.setSource(Image.convertBufferedImageToMat(bimg));
    }

    public Finder(ScreenImage simg) {
        this.initScreenFinder(simg, null);
    }

    public Finder(ScreenImage simg, Region region) {
        this.initScreenFinder(simg, region);
    }

    public Finder(Image img) {
        Finder.log(lvl, "Image: %s", img);
        this._findInput.setSource(Image.convertBufferedImageToMat(img.get()));
    }

    public void resetImage(Image img) {
        this._findInput.setSource(Image.convertBufferedImageToMat(img.get()));
    }

    private void initScreenFinder(ScreenImage simg, Region region) {
        this.setScreenImage(simg);
        this._region = region;
    }

    public void destroy() {
        this._findInput.delete();
        this._findInput = null;
        if (this._results != null) {
            this._results.delete();
            this._results = null;
        }
        this._pattern = null;
    }

    @Override
    public void remove() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    protected void setScreenImage(ScreenImage simg) {
        this._findInput.setSource(Image.convertBufferedImageToMat(simg.getImage()));
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setRepeating() {
        this.repeating = true;
    }

    protected void findRepeat() {
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
    }

    protected void findAllRepeat() {
        Debug timing = Debug.startTimer("Finder.findAll", new Object[0]);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        timing.end();
    }

    public String find(String imageOrText) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        Image img = Image.create(imageOrText);
        if (img.isText()) {
            return this.findText(imageOrText);
        }
        if (img.isValid()) {
            return this.find(img);
        }
        return null;
    }

    public String find(Pattern aPtn) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (aPtn.isValid()) {
            this._pattern = aPtn;
            this._findInput.setTarget(aPtn.getImage().getMatNative());
            this._findInput.setSimilarity(aPtn.getSimilar());
            this._results = Vision.find(this._findInput);
            this._cur_result_i = 0;
            return aPtn.getFilename();
        }
        return null;
    }

    public String find(Image img) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (img.isValid()) {
            this._findInput.setTarget(img.getMatNative());
            this._findInput.setSimilarity(Settings.MinSimilarity);
            this._results = Vision.find(this._findInput);
            this._cur_result_i = 0;
            return img.getFilename();
        }
        if (img.isUseable()) {
            return this.find(new Pattern(img));
        }
        return null;
    }

    public String findText(String text) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        this._findInput.setTarget(2, text);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        return text;
    }

    public String findAll(String imageOrText) {
        Image img;
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        this._image = img = Image.create(imageOrText);
        if (img.isText()) {
            return this.findAllText(imageOrText);
        }
        if (img.isValid()) {
            return this.findAll(img);
        }
        return null;
    }

    public String findAll(Pattern aPtn) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (aPtn.isValid()) {
            this._image = aPtn.getImage();
            this._pattern = aPtn;
            this._findInput.setTarget(aPtn.getImage().getMatNative());
            this._findInput.setSimilarity(aPtn.getSimilar());
            this._findInput.setFindAll(true);
            Debug timing = Debug.startTimer("Finder.findAll", new Object[0]);
            this._results = Vision.find(this._findInput);
            this._cur_result_i = 0;
            timing.end();
            return aPtn.getFilename();
        }
        return null;
    }

    public String findAll(Image img) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (img.isValid()) {
            this._findInput.setTarget(img.getMatNative());
            this._findInput.setSimilarity(Settings.MinSimilarity);
            this._findInput.setFindAll(true);
            Debug timing = Debug.startTimer("Finder.findAll", new Object[0]);
            this._results = Vision.find(this._findInput);
            this._cur_result_i = 0;
            timing.end();
            return img.getFilename();
        }
        return null;
    }

    public String findAllText(String text) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        this._findInput.setTarget(2, text);
        this._findInput.setFindAll(true);
        Debug timing = Debug.startTimer("Finder.findAllText", new Object[0]);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        timing.end();
        return text;
    }

    private String setTargetSmartly(FindInput fin, String target) {
        if (Finder.isImageFile(target)) {
            String filename = Image.create(target).getFilename();
            if (filename != null) {
                fin.setTarget(1, filename);
                return filename;
            }
            if (!this.repeating) {
                Debug.error(target + " looks like a file, but not on disk. Assume it's text.", new Object[0]);
            }
        }
        if (!Settings.OcrTextSearch) {
            Debug.error("Region.find(text): text search is currently switched off", new Object[0]);
            return target + "???";
        }
        fin.setTarget(2, target);
        if (TextRecognizer.getInstance() == null) {
            Debug.error("Region.find(text): text search is now switched off", new Object[0]);
            return target + "???";
        }
        return target;
    }

    private static boolean isImageFile(String fname) {
        int dot = fname.lastIndexOf(46);
        if (dot < 0) {
            return false;
        }
        String suffix = fname.substring(dot + 1).toLowerCase();
        return suffix.equals("png") || suffix.equals("jpg");
    }

    @Override
    public boolean hasNext() {
        return this._results != null && this._results.size() > (long)this._cur_result_i;
    }

    @Override
    public Match next() {
        Match match = null;
        if (this.hasNext()) {
            FindResult fr = this._results.get(this._cur_result_i++);
            IScreen parentScreen = null;
            if (this.screenFinder && this._region != null) {
                parentScreen = this._region.getScreen();
            }
            match = new Match(fr, parentScreen);
            match.setOnScreen(this.screenFinder);
            fr.delete();
            if (this._region != null) {
                match = this._region.toGlobalCoord(match);
            }
            if (this._pattern != null) {
                Location offset = this._pattern.getTargetOffset();
                match.setTargetOffset(offset);
            }
            match.setImage(this._image);
        }
        return match;
    }

    static {
        RunTime.loadLibrary("VisionProxy");
        me = "Finder: ";
        lvl = 3;
    }
}

