/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import org.sikuli.basics.AnimatorOutQuarticEase;
import org.sikuli.basics.AnimatorTimeBased;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

public class RobotDesktop
extends Robot
implements IRobot {
    static final int MAX_DELAY = 60000;
    private static int heldButtons = 0;
    private static String heldKeys = "";
    private static final ArrayList<Integer> heldKeyCodes = new ArrayList();
    public static int stdAutoDelay = 0;
    public static int stdDelay = 10;
    public static int stdMaxElapsed = 1000;
    private Screen scr = null;
    private static RunTime runTime = RunTime.get();
    private long start;
    private static boolean alwaysNewRobot = false;
    private static boolean isMouseInitialized = false;

    private void logRobot(int delay, String msg) {
        this.start = new Date().getTime();
        int theDelay = this.getAutoDelay();
        if (theDelay > 0 && theDelay > delay) {
            Debug.log(0, msg, this.isAutoWaitForIdle(), theDelay);
        }
    }

    private void logRobot(String msg, int maxElapsed) {
        long elapsed = new Date().getTime() - this.start;
        if (elapsed > (long)maxElapsed) {
            Debug.log(0, msg, elapsed);
            this.setAutoDelay(stdAutoDelay);
            this.setAutoWaitForIdle(false);
        }
    }

    private void doMouseMove(int x, int y) {
        this.mouseMove(x, y);
    }

    private void doMouseDown(int buttons) {
        if (Settings.RobotFake && runTime.needsRobotFake()) {
            Screen.getFakeRegion().silentHighlight(true);
        }
        this.logRobot(stdAutoDelay, "MouseDown: WaitForIdle: %s - Delay: %d");
        this.setAutoDelay(stdAutoDelay);
        this.setAutoWaitForIdle(Settings.ClickFast);
        if (Settings.RobotFake && runTime.needsRobotFake()) {
            this.delay(20);
            Screen.getFakeRegion().silentHighlight(false);
            this.delay(20);
        }
        this.mousePress(buttons);
        this.setAutoWaitForIdle(false);
        if (!Settings.ClickFast && stdAutoDelay == 0) {
            this.delay(stdDelay);
        }
        this.logRobot("MouseDown: extended delay: %d", stdMaxElapsed);
    }

    private void doMouseUp(int buttons) {
        this.logRobot(stdAutoDelay, "MouseUp: WaitForIdle: %s - Delay: %d");
        this.setAutoDelay(stdAutoDelay);
        this.setAutoWaitForIdle(Settings.ClickFast);
        this.mouseRelease(buttons);
        this.setAutoWaitForIdle(false);
        if (!Settings.ClickFast && stdAutoDelay == 0) {
            this.delay(stdDelay);
        }
        this.logRobot("MouseUp: extended delay: %d", stdMaxElapsed);
    }

    private void doKeyPress(int keyCode) {
        this.logRobot(stdAutoDelay, "KeyPress: WaitForIdle: %s - Delay: %d");
        this.setAutoDelay(stdAutoDelay);
        this.setAutoWaitForIdle(false);
        this.keyPress(keyCode);
        if (stdAutoDelay == 0) {
            this.delay(stdDelay);
        }
        this.logRobot("KeyPress: extended delay: %d", stdMaxElapsed);
    }

    private void doKeyRelease(int keyCode) {
        this.logRobot(stdAutoDelay, "KeyRelease: WaitForIdle: %s - Delay: %d");
        this.setAutoDelay(stdAutoDelay);
        this.setAutoWaitForIdle(false);
        this.keyRelease(keyCode);
        if (stdAutoDelay == 0) {
            this.delay(stdDelay);
        }
        this.logRobot("KeyRelease: extended delay: %d", stdMaxElapsed);
    }

    private Robot getRobot() {
        return null;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public Screen getScreen() {
        return this.scr;
    }

    public RobotDesktop(Screen screen) throws AWTException {
        super(runTime.getGraphicsDevice(screen.getcurrentID()));
        this.scr = screen;
    }

    public RobotDesktop() throws AWTException {
        this.setAutoDelay(stdAutoDelay);
        this.setAutoWaitForIdle(false);
    }

    @Override
    public void smoothMove(Location dest) {
        this.smoothMove(Mouse.at(), dest, (long)(Settings.MoveMouseDelay * 1000.0f));
    }

    @Override
    public void smoothMove(Location src, Location dest, long ms) {
        Debug.log(4, "RobotDesktop: smoothMove (%.1f): " + src.toString() + "---" + dest.toString(), Float.valueOf((float)ms / 1000.0f));
        if (ms == 0L) {
            this.doMouseMove(dest.x, dest.y);
            this.waitForIdle();
            this.checkMousePosition(dest);
            return;
        }
        AnimatorTimeBased aniX = new AnimatorTimeBased(new AnimatorOutQuarticEase(src.x, dest.x, ms));
        AnimatorTimeBased aniY = new AnimatorTimeBased(new AnimatorOutQuarticEase(src.y, dest.y, ms));
        float x = 0.0f;
        float y = 0.0f;
        while (aniX.running()) {
            x = aniX.step();
            y = aniY.step();
            this.doMouseMove((int)x, (int)y);
        }
        this.checkMousePosition(new Location((int)x, (int)y));
    }

    private void checkMousePosition(Location p) {
        PointerInfo mp = MouseInfo.getPointerInfo();
        if (mp == null) {
            Debug.error("RobotDesktop: checkMousePosition: MouseInfo.getPointerInfo invalid\nafter move to %s", p);
        } else {
            Point pc = mp.getLocation();
            if ((pc.x != p.x || pc.y != p.y) && isMouseInitialized) {
                Debug.error("RobotDesktop: checkMousePosition: should be %s\nbut after move is %s\nPossible cause in case you did not touch the mouse while script was running:\n Mouse actions are blocked generally or by the frontmost application." + (Settings.isWindows() ? "\nYou might try to run the SikuliX stuff as admin." : ""), p, new Location(pc));
            }
        }
        if (!isMouseInitialized) {
            isMouseInitialized = true;
        }
    }

    @Override
    public void mouseDown(int buttons) {
        heldButtons = heldButtons != 0 ? (heldButtons |= buttons) : buttons;
        this.doMouseDown(heldButtons);
    }

    @Override
    public int mouseUp(int buttons) {
        if (buttons == 0) {
            this.doMouseUp(heldButtons);
            heldButtons = 0;
        } else {
            this.doMouseUp(buttons);
            heldButtons &= ~buttons;
        }
        return heldButtons;
    }

    @Override
    public void mouseReset() {
        if (heldButtons != 0) {
            this.setAutoWaitForIdle(false);
            this.mouseRelease(heldButtons);
            heldButtons = 0;
        }
    }

    @Override
    public void clickStarts() {
    }

    @Override
    public void clickEnds() {
    }

    @Override
    public void delay(int ms) {
        if (ms < 0) {
            return;
        }
        while (ms > 60000) {
            super.delay(60000);
            ms -= 60000;
        }
        super.delay(ms);
    }

    @Override
    public ScreenImage captureScreen(Rectangle rect) {
        Rectangle cRect = new Rectangle(rect);
        BufferedImage img = this.createScreenCapture(rect);
        Debug.log(4, "RobotDesktop: captureScreen: [%d,%d, %dx%d]", rect.x, rect.y, rect.width, rect.height);
        return new ScreenImage(rect, img);
    }

    @Override
    public Color getColorAt(int x, int y) {
        return this.getPixelColor(x, y);
    }

    @Override
    public void pressModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.doKeyPress(16);
        }
        if ((modifiers & 2) != 0) {
            this.doKeyPress(17);
        }
        if ((modifiers & 8) != 0) {
            this.doKeyPress(18);
        }
        if ((modifiers & 4) != 0) {
            if (Settings.isWindows()) {
                this.doKeyPress(524);
            } else {
                this.doKeyPress(157);
            }
        }
    }

    @Override
    public void releaseModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            this.doKeyRelease(16);
        }
        if ((modifiers & 2) != 0) {
            this.doKeyRelease(17);
        }
        if ((modifiers & 8) != 0) {
            this.doKeyRelease(18);
        }
        if ((modifiers & 4) != 0) {
            if (Settings.isWindows()) {
                this.doKeyRelease(524);
            } else {
                this.doKeyRelease(157);
            }
        }
    }

    @Override
    public void keyDown(String keys) {
        if (keys != null && !"".equals(keys)) {
            for (int i = 0; i < keys.length(); ++i) {
                if (heldKeys.indexOf(keys.charAt(i)) != -1) continue;
                Debug.log(4, "press: " + keys.charAt(i), new Object[0]);
                this.typeChar(keys.charAt(i), IRobot.KeyMode.PRESS_ONLY);
                heldKeys = heldKeys + keys.charAt(i);
            }
        }
    }

    @Override
    public void keyDown(int code) {
        if (!heldKeyCodes.contains(code)) {
            this.doKeyPress(code);
            heldKeyCodes.add(code);
        }
    }

    @Override
    public void keyUp(String keys) {
        if (keys != null && !"".equals(keys)) {
            for (int i = 0; i < keys.length(); ++i) {
                int pos = heldKeys.indexOf(keys.charAt(i));
                if (pos == -1) continue;
                Debug.log(4, "release: " + keys.charAt(i), new Object[0]);
                this.typeChar(keys.charAt(i), IRobot.KeyMode.RELEASE_ONLY);
                heldKeys = heldKeys.substring(0, pos) + heldKeys.substring(pos + 1);
            }
        }
    }

    @Override
    public void keyUp(int code) {
        if (heldKeyCodes.contains(code)) {
            this.doKeyRelease(code);
            heldKeyCodes.remove((Object)code);
        }
    }

    @Override
    public void keyUp() {
        this.keyUp(heldKeys);
        for (int code : heldKeyCodes) {
            this.keyUp(code);
        }
    }

    private void doType(IRobot.KeyMode mode, int ... keyCodes) {
        this.waitForIdle();
        if (mode == IRobot.KeyMode.PRESS_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.doKeyPress(keyCodes[i]);
            }
        } else if (mode == IRobot.KeyMode.RELEASE_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.doKeyRelease(keyCodes[i]);
            }
        } else {
            int i;
            for (i = 0; i < keyCodes.length; ++i) {
                this.doKeyPress(keyCodes[i]);
            }
            for (i = 0; i < keyCodes.length; ++i) {
                this.doKeyRelease(keyCodes[i]);
            }
        }
        this.waitForIdle();
    }

    @Override
    public void typeChar(char character, IRobot.KeyMode mode) {
        Debug.log(4, "Robot: doType: %s ( %d )", new Object[]{KeyEvent.getKeyText(Key.toJavaKeyCode(character)[0]).toString(), Key.toJavaKeyCode(character)[0]});
        this.doType(mode, Key.toJavaKeyCode(character));
    }

    @Override
    public void typeKey(int key) {
        Debug.log(4, "Robot: doType: %s ( %d )", new Object[]{KeyEvent.getKeyText(key), key});
        if (Settings.isMac()) {
            if (key == Key.toJavaKeyCodeFromText("#N.")) {
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#C."));
                this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#C."));
                return;
            }
            if (key == Key.toJavaKeyCodeFromText("#T.")) {
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#C."));
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#A."));
                this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#A."));
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#C."));
                return;
            }
            if (key == Key.toJavaKeyCodeFromText("#X.")) {
                key = Key.toJavaKeyCodeFromText("#T.");
                this.doType(IRobot.KeyMode.PRESS_ONLY, Key.toJavaKeyCodeFromText("#A."));
                this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
                this.doType(IRobot.KeyMode.RELEASE_ONLY, Key.toJavaKeyCodeFromText("#A."));
                return;
            }
        }
        this.doType(IRobot.KeyMode.PRESS_RELEASE, key);
    }

    @Override
    public void typeStarts() {
    }

    @Override
    public void typeEnds() {
    }

    @Override
    public void cleanup() {
    }
}

