/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.sikuli.basics.Animator;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.util.OverlayTransparentWindow;

public class ScreenHighlighter
extends OverlayTransparentWindow
implements MouseListener {
    static Color _transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.2f);
    Color _targetColor = Color.RED;
    static final int TARGET_SIZE = 50;
    static final int DRAGGING_TIME = 200;
    static int MARGIN = 20;
    static Set<ScreenHighlighter> _opened = new HashSet<ScreenHighlighter>();
    IScreen _scr;
    BufferedImage _screen = null;
    BufferedImage _darker_screen = null;
    BufferedImage bi = null;
    int srcx;
    int srcy;
    int destx;
    int desty;
    Location _lastTarget;
    boolean _borderOnly = false;
    Animator _anim;
    BasicStroke _StrokeCross = new BasicStroke(1.0f);
    BasicStroke _StrokeCircle = new BasicStroke(2.0f);
    BasicStroke _StrokeBorder = new BasicStroke(3.0f);
    Animator _aniX;
    Animator _aniY;
    boolean noWaitAfter = false;
    boolean _native_transparent = false;
    boolean _double_buffered = false;
    boolean _isTransparentSupported = false;

    public ScreenHighlighter(IScreen scr, String color) {
        this._scr = scr;
        this.init();
        this.setVisible(false);
        this.setAlwaysOnTop(true);
        if (color != null) {
            if (color.startsWith("#")) {
                if (color.length() > 7) {
                    if (color.length() == 10) {
                        int cR = 255;
                        int cG = 0;
                        int cB = 0;
                        try {
                            cR = Integer.decode(color.substring(1, 4));
                            cG = Integer.decode(color.substring(4, 7));
                            cB = Integer.decode(color.substring(7, 10));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            this._targetColor = new Color(cR, cG, cB);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                } else {
                    try {
                        this._targetColor = new Color(Integer.decode(color));
                    }
                    catch (NumberFormatException cR) {}
                }
            } else {
                if (!color.endsWith("Gray") || "Gray".equals(color)) {
                    color = color.toUpperCase();
                }
                try {
                    Field field = Class.forName("java.awt.Color").getField(color);
                    this._targetColor = (Color)field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void init() {
        _opened.add(this);
        if (Settings.isLinux()) {
            this._double_buffered = true;
        } else if (Settings.isMac()) {
            this._native_transparent = true;
        }
        GraphicsDevice screenDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this._isTransparentSupported = screenDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && screenDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT) && screenDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
        this.addMouseListener(this);
    }

    public void setWaitAfter(boolean state) {
        this.noWaitAfter = state;
    }

    @Override
    public void close() {
        this.setVisible(false);
        _opened.remove(this);
        this.clean();
        if (!this.noWaitAfter) {
            try {
                Thread.sleep((int)(Settings.WaitAfterHighlight > 0.3f ? Settings.WaitAfterHighlight * 1000.0f - 300.0f : 300.0f));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void closeAfter(float secs) {
        try {
            Thread.sleep((int)secs * 1000 - 300);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.close();
    }

    public static void closeAll() {
        if (_opened.size() > 0) {
            Debug.log(3, "ScreenHighlighter: Removing all highlights", new Object[0]);
            for (ScreenHighlighter s : _opened) {
                if (!s.isVisible()) continue;
                s.setVisible(false);
                s.clean();
            }
            _opened.clear();
        }
    }

    private void clean() {
        this.dispose();
        this._screen = null;
        this._darker_screen = null;
        this.bi = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setVisible(false);
    }

    public void highlight(Region r_) {
        if (!this._isTransparentSupported) {
            Debug.log(3, "highlight transparent is not supported on " + System.getProperty("os.name") + "!", new Object[0]);
            _transparentColor = Color.pink;
        }
        this._borderOnly = true;
        Region r = r_.grow(3);
        if (!this._native_transparent) {
            this.captureScreen(r.x, r.y, r.w, r.h);
        }
        this.setLocation(r.x, r.y);
        this.setSize(r.w, r.h);
        this.setBackground(_transparentColor);
        this.setVisible(true);
        this.requestFocus();
    }

    protected boolean isWindowTranslucencySupported() {
        if (Settings.isLinux()) {
            GraphicsDevice screenDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            return screenDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT) && screenDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT) && screenDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
        }
        return true;
    }

    public void highlight(Region r_, float secs) {
        this.highlight(r_);
        this.closeAfter(secs);
    }

    public void showTarget(Location loc, float secs) {
        int w = 50;
        int h = 50;
        int x = loc.x - 25;
        int y = loc.y - 25;
        this._lastTarget = loc;
        Debug.log(2, "showTarget " + x + " " + y + " " + 50 + " " + 50, new Object[0]);
        this.showWindow(x, y, 50, 50, secs);
    }

    private void captureScreen(int x, int y, int w, int h) {
        ScreenImage img = ((Screen)this._scr).captureforHighlight(x, y, w, h);
        this._screen = img.getImage();
        float scaleFactor = 0.6f;
        RescaleOp op = new RescaleOp(scaleFactor, 0.0f, null);
        this._darker_screen = op.filter(this._screen, null);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._native_transparent || this._screen != null) {
            Graphics2D g2d;
            if (this._double_buffered) {
                Graphics2D bfG2;
                if (this.bi == null || this.bi.getWidth(this) != this.getWidth() || this.bi.getHeight(this) != this.getHeight()) {
                    this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                }
                g2d = bfG2 = this.bi.createGraphics();
            } else {
                g2d = (Graphics2D)g;
            }
            g2d.setComposite(AlphaComposite.getInstance(1));
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this._borderOnly) {
                if (!this._native_transparent) {
                    g2d.drawImage((Image)this._screen, 0, 0, this);
                }
                this.drawBorder(g2d);
            } else {
                if (!this._native_transparent) {
                    g2d.drawImage((Image)this._screen, 0, 0, this);
                }
                this.drawTarget(g2d);
            }
            if (this._double_buffered) {
                ((Graphics2D)g).drawImage((Image)this.bi, 0, 0, this);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    private void drawBorder(Graphics2D g2d) {
        g2d.setColor(this._targetColor);
        g2d.setStroke(this._StrokeBorder);
        int w = (int)this._StrokeBorder.getLineWidth();
        g2d.drawRect(w / 2, w / 2, this.getWidth() - w, this.getHeight() - w);
    }

    private void drawTarget(Graphics2D g2d) {
        int r = 25;
        g2d.setColor(Color.black);
        g2d.setStroke(this._StrokeCross);
        g2d.drawLine(0, r, r * 2, r);
        g2d.drawLine(r, 0, r, r * 2);
        g2d.setColor(this._targetColor);
        g2d.setStroke(this._StrokeCircle);
        this.drawCircle(r, r, r - 4, g2d);
        this.drawCircle(r, r, r - 10, g2d);
    }

    private void drawCircle(int x, int y, int radius, Graphics g) {
        g.drawOval(x - radius, y - radius, radius * 2, radius * 2);
    }

    private void showWindow(int x, int y, int w, int h, float secs) {
        if (!this._native_transparent) {
            this.captureScreen(x, y, w, h);
        }
        this.setLocation(x, y);
        this.setSize(w, h);
        this.setBackground(this._targetColor);
        this.repaint();
        this.setVisible(true);
        this.requestFocus();
        this.closeAfter(secs);
    }
}

