/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.IntIterator;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class _BitIntSet
extends TestCase {
    public void test_basic() {
        BitIntSet set = new BitIntSet(32);
        _BitIntSet.assertEquals((int)0, (int)set.elements());
        set.add(0);
        set.add(1);
        set.add(31);
        _BitIntSet.assertTrue((boolean)set.has(0));
        _BitIntSet.assertTrue((boolean)set.has(1));
        _BitIntSet.assertTrue((boolean)set.has(31));
        _BitIntSet.assertEquals((int)3, (int)set.elements());
        _BitIntSet.assertFalse((boolean)set.has(2));
        _BitIntSet.assertFalse((boolean)set.has(7));
        _BitIntSet.assertFalse((boolean)set.has(30));
    }

    public void test_iterator() {
        BitIntSet set = new BitIntSet(32);
        set.add(0);
        set.add(0);
        set.add(1);
        set.add(1);
        set.add(31);
        set.add(31);
        IntIterator iter = set.iterator();
        _BitIntSet.assertTrue((boolean)iter.hasNext());
        _BitIntSet.assertEquals((int)iter.next(), (int)0);
        _BitIntSet.assertTrue((boolean)iter.hasNext());
        _BitIntSet.assertEquals((int)iter.next(), (int)1);
        _BitIntSet.assertTrue((boolean)iter.hasNext());
        _BitIntSet.assertEquals((int)iter.next(), (int)31);
        _BitIntSet.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            _BitIntSet.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test_remove() {
        BitIntSet set = new BitIntSet(32);
        set.add(0);
        set.add(1);
        set.add(31);
        _BitIntSet.assertTrue((boolean)set.has(0));
        _BitIntSet.assertTrue((boolean)set.has(1));
        _BitIntSet.assertTrue((boolean)set.has(31));
        _BitIntSet.assertFalse((boolean)set.has(2));
        _BitIntSet.assertFalse((boolean)set.has(7));
        _BitIntSet.assertFalse((boolean)set.has(30));
        set.remove(0);
        _BitIntSet.assertFalse((boolean)set.has(0));
        _BitIntSet.assertTrue((boolean)set.has(1));
        _BitIntSet.assertTrue((boolean)set.has(31));
    }

    public void test_expand() {
        BitIntSet set = new BitIntSet(32);
        int[] values = new int[]{0, 1, 31, 32, 128};
        for (int i = 0; i < values.length; ++i) {
            set.add(values[i]);
        }
        IntIterator iter = set.iterator();
        for (int i = 0; i < values.length; ++i) {
            _BitIntSet.assertTrue((boolean)iter.hasNext());
            _BitIntSet.assertEquals((int)values[i], (int)iter.next());
        }
        _BitIntSet.assertFalse((boolean)iter.hasNext());
    }

    public void test_merge() {
        int i;
        BitIntSet setA = new BitIntSet(32);
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        BitIntSet setB = new BitIntSet(32);
        int[] valuesB = new int[]{0, 5, 6, 8, 31};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _BitIntSet.assertTrue((boolean)setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _BitIntSet.assertTrue((boolean)setA.has(valuesB[i]));
        }
    }

    public void test_mergeWithListIntSet() {
        int i;
        BitIntSet setA = new BitIntSet(32);
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        ListIntSet setB = new ListIntSet();
        int[] valuesB = new int[]{0, 5, 6, 8, 31};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _BitIntSet.assertTrue((boolean)setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _BitIntSet.assertTrue((boolean)setA.has(valuesB[i]));
        }
    }

    public void test_mergeAndExpand() {
        int i;
        BitIntSet setA = new BitIntSet(32);
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        BitIntSet setB = new BitIntSet(32);
        int[] valuesB = new int[]{0, 5, 6, 32, 127};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _BitIntSet.assertTrue((boolean)setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _BitIntSet.assertTrue((boolean)setA.has(valuesB[i]));
        }
    }

    public void test_toString() {
        BitIntSet set = new BitIntSet(32);
        _BitIntSet.assertEquals((String)set.toString(), (String)"{}");
        set.add(1);
        _BitIntSet.assertEquals((String)set.toString(), (String)"{1}");
        set.add(2);
        _BitIntSet.assertEquals((String)set.toString(), (String)"{1, 2}");
    }
}

