/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util._tests;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.IntIterator;
import com.android.dx.util.ListIntSet;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

public class _ListIntSet
extends TestCase {
    public void test_basic() {
        ListIntSet set = new ListIntSet();
        _ListIntSet.assertEquals((int)0, (int)set.elements());
        set.add(31);
        set.add(0);
        set.add(1);
        _ListIntSet.assertTrue((boolean)set.has(0));
        _ListIntSet.assertTrue((boolean)set.has(1));
        _ListIntSet.assertTrue((boolean)set.has(31));
        _ListIntSet.assertEquals((int)3, (int)set.elements());
        _ListIntSet.assertFalse((boolean)set.has(2));
        _ListIntSet.assertFalse((boolean)set.has(7));
        _ListIntSet.assertFalse((boolean)set.has(30));
    }

    public void test_iterator() {
        ListIntSet set = new ListIntSet();
        set.add(0);
        set.add(0);
        set.add(1);
        set.add(1);
        set.add(31);
        set.add(31);
        IntIterator iter = set.iterator();
        _ListIntSet.assertTrue((boolean)iter.hasNext());
        _ListIntSet.assertEquals((int)iter.next(), (int)0);
        _ListIntSet.assertTrue((boolean)iter.hasNext());
        _ListIntSet.assertEquals((int)iter.next(), (int)1);
        _ListIntSet.assertTrue((boolean)iter.hasNext());
        _ListIntSet.assertEquals((int)iter.next(), (int)31);
        _ListIntSet.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            _ListIntSet.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test_empty() {
        ListIntSet set = new ListIntSet();
        IntIterator iter = set.iterator();
        _ListIntSet.assertFalse((boolean)iter.hasNext());
    }

    public void test_remove() {
        ListIntSet set = new ListIntSet();
        set.add(0);
        set.add(1);
        set.add(31);
        _ListIntSet.assertTrue((boolean)set.has(0));
        _ListIntSet.assertTrue((boolean)set.has(1));
        _ListIntSet.assertTrue((boolean)set.has(31));
        _ListIntSet.assertFalse((boolean)set.has(2));
        _ListIntSet.assertFalse((boolean)set.has(7));
        _ListIntSet.assertFalse((boolean)set.has(30));
        set.remove(0);
        _ListIntSet.assertFalse((boolean)set.has(0));
        _ListIntSet.assertTrue((boolean)set.has(1));
        _ListIntSet.assertTrue((boolean)set.has(31));
    }

    public void test_mergeA() {
        int i;
        ListIntSet setA = new ListIntSet();
        int[] valuesA = new int[]{0, 1, 31};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        ListIntSet setB = new ListIntSet();
        int[] valuesB = new int[]{0, 5, 6, 32, 127, 128};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _ListIntSet.assertTrue((boolean)setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _ListIntSet.assertTrue((boolean)setA.has(valuesB[i]));
        }
    }

    public void test_mergeB() {
        int i;
        ListIntSet setA = new ListIntSet();
        int[] valuesA = new int[]{0, 1, 31, 129, 130};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        ListIntSet setB = new ListIntSet();
        int[] valuesB = new int[]{0, 5, 6, 32, 127, 128};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _ListIntSet.assertTrue((boolean)setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _ListIntSet.assertTrue((boolean)setA.has(valuesB[i]));
        }
    }

    public void test_mergeWithBitIntSet() {
        int i;
        ListIntSet setA = new ListIntSet();
        int[] valuesA = new int[]{0, 1, 31, 129, 130};
        for (int i2 = 0; i2 < valuesA.length; ++i2) {
            setA.add(valuesA[i2]);
        }
        BitIntSet setB = new BitIntSet(129);
        int[] valuesB = new int[]{0, 5, 6, 32, 127, 128};
        for (i = 0; i < valuesB.length; ++i) {
            setB.add(valuesB[i]);
        }
        setA.merge(setB);
        for (i = 0; i < valuesA.length; ++i) {
            _ListIntSet.assertTrue((boolean)setA.has(valuesA[i]));
        }
        for (i = 0; i < valuesB.length; ++i) {
            _ListIntSet.assertTrue((boolean)setA.has(valuesB[i]));
        }
    }

    public void test_toString() {
        ListIntSet set = new ListIntSet();
        _ListIntSet.assertEquals((String)set.toString(), (String)"{}");
        set.add(1);
        _ListIntSet.assertEquals((String)set.toString(), (String)"{1}");
        set.add(2);
        _ListIntSet.assertEquals((String)set.toString(), (String)"{1, 2}");
    }
}

