/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.EndOfStream;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdInStreamBlockCallback;
import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.SystemException;
import com.tigervnc.rdr.TimedOut;

public class FdInStream
extends InStream {
    static final int DEFAULT_BUF_SIZE = 16384;
    static final int minBulkSize = 1024;
    private FileDescriptor fd;
    boolean closeWhenDone;
    protected int timeoutms;
    private FdInStreamBlockCallback blockCallback;
    private int offset;
    private int bufSize;
    protected boolean timing;
    protected long timeWaitedIn100us;
    protected long timedKbits;

    public FdInStream(FileDescriptor fd_, int timeoutms_, int bufSize_, boolean closeWhenDone_) {
        this.fd = fd_;
        this.closeWhenDone = closeWhenDone_;
        this.timeoutms = timeoutms_;
        this.blockCallback = null;
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
        this.bufSize = bufSize_ > 0 ? bufSize_ : 16384;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.end = 0;
        this.ptr = 0;
    }

    public FdInStream(FileDescriptor fd_) {
        this(fd_, -1, 0, false);
    }

    public FdInStream(FileDescriptor fd_, FdInStreamBlockCallback blockCallback_, int bufSize_) {
        this.fd = fd_;
        this.timeoutms = 0;
        this.blockCallback = blockCallback_;
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
        this.bufSize = bufSize_ > 0 ? bufSize_ : 16384;
        this.b = new byte[this.bufSize];
        this.offset = 0;
        this.end = 0;
        this.ptr = 0;
    }

    public FdInStream(FileDescriptor fd_, FdInStreamBlockCallback blockCallback_) {
        this(fd_, blockCallback_, 0);
    }

    @Override
    public final void readBytes(byte[] data, int dataPtr, int length) {
        if (length < 1024) {
            super.readBytes(data, dataPtr, length);
            return;
        }
        int n = this.end - this.ptr;
        if (n > length) {
            n = length;
        }
        System.arraycopy(this.b, this.ptr, data, dataPtr, n);
        dataPtr += n;
        length -= n;
        this.ptr += n;
        while (length > 0) {
            n = this.readWithTimeoutOrCallback(data, dataPtr, length);
            dataPtr += n;
            length -= n;
            this.offset += n;
        }
    }

    public void setTimeout(int timeoutms_) {
        this.timeoutms = timeoutms_;
    }

    public void setBlockCallback(FdInStreamBlockCallback blockCallback_) {
        this.blockCallback = blockCallback_;
        this.timeoutms = 0;
    }

    @Override
    public final int pos() {
        return this.offset + this.ptr;
    }

    public final void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public final void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public final long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public final long timeWaited() {
        return this.timeWaitedIn100us;
    }

    @Override
    protected int overrun(int itemSize, int nItems, boolean wait) {
        if (itemSize > this.bufSize) {
            throw new Exception("FdInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.offset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < itemSize) {
            int n;
            int bytes_to_read = this.bufSize - this.end;
            if (!this.timing) {
                bytes_to_read = Math.min(bytes_to_read, Math.max(itemSize * nItems, 8));
            }
            if ((n = this.readWithTimeoutOrCallback(this.b, this.end, bytes_to_read, wait)) == 0) {
                return 0;
            }
            this.end += n;
        }
        if (itemSize * nItems > this.end - this.ptr) {
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    protected int readWithTimeoutOrCallback(byte[] buf, int bufPtr, int len, boolean wait) {
        int n;
        long before = 0L;
        if (this.timing) {
            before = System.nanoTime();
        }
        while (true) {
            Integer tv = !wait ? new Integer(0) : (this.timeoutms != -1 ? new Integer(this.timeoutms) : null);
            try {
                n = this.fd.select(1, tv);
            }
            catch (Exception e) {
                throw new SystemException("select:" + e.toString());
            }
            if (n < 0) continue;
            if (n > 0) break;
            if (!wait) {
                return 0;
            }
            if (this.blockCallback == null) {
                throw new TimedOut();
            }
            this.blockCallback.blockCallback();
        }
        try {
            n = this.fd.read(buf, bufPtr, len);
        }
        catch (Exception e) {
            throw new SystemException("read:" + e.toString());
        }
        if (n == 0) {
            throw new EndOfStream();
        }
        if (this.timing) {
            int newKbits;
            long after = System.nanoTime();
            long newTimeWaited = (after - before) / 100000L;
            if (newTimeWaited > (long)((newKbits = n * 8 / 1000) * 1000)) {
                newTimeWaited = newKbits * 1000;
            } else if (newTimeWaited < (long)(newKbits / 4)) {
                newTimeWaited = newKbits / 4;
            }
            this.timeWaitedIn100us += newTimeWaited;
            this.timedKbits += (long)newKbits;
        }
        return n;
    }

    private int readWithTimeoutOrCallback(byte[] buf, int bufPtr, int len) {
        return this.readWithTimeoutOrCallback(buf, bufPtr, len, true);
    }

    public FileDescriptor getFd() {
        return this.fd;
    }

    public void setFd(FileDescriptor fd_) {
        this.fd = fd_;
    }

    public int getBufSize() {
        return this.bufSize;
    }
}

