/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.network.SSLEngineManager;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.TLSException;
import java.io.IOException;
import javax.net.ssl.SSLSession;

public class TLSInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private SSLEngineManager manager;
    private int offset;
    private int start;
    private int bufSize;
    private FdInStream in;

    public TLSInStream(InStream _in, SSLEngineManager _manager) {
        this.in = (FdInStream)_in;
        this.manager = _manager;
        this.offset = 0;
        SSLSession session = this.manager.getSession();
        this.bufSize = session.getApplicationBufferSize();
        this.b = new byte[this.bufSize];
        this.start = 0;
        this.end = 0;
        this.ptr = 0;
    }

    @Override
    public final int pos() {
        return this.offset + this.ptr - this.start;
    }

    public final void startTiming() {
        this.in.startTiming();
    }

    public final void stopTiming() {
        this.in.stopTiming();
    }

    public final long kbitsPerSecond() {
        return this.in.kbitsPerSecond();
    }

    public final long timeWaited() {
        return this.in.timeWaited();
    }

    @Override
    protected final int overrun(int itemSize, int nItems, boolean wait) {
        if (itemSize > this.bufSize) {
            throw new Exception("TLSInStream overrun: max itemSize exceeded");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.offset += this.ptr - this.start;
        this.end -= this.ptr - this.start;
        this.ptr = this.start;
        while (this.end < this.start + itemSize) {
            int n = this.readTLS(this.b, this.end, this.start + this.bufSize - this.end, wait);
            if (!wait && n == 0) {
                return 0;
            }
            this.end += n;
        }
        if (itemSize * nItems > this.end - this.ptr) {
            nItems = (this.end - this.ptr) / itemSize;
        }
        return nItems;
    }

    protected int readTLS(byte[] buf, int bufPtr, int len, boolean wait) {
        int n = -1;
        try {
            n = this.manager.read(buf, bufPtr, len);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (n < 0) {
            throw new TLSException("readTLS", n);
        }
        return n;
    }
}

