/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class CMsgWriter {
    ConnParams cp;
    OutStream os;
    static LogWriter vlog = new LogWriter("CMsgWriter");

    public abstract void writeClientInit(boolean var1);

    public synchronized void writeSetPixelFormat(PixelFormat pf) {
        this.startMsg(0);
        this.os.pad(3);
        pf.write(this.os);
        this.endMsg();
    }

    public synchronized void writeSetEncodings(int nEncodings, int[] encodings) {
        this.startMsg(2);
        this.os.skip(1);
        this.os.writeU16(nEncodings);
        for (int i = 0; i < nEncodings; ++i) {
            this.os.writeU32(encodings[i]);
        }
        this.endMsg();
    }

    public synchronized void writeSetEncodings(int preferredEncoding, boolean useCopyRect) {
        int nEncodings = 0;
        int[] encodings = new int[258];
        if (this.cp.supportsLocalCursor) {
            encodings[nEncodings++] = -239;
        }
        if (this.cp.supportsDesktopResize) {
            encodings[nEncodings++] = -223;
        }
        if (this.cp.supportsExtendedDesktopSize) {
            encodings[nEncodings++] = -308;
        }
        if (this.cp.supportsDesktopRename) {
            encodings[nEncodings++] = -307;
        }
        if (this.cp.supportsClientRedirect) {
            encodings[nEncodings++] = -311;
        }
        encodings[nEncodings++] = -224;
        encodings[nEncodings++] = -313;
        encodings[nEncodings++] = -312;
        if (Decoder.supported(preferredEncoding)) {
            encodings[nEncodings++] = preferredEncoding;
        }
        if (useCopyRect) {
            encodings[nEncodings++] = 1;
        }
        if (preferredEncoding != 7 && Decoder.supported(7)) {
            encodings[nEncodings++] = 7;
        }
        if (preferredEncoding != 16 && Decoder.supported(16)) {
            encodings[nEncodings++] = 16;
        }
        if (preferredEncoding != 5 && Decoder.supported(5)) {
            encodings[nEncodings++] = 5;
        }
        block3: for (int i = 255; i >= 0; --i) {
            switch (i) {
                case 5: 
                case 7: 
                case 16: {
                    continue block3;
                }
                default: {
                    if (i == preferredEncoding || !Decoder.supported(i)) continue block3;
                    encodings[nEncodings++] = i;
                }
            }
        }
        encodings[nEncodings++] = -224;
        if (this.cp.customCompressLevel && this.cp.compressLevel >= 0 && this.cp.compressLevel <= 9) {
            encodings[nEncodings++] = -256 + this.cp.compressLevel;
        }
        if (!this.cp.noJpeg && this.cp.qualityLevel >= 0 && this.cp.qualityLevel <= 9) {
            encodings[nEncodings++] = -32 + this.cp.qualityLevel;
        }
        this.writeSetEncodings(nEncodings, encodings);
    }

    public synchronized void writeFramebufferUpdateRequest(Rect r, boolean incremental) {
        this.startMsg(3);
        this.os.writeU8(incremental ? 1 : 0);
        this.os.writeU16(r.tl.x);
        this.os.writeU16(r.tl.y);
        this.os.writeU16(r.width());
        this.os.writeU16(r.height());
        this.endMsg();
    }

    public synchronized void writeKeyEvent(int key, boolean down) {
        this.startMsg(4);
        this.os.writeU8(down ? 1 : 0);
        this.os.pad(2);
        this.os.writeU32(key);
        this.endMsg();
    }

    public synchronized void writePointerEvent(Point pos, int buttonMask) {
        Point p = new Point(pos.x, pos.y);
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        if (p.x >= this.cp.width) {
            p.x = this.cp.width - 1;
        }
        if (p.y >= this.cp.height) {
            p.y = this.cp.height - 1;
        }
        this.startMsg(5);
        this.os.writeU8(buttonMask);
        this.os.writeU16(p.x);
        this.os.writeU16(p.y);
        this.endMsg();
    }

    public synchronized void writeClientCutText(String str, int len) {
        this.startMsg(6);
        this.os.pad(3);
        this.os.writeU32(len);
        Charset latin1 = Charset.forName("ISO-8859-1");
        ByteBuffer bytes = latin1.encode(str);
        this.os.writeBytes(bytes.array(), 0, len);
        this.endMsg();
    }

    public abstract void startMsg(int var1);

    public abstract void endMsg();

    public synchronized void setOutStream(OutStream os_) {
        this.os = os_;
    }

    ConnParams getConnParams() {
        return this.cp;
    }

    OutStream getOutStream() {
        return this.os;
    }

    protected CMsgWriter(ConnParams cp_, OutStream os_) {
        this.cp = cp_;
        this.os = os_;
    }
}

