/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.CSecurityTLS;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Encodings;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.Tunnel;
import com.tigervnc.vncviewer.UserPreferences;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class OptionsDialog
extends Dialog {
    static LogWriter vlog = new LogWriter("OptionsDialog");
    CConn cc;
    JComboBox menuKey;
    JComboBox compressLevel;
    JComboBox qualityLevel;
    JComboBox scalingFactor;
    ButtonGroup encodingGroup;
    ButtonGroup colourGroup;
    ButtonGroup sshArgsGroup;
    JRadioButton zrle;
    JRadioButton hextile;
    JRadioButton tight;
    JRadioButton raw;
    JRadioButton fullColour;
    JRadioButton mediumColour;
    JRadioButton lowColour;
    JRadioButton veryLowColour;
    JRadioButton sshArgsDefault;
    JRadioButton sshArgsCustom;
    JCheckBox autoSelect;
    JCheckBox customCompressLevel;
    JCheckBox noJpeg;
    JCheckBox viewOnly;
    JCheckBox acceptClipboard;
    JCheckBox sendClipboard;
    JCheckBox acceptBell;
    JCheckBox desktopSize;
    JCheckBox fullScreen;
    JCheckBox fullScreenAllMonitors;
    JCheckBox shared;
    JCheckBox useLocalCursor;
    JCheckBox secVeNCrypt;
    JCheckBox encNone;
    JCheckBox encTLS;
    JCheckBox encX509;
    JCheckBox secNone;
    JCheckBox secVnc;
    JCheckBox secPlain;
    JCheckBox secIdent;
    JCheckBox sendLocalUsername;
    JCheckBox sshTunnel;
    JCheckBox sshUseExt;
    JCheckBox sshUseGateway;
    JButton okButton;
    JButton cancelButton;
    JButton caButton;
    JButton crlButton;
    JButton cfLoadButton;
    JButton cfSaveAsButton;
    JButton defSaveButton;
    JButton defReloadButton;
    JButton defClearButton;
    JButton sshConfigBrowser;
    JButton sshKeyFileBrowser;
    JButton sshClientBrowser;
    JTextField desktopWidth;
    JTextField desktopHeight;
    JTextField x509ca;
    JTextField x509crl;
    JTextField sshUser;
    JTextField sshHost;
    JTextField sshPort;
    JTextField sshClient;
    JTextField sshArguments;
    JTextField sshConfig;
    JTextField sshKeyFile;
    JTabbedPane tabPane;

    public OptionsDialog(CConn cc_) {
        super(true);
        this.cc = cc_;
        this.setTitle("VNC Viewer Options");
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.tabPane = new JTabbedPane();
        this.tabPane.setTabLayoutPolicy(1);
        this.encodingGroup = new ButtonGroup();
        this.colourGroup = new ButtonGroup();
        this.sshArgsGroup = new ButtonGroup();
        int indent = 0;
        JPanel FormatPanel = new JPanel();
        FormatPanel.setLayout(new BoxLayout(FormatPanel, 3));
        FormatPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel autoSelectPane = new JPanel();
        autoSelectPane.setLayout(new BoxLayout(autoSelectPane, 2));
        autoSelectPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.autoSelect = new JCheckBox("Auto Select");
        autoSelectPane.add(this.autoSelect);
        autoSelectPane.add(Box.createHorizontalGlue());
        JPanel encodingPanel = new JPanel(new GridLayout(4, 1));
        encodingPanel.setBorder(BorderFactory.createTitledBorder("Preferred encoding"));
        this.tight = new Dialog.GroupedJRadioButton(this, "Tight", this.encodingGroup, encodingPanel);
        this.zrle = new Dialog.GroupedJRadioButton(this, "ZRLE", this.encodingGroup, encodingPanel);
        this.hextile = new Dialog.GroupedJRadioButton(this, "Hextile", this.encodingGroup, encodingPanel);
        this.raw = new Dialog.GroupedJRadioButton(this, "Raw", this.encodingGroup, encodingPanel);
        JPanel colourPanel = new JPanel(new GridLayout(4, 1));
        colourPanel.setBorder(BorderFactory.createTitledBorder("Color level"));
        this.fullColour = new Dialog.GroupedJRadioButton(this, "Full (all available colors)", this.colourGroup, colourPanel);
        this.mediumColour = new Dialog.GroupedJRadioButton(this, "Medium (256 colors)", this.colourGroup, colourPanel);
        this.lowColour = new Dialog.GroupedJRadioButton(this, "Low (64 colours)", this.colourGroup, colourPanel);
        this.veryLowColour = new Dialog.GroupedJRadioButton(this, "Very low(8 colors)", this.colourGroup, colourPanel);
        JPanel encodingPane = new JPanel(new GridLayout(1, 2, 5, 0));
        encodingPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        encodingPane.add(encodingPanel);
        encodingPane.add(colourPanel);
        JPanel tightPanel = new JPanel(new GridBagLayout());
        this.customCompressLevel = new JCheckBox("Custom Compression Level");
        Object[] compressionLevels = new Object[]{1, 2, 3, 4, 5, 6};
        this.compressLevel = new Dialog.MyJComboBox(this, compressionLevels);
        ((Dialog.MyJComboBox)this.compressLevel).setDocument(new IntegerDocument(1));
        this.compressLevel.setPrototypeDisplayValue("0.");
        this.compressLevel.setEditable(true);
        JLabel compressionLabel = new JLabel("Level (1=fast, 6=best [4-6 are rarely useful])");
        this.noJpeg = new JCheckBox("Allow JPEG Compression");
        Object[] qualityLevels = new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.qualityLevel = new Dialog.MyJComboBox(this, qualityLevels);
        this.qualityLevel.setPrototypeDisplayValue("0.");
        JLabel qualityLabel = new JLabel("Quality (0=poor, 9=best)");
        tightPanel.add((Component)this.customCompressLevel, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        indent = this.getButtonLabelInset(this.customCompressLevel);
        tightPanel.add((Component)this.compressLevel, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, indent, 0, 0), 0, 0));
        tightPanel.add((Component)compressionLabel, new GridBagConstraints(1, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        tightPanel.add((Component)this.noJpeg, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
        indent = this.getButtonLabelInset(this.noJpeg);
        tightPanel.add((Component)this.qualityLevel, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, indent, 0, 0), 0, 0));
        tightPanel.add((Component)qualityLabel, new GridBagConstraints(1, 3, 1, 1, HEAVY, 0.0, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        tightPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 4, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        FormatPanel.add(autoSelectPane);
        FormatPanel.add(encodingPane);
        FormatPanel.add(tightPanel);
        JPanel SecPanel = new JPanel();
        SecPanel.setLayout(new BoxLayout(SecPanel, 3));
        SecPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel vencryptPane = new JPanel();
        vencryptPane.setLayout(new BoxLayout(vencryptPane, 2));
        vencryptPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.secVeNCrypt = new JCheckBox("Extended encryption and authentication methods (VeNCrypt)");
        vencryptPane.add(this.secVeNCrypt);
        vencryptPane.add(Box.createHorizontalGlue());
        JPanel encrPanel = new JPanel(new GridBagLayout());
        encrPanel.setBorder(BorderFactory.createTitledBorder("Encryption"));
        this.encNone = new JCheckBox("None");
        this.encTLS = new JCheckBox("Anonymous TLS");
        this.encX509 = new JCheckBox("TLS with X.509 certificates");
        JLabel caLabel = new JLabel("X.509 CA Certificate");
        this.x509ca = new JTextField();
        this.x509ca.setName(Configuration.getParam("x509ca").getName());
        this.caButton = new JButton("Browse");
        JLabel crlLabel = new JLabel("X.509 CRL file");
        this.x509crl = new JTextField();
        this.x509crl.setName(Configuration.getParam("x509crl").getName());
        this.crlButton = new JButton("Browse");
        encrPanel.add((Component)this.encNone, new GridBagConstraints(0, 0, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        encrPanel.add((Component)this.encTLS, new GridBagConstraints(0, 1, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        encrPanel.add((Component)this.encX509, new GridBagConstraints(0, 2, 3, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        indent = this.getButtonLabelInset(this.encX509);
        encrPanel.add((Component)caLabel, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 22, 0, new Insets(0, indent, 5, 0), 0, 0));
        encrPanel.add((Component)this.x509ca, new GridBagConstraints(1, 3, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 5, 0), 0, 0));
        encrPanel.add((Component)this.caButton, new GridBagConstraints(2, 3, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 5, 0), 0, 0));
        encrPanel.add((Component)crlLabel, new GridBagConstraints(0, 4, 1, 1, LIGHT, LIGHT, 22, 0, new Insets(0, indent, 0, 0), 0, 0));
        encrPanel.add((Component)this.x509crl, new GridBagConstraints(1, 4, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        encrPanel.add((Component)this.crlButton, new GridBagConstraints(2, 4, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 0, 0), 0, 0));
        JPanel authPanel = new JPanel(new GridBagLayout());
        authPanel.setBorder(BorderFactory.createTitledBorder("Authentication"));
        this.secNone = new JCheckBox("None");
        this.secVnc = new JCheckBox("Standard VNC");
        this.secPlain = new JCheckBox("Plaintext");
        this.secIdent = new JCheckBox("Ident");
        this.sendLocalUsername = new JCheckBox("Send Local Username");
        authPanel.add((Component)this.secNone, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        authPanel.add((Component)this.secVnc, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        authPanel.add((Component)this.secPlain, new GridBagConstraints(0, 2, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 2, 0), 0, 0));
        authPanel.add((Component)this.secIdent, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(2, 0, 0, 0), 0, 0));
        authPanel.add((Component)this.sendLocalUsername, new GridBagConstraints(1, 2, 1, 2, HEAVY, LIGHT, 21, 0, new Insets(2, 20, 2, 0), 0, 0));
        SecPanel.add((Component)vencryptPane, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        SecPanel.add((Component)encrPanel, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        SecPanel.add((Component)authPanel, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        SecPanel.add(Box.createRigidArea(new Dimension(0, 0)), new GridBagConstraints(0, -1, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel inputPanel = new JPanel(new GridBagLayout());
        inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.viewOnly = new JCheckBox("View Only (ignore mouse & keyboard)");
        this.acceptClipboard = new JCheckBox("Accept clipboard from server");
        this.sendClipboard = new JCheckBox("Send clipboard to server");
        JLabel menuKeyLabel = new JLabel("Menu Key");
        String[] menuKeys = new String[MenuKey.getMenuKeySymbolCount()];
        for (int i = 0; i < MenuKey.getMenuKeySymbolCount(); ++i) {
            menuKeys[i] = MenuKey.getKeyText(MenuKey.getMenuKeySymbols()[i]);
        }
        this.menuKey = new JComboBox<String>(menuKeys);
        inputPanel.add((Component)this.viewOnly, new GridBagConstraints(0, 0, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        inputPanel.add((Component)this.acceptClipboard, new GridBagConstraints(0, 1, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        inputPanel.add((Component)this.sendClipboard, new GridBagConstraints(0, 2, 0, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        inputPanel.add((Component)menuKeyLabel, new GridBagConstraints(0, 3, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        inputPanel.add((Component)this.menuKey, new GridBagConstraints(1, 3, 1, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        inputPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 4, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel ScreenPanel = new JPanel(new GridBagLayout());
        ScreenPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.desktopSize = new JCheckBox("Resize remote session on connect");
        this.desktopSize.setEnabled(!this.cc.viewer.embed.getValue() && this.cc.viewer.desktopSize.getValue() != null);
        this.desktopWidth = new IntegerTextField(5);
        this.desktopWidth.setEnabled(this.desktopSize.isSelected());
        this.desktopHeight = new IntegerTextField(5);
        this.desktopHeight.setEnabled(this.desktopSize.isSelected());
        JPanel desktopSizePanel = new JPanel(new FlowLayout(3, 0, 0));
        desktopSizePanel.add(this.desktopWidth);
        desktopSizePanel.add(new JLabel(" x "));
        desktopSizePanel.add(this.desktopHeight);
        this.fullScreen = new JCheckBox("Full-screen mode");
        this.fullScreen.setEnabled(!this.cc.viewer.embed.getValue());
        this.fullScreenAllMonitors = new JCheckBox("Enable full-screen mode over all monitors");
        this.fullScreenAllMonitors.setEnabled(!this.cc.viewer.embed.getValue());
        JLabel scalingFactorLabel = new JLabel("Scaling Factor");
        Object[] scalingFactors = new Object[]{"Auto", "Fixed Aspect Ratio", "50%", "75%", "95%", "100%", "105%", "125%", "150%", "175%", "200%", "250%", "300%", "350%", "400%"};
        this.scalingFactor = new Dialog.MyJComboBox(this, scalingFactors);
        this.scalingFactor.setEditable(true);
        this.scalingFactor.setEnabled(!this.cc.viewer.embed.getValue());
        ScreenPanel.add((Component)this.desktopSize, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        indent = this.getButtonLabelInset(this.desktopSize);
        ScreenPanel.add((Component)desktopSizePanel, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, indent, 0, 0), 0, 0));
        ScreenPanel.add((Component)this.fullScreen, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        indent = this.getButtonLabelInset(this.fullScreen);
        ScreenPanel.add((Component)this.fullScreenAllMonitors, new GridBagConstraints(0, 3, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, indent, 4, 0), 0, 0));
        ScreenPanel.add((Component)scalingFactorLabel, new GridBagConstraints(0, 4, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        ScreenPanel.add((Component)this.scalingFactor, new GridBagConstraints(1, 4, 1, 1, HEAVY, LIGHT, 21, 0, new Insets(0, 5, 4, 0), 0, 0));
        ScreenPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 5, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel MiscPanel = new JPanel(new GridBagLayout());
        MiscPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.shared = new JCheckBox("Shared connection (do not disconnect other viewers)");
        this.useLocalCursor = new JCheckBox("Render cursor locally");
        this.acceptBell = new JCheckBox("Beep when requested by the server");
        MiscPanel.add((Component)this.shared, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        MiscPanel.add((Component)this.useLocalCursor, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        MiscPanel.add((Component)this.acceptBell, new GridBagConstraints(0, 2, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        MiscPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 3, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel sshPanel = new JPanel(new GridBagLayout());
        sshPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.sshTunnel = new JCheckBox("Tunnel VNC over SSH");
        JPanel tunnelPanel = new JPanel(new GridBagLayout());
        this.sshUseGateway = new JCheckBox("Use SSH gateway");
        JLabel sshUserLabel = new JLabel("Username");
        this.sshUser = new JTextField();
        JLabel sshUserAtLabel = new JLabel("@");
        JLabel sshHostLabel = new JLabel("Hostname (or IP address)");
        this.sshHost = new JTextField("");
        JLabel sshPortLabel = new JLabel("Port");
        this.sshPort = new IntegerTextField(5);
        this.sshUseExt = new JCheckBox("Use external SSH client");
        this.sshClient = new JTextField();
        this.sshClient.setName(Configuration.getParam("extSSHClient").getName());
        this.sshClientBrowser = new JButton("Browse");
        JLabel sshConfigLabel = new JLabel("SSH config file");
        this.sshConfig = new JTextField();
        this.sshConfig.setName(Configuration.getParam("sshConfig").getName());
        this.sshConfigBrowser = new JButton("Browse");
        JLabel sshKeyFileLabel = new JLabel("SSH identity file");
        this.sshKeyFile = new JTextField();
        this.sshKeyFile.setName(Configuration.getParam("sshKeyFile").getName());
        this.sshKeyFileBrowser = new JButton("Browse");
        JPanel sshArgsPanel = new JPanel(new GridBagLayout());
        JLabel sshArgsLabel = new JLabel("Arguments:");
        this.sshArgsDefault = new Dialog.GroupedJRadioButton(this, "Default", this.sshArgsGroup, sshArgsPanel);
        this.sshArgsCustom = new Dialog.GroupedJRadioButton(this, "Custom", this.sshArgsGroup, sshArgsPanel);
        this.sshArguments = new JTextField();
        JPanel gatewayPanel = new JPanel(new GridBagLayout());
        gatewayPanel.add((Component)this.sshUseGateway, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        indent = this.getButtonLabelInset(this.sshUseGateway);
        gatewayPanel.add((Component)sshUserLabel, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, indent, 4, 0), 0, 0));
        gatewayPanel.add((Component)sshHostLabel, new GridBagConstraints(2, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        gatewayPanel.add((Component)sshPortLabel, new GridBagConstraints(3, 1, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 5, 4, 0), 0, 0));
        gatewayPanel.add((Component)this.sshUser, new GridBagConstraints(0, 2, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, indent, 0, 0), 0, 0));
        gatewayPanel.add((Component)sshUserAtLabel, new GridBagConstraints(1, 2, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 2, 0, 2), 0, 0));
        gatewayPanel.add((Component)this.sshHost, new GridBagConstraints(2, 2, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        gatewayPanel.add((Component)this.sshPort, new GridBagConstraints(3, 2, 1, 1, LIGHT, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel clientPanel = new JPanel(new GridBagLayout());
        clientPanel.add((Component)this.sshUseExt, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        clientPanel.add((Component)this.sshClient, new GridBagConstraints(1, 0, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        clientPanel.add((Component)this.sshClientBrowser, new GridBagConstraints(2, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        sshArgsPanel.add((Component)sshArgsLabel, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        sshArgsPanel.add((Component)this.sshArgsDefault, new GridBagConstraints(1, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        sshArgsPanel.add((Component)this.sshArgsCustom, new GridBagConstraints(2, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        sshArgsPanel.add((Component)this.sshArguments, new GridBagConstraints(3, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        indent = this.getButtonLabelInset(this.sshUseExt);
        clientPanel.add((Component)sshArgsPanel, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(4, indent, 0, 0), 0, 0));
        JPanel opensshPanel = new JPanel(new GridBagLayout());
        opensshPanel.setBorder(BorderFactory.createTitledBorder("Embedded SSH client configuration"));
        opensshPanel.add((Component)sshConfigLabel, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        opensshPanel.add((Component)this.sshConfig, new GridBagConstraints(1, 0, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 5, 0), 0, 0));
        opensshPanel.add((Component)this.sshConfigBrowser, new GridBagConstraints(2, 0, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 5, 0), 0, 0));
        opensshPanel.add((Component)sshKeyFileLabel, new GridBagConstraints(0, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        opensshPanel.add((Component)this.sshKeyFile, new GridBagConstraints(1, 1, 1, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        opensshPanel.add((Component)this.sshKeyFileBrowser, new GridBagConstraints(2, 1, 1, 1, LIGHT, LIGHT, 21, 3, new Insets(0, 5, 0, 0), 0, 0));
        tunnelPanel.add((Component)gatewayPanel, new GridBagConstraints(0, 0, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        tunnelPanel.add((Component)clientPanel, new GridBagConstraints(0, 1, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 4, 0), 0, 0));
        tunnelPanel.add((Component)opensshPanel, new GridBagConstraints(0, 2, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        sshPanel.add((Component)this.sshTunnel, new GridBagConstraints(0, 0, 0, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 4, 0), 0, 0));
        indent = this.getButtonLabelInset(this.sshTunnel);
        sshPanel.add((Component)tunnelPanel, new GridBagConstraints(0, 2, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(0, indent, 4, 0), 0, 0));
        sshPanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, -1, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel loadSavePanel = new JPanel(new GridBagLayout());
        loadSavePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createTitledBorder("Configuration File"));
        this.cfLoadButton = new JButton("Load");
        this.cfSaveAsButton = new JButton("Save As...");
        configPanel.add((Component)this.cfLoadButton, new GridBagConstraints(0, 0, 1, 1, HEAVY, LIGHT, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        configPanel.add((Component)this.cfSaveAsButton, new GridBagConstraints(0, 1, 1, 1, HEAVY, HEAVY, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel defaultsPanel = new JPanel(new GridBagLayout());
        defaultsPanel.setBorder(BorderFactory.createTitledBorder("Defaults"));
        this.defClearButton = new JButton("Clear");
        this.defReloadButton = new JButton("Reload");
        this.defSaveButton = new JButton("Save");
        defaultsPanel.add((Component)this.defClearButton, new GridBagConstraints(0, 0, 1, 1, HEAVY, LIGHT, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        defaultsPanel.add((Component)this.defReloadButton, new GridBagConstraints(0, 1, 1, 1, HEAVY, LIGHT, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        defaultsPanel.add((Component)this.defSaveButton, new GridBagConstraints(0, 2, 1, 1, HEAVY, HEAVY, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        loadSavePanel.add((Component)configPanel, new GridBagConstraints(0, 0, 1, 1, HEAVY, LIGHT, 19, 2, new Insets(0, 0, 0, 0), 0, 0));
        loadSavePanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(1, 1, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        loadSavePanel.add((Component)defaultsPanel, new GridBagConstraints(2, 0, 1, 1, HEAVY, LIGHT, 19, 2, new Insets(0, 0, 0, 0), 0, 0));
        loadSavePanel.add(Box.createRigidArea(new Dimension(5, 0)), new GridBagConstraints(0, 1, 0, 0, HEAVY, HEAVY, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabPane.addTab("Compression", FormatPanel);
        this.tabPane.addTab("Security", SecPanel);
        this.tabPane.addTab("Input", inputPanel);
        this.tabPane.addTab("Screen", ScreenPanel);
        this.tabPane.addTab("Misc", MiscPanel);
        this.tabPane.addTab("SSH", sshPanel);
        this.tabPane.addTab("Load / Save", loadSavePanel);
        this.tabPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Insets tpi = (Insets)UIManager.get("TabbedPane:TabbedPaneTabArea.contentMargins");
        int minWidth = tpi.left + tpi.right;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            minWidth += this.tabPane.getBoundsAt((int)i).width;
        }
        int minHeight = this.tabPane.getPreferredSize().height;
        if (this.tabPane.getPreferredSize().width < minWidth) {
            this.tabPane.setPreferredSize(new Dimension(minWidth, minHeight));
        }
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        JPanel buttonPane = new JPanel(new GridLayout(1, 5, 10, 10));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        buttonPane.add(Box.createRigidArea(new Dimension()));
        buttonPane.add(Box.createRigidArea(new Dimension()));
        buttonPane.add(Box.createRigidArea(new Dimension()));
        buttonPane.add(this.okButton);
        buttonPane.add(this.cancelButton);
        this.add(this.tabPane);
        this.add(buttonPane);
        this.addListeners(this);
        this.pack();
    }

    @Override
    public void initDialog() {
        if (this.cc != null) {
            this.cc.setOptions();
        }
        this.zrle.setEnabled(!this.autoSelect.isSelected());
        this.hextile.setEnabled(!this.autoSelect.isSelected());
        this.tight.setEnabled(!this.autoSelect.isSelected());
        this.raw.setEnabled(!this.autoSelect.isSelected());
        this.fullColour.setEnabled(!this.autoSelect.isSelected());
        this.mediumColour.setEnabled(!this.autoSelect.isSelected());
        this.lowColour.setEnabled(!this.autoSelect.isSelected());
        this.veryLowColour.setEnabled(!this.autoSelect.isSelected());
        this.compressLevel.setEnabled(this.customCompressLevel.isSelected());
        this.qualityLevel.setEnabled(this.noJpeg.isSelected());
        this.sendLocalUsername.setEnabled(this.secVeNCrypt.isEnabled() && (this.secPlain.isSelected() || this.secIdent.isSelected()));
        this.sshArguments.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isSelected() && this.sshArgsCustom.isSelected());
    }

    private void updatePreferences() {
        if (this.autoSelect.isSelected()) {
            UserPreferences.set("global", "AutoSelect", true);
        } else {
            UserPreferences.set("global", "AutoSelect", false);
            if (this.zrle.isSelected()) {
                UserPreferences.set("global", "PreferredEncoding", "ZRLE");
            } else if (this.hextile.isSelected()) {
                UserPreferences.set("global", "PreferredEncoding", "hextile");
            } else if (this.tight.isSelected()) {
                UserPreferences.set("global", "PreferredEncoding", "Tight");
            } else if (this.raw.isSelected()) {
                UserPreferences.set("global", "PreferredEncoding", "raw");
            }
        }
        if (this.fullColour.isSelected()) {
            UserPreferences.set("global", "FullColour", true);
        } else {
            UserPreferences.set("global", "FullColour", false);
            if (this.mediumColour.isSelected()) {
                UserPreferences.set("global", "LowColorLevel", 2);
            } else if (this.lowColour.isSelected()) {
                UserPreferences.set("global", "LowColorLevel", 1);
            } else if (this.veryLowColour.isSelected()) {
                UserPreferences.set("global", "LowColorLevel", 0);
            }
        }
        UserPreferences.set("global", "NoJPEG", !this.noJpeg.isSelected());
        UserPreferences.set("global", "QualityLevel", (Integer)this.qualityLevel.getSelectedItem());
        UserPreferences.set("global", "CustomCompressLevel", this.customCompressLevel.isSelected());
        UserPreferences.set("global", "CompressLevel", (Integer)this.compressLevel.getSelectedItem());
        UserPreferences.set("global", "ViewOnly", this.viewOnly.isSelected());
        UserPreferences.set("global", "AcceptClipboard", this.acceptClipboard.isSelected());
        UserPreferences.set("global", "SendClipboard", this.sendClipboard.isSelected());
        String menuKeyStr = MenuKey.getMenuKeySymbols()[this.menuKey.getSelectedIndex()].name;
        UserPreferences.set("global", "MenuKey", menuKeyStr);
        String desktopSizeString = this.desktopSize.isSelected() ? this.desktopWidth.getText() + "x" + this.desktopHeight.getText() : "";
        UserPreferences.set("global", "DesktopSize", desktopSizeString);
        UserPreferences.set("global", "FullScreen", this.fullScreen.isSelected());
        UserPreferences.set("global", "FullScreenAllMonitors", this.fullScreenAllMonitors.isSelected());
        UserPreferences.set("global", "Shared", this.shared.isSelected());
        UserPreferences.set("global", "UseLocalCursor", this.useLocalCursor.isSelected());
        UserPreferences.set("global", "AcceptBell", this.acceptBell.isSelected());
        String scaleString = this.scalingFactor.getSelectedItem().toString();
        if (scaleString.equalsIgnoreCase("Auto")) {
            UserPreferences.set("global", "ScalingFactor", "Auto");
        } else if (scaleString.equalsIgnoreCase("Fixed Aspect Ratio")) {
            UserPreferences.set("global", "ScalingFactor", "FixedRatio");
        } else {
            scaleString = scaleString.substring(0, scaleString.length() - 1);
            UserPreferences.set("global", "ScalingFactor", scaleString);
        }
        UserPreferences.set("viewer", "secVeNCrypt", this.secVeNCrypt.isSelected());
        UserPreferences.set("viewer", "encNone", this.encNone.isSelected());
        UserPreferences.set("viewer", "encTLS", this.encTLS.isSelected());
        UserPreferences.set("viewer", "encX509", this.encX509.isSelected());
        UserPreferences.set("viewer", "secNone", this.secNone.isSelected());
        UserPreferences.set("viewer", "secVnc", this.secVnc.isSelected());
        UserPreferences.set("viewer", "secPlain", this.secPlain.isSelected());
        UserPreferences.set("viewer", "secIdent", this.secIdent.isSelected());
        UserPreferences.set("global", "SendLocalUsername", this.sendLocalUsername.isSelected());
        if (!CSecurityTLS.x509ca.getValueStr().equals("")) {
            UserPreferences.set("viewer", "x509ca", CSecurityTLS.x509ca.getValueStr());
        }
        if (!CSecurityTLS.x509crl.getValueStr().equals("")) {
            UserPreferences.set("viewer", "x509crl", CSecurityTLS.x509crl.getValueStr());
        }
        UserPreferences.set("global", "Tunnel", this.sshTunnel.isSelected());
        if (this.sshUseGateway.isSelected()) {
            String via = this.sshUser.getText() + "@" + this.sshHost.getText() + ":" + this.sshPort.getText();
            UserPreferences.set("global", "Via", via);
        }
        if (this.sshUseExt.isSelected()) {
            UserPreferences.set("global", "extSSH", this.sshUseExt.isSelected());
            UserPreferences.set("global", "extSSHClient", this.sshClient.getText());
            if (!this.sshArguments.getText().isEmpty()) {
                UserPreferences.set("global", "extSSHArgs", this.sshArguments.getText());
            }
        }
        UserPreferences.set("global", "SSHConfig", this.sshConfig.getText());
        UserPreferences.set("global", "SSHKeyFile", this.sshKeyFile.getText());
    }

    private void restorePreferences() {
        this.autoSelect.setSelected(UserPreferences.getBool("global", "AutoSelect"));
        if (!this.autoSelect.isSelected()) {
            if (UserPreferences.getBool("global", "FullColour")) {
                this.fullColour.setSelected(true);
            } else {
                switch (UserPreferences.getInt("global", "LowColorLevel")) {
                    case 2: {
                        this.mediumColour.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.lowColour.setSelected(true);
                        break;
                    }
                    case 0: {
                        this.veryLowColour.setSelected(true);
                    }
                }
            }
            String encoding = UserPreferences.get("global", "PreferredEncoding");
            if (encoding != null) {
                switch (Encodings.encodingNum(encoding)) {
                    case 16: {
                        this.zrle.setSelected(true);
                        break;
                    }
                    case 5: {
                        this.hextile.setSelected(true);
                        break;
                    }
                    case 0: {
                        this.raw.setSelected(true);
                        break;
                    }
                    default: {
                        this.tight.setSelected(true);
                    }
                }
            }
        }
        this.noJpeg.setSelected(!UserPreferences.getBool("global", "NoJPEG"));
        this.qualityLevel.setSelectedItem(UserPreferences.getInt("global", "QualityLevel"));
        this.customCompressLevel.setSelected(UserPreferences.getBool("global", "CustomCompressLevel"));
        this.compressLevel.setSelectedItem(UserPreferences.getInt("global", "CompressLevel"));
        this.viewOnly.setSelected(UserPreferences.getBool("global", "ViewOnly"));
        this.acceptClipboard.setSelected(UserPreferences.getBool("global", "AcceptClipboard"));
        this.sendClipboard.setSelected(UserPreferences.getBool("global", "SendClipboard"));
        this.menuKey.setSelectedItem(UserPreferences.get("global", "MenuKey"));
        this.desktopSize.setSelected(!UserPreferences.get("global", "DesktopSize").isEmpty());
        if (this.desktopSize.isSelected()) {
            String desktopSizeString = UserPreferences.get("global", "DesktopSize");
            this.desktopWidth.setText(desktopSizeString.split("x")[0]);
            this.desktopHeight.setText(desktopSizeString.split("x")[1]);
        }
        this.fullScreen.setSelected(UserPreferences.getBool("global", "FullScreen"));
        this.fullScreenAllMonitors.setSelected(UserPreferences.getBool("global", "FullScreenAllMonitors"));
        if (this.shared.isEnabled()) {
            this.shared.setSelected(UserPreferences.getBool("global", "Shared"));
        }
        this.useLocalCursor.setSelected(UserPreferences.getBool("global", "UseLocalCursor"));
        this.acceptBell.setSelected(UserPreferences.getBool("global", "AcceptBell"));
        String scaleString = UserPreferences.get("global", "ScalingFactor");
        if (scaleString != null) {
            if (scaleString.equalsIgnoreCase("Auto")) {
                this.scalingFactor.setSelectedItem("Auto");
            } else if (scaleString.equalsIgnoreCase("FixedRatio")) {
                this.scalingFactor.setSelectedItem("Fixed Aspect Ratio");
            } else {
                this.scalingFactor.setSelectedItem(scaleString + "%");
            }
        }
        if (this.secVeNCrypt.isEnabled()) {
            this.secVeNCrypt.setSelected(UserPreferences.getBool("viewer", "secVeNCrypt", true));
            if (this.secVeNCrypt.isSelected()) {
                this.encNone.setSelected(UserPreferences.getBool("viewer", "encNone", true));
                this.encTLS.setSelected(UserPreferences.getBool("viewer", "encTLS", true));
                this.encX509.setSelected(UserPreferences.getBool("viewer", "encX509", true));
                this.secPlain.setSelected(UserPreferences.getBool("viewer", "secPlain", true));
                this.secIdent.setSelected(UserPreferences.getBool("viewer", "secIdent", true));
                this.sendLocalUsername.setSelected(UserPreferences.getBool("global", "SendLocalUsername"));
            }
        }
        if (this.secNone.isEnabled()) {
            this.secNone.setSelected(UserPreferences.getBool("viewer", "secNone", true));
        }
        if (this.secVnc.isEnabled()) {
            this.secVnc.setSelected(UserPreferences.getBool("viewer", "secVnc", true));
        }
        this.sshTunnel.setSelected(UserPreferences.getBool("global", "Tunnel"));
        this.sshUseGateway.setSelected(UserPreferences.get("global", "Via") != null);
        if (this.sshUseGateway.isSelected()) {
            this.cc.viewer.via.setParam(UserPreferences.get("global", "Via"));
        }
        this.sshUser.setText(Tunnel.getSshUser(this.cc));
        this.sshHost.setText(Tunnel.getSshHost(this.cc));
        this.sshPort.setText(Integer.toString(Tunnel.getSshPort(this.cc)));
        this.sshUseExt.setSelected(UserPreferences.getBool("global", "extSSH"));
        File f = new File(UserPreferences.get("global", "extSSHClient"));
        if (f.exists() && f.canExecute()) {
            this.sshClient.setText(f.getAbsolutePath());
        }
        this.sshArguments.setText(UserPreferences.get("global", "extSSHArgs"));
        if (this.sshArguments.getText().isEmpty()) {
            this.sshArgsDefault.setSelected(true);
        } else {
            this.sshArgsCustom.setSelected(true);
        }
        f = new File(UserPreferences.get("global", "SSHConfig"));
        if (f.exists() && f.canRead()) {
            this.sshConfig.setText(f.getAbsolutePath());
        }
        if (UserPreferences.get("global", "SSHKeyFile") != null) {
            f = new File(UserPreferences.get("global", "SSHKeyFile"));
            if (f.exists() && f.canRead()) {
                this.sshKeyFile.setText(f.getAbsolutePath());
            }
        } else {
            this.sshKeyFile.setText(Tunnel.getSshKeyFile(this.cc));
        }
        this.sshUseGateway.setEnabled(this.sshTunnel.isSelected());
        this.sshUser.setEnabled(this.sshTunnel.isSelected() && this.sshUseGateway.isEnabled() && this.sshUseGateway.isSelected());
        this.sshHost.setEnabled(this.sshTunnel.isSelected() && this.sshUseGateway.isEnabled() && this.sshUseGateway.isSelected());
        this.sshPort.setEnabled(this.sshTunnel.isSelected() && this.sshUseGateway.isEnabled() && this.sshUseGateway.isSelected());
        this.sshUseExt.setEnabled(this.sshTunnel.isSelected());
        this.sshClient.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled());
        this.sshClientBrowser.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
        this.sshArgsDefault.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
        this.sshArgsCustom.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
        this.sshArguments.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected() && this.sshArgsCustom.isSelected());
        this.sshConfig.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
        this.sshConfigBrowser.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
        this.sshKeyFile.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
        this.sshKeyFileBrowser.setEnabled(this.sshTunnel.isSelected() && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
    }

    @Override
    public void endDialog() {
        super.endDialog();
        if (this.cc.viewport != null && this.cc.viewport.isVisible()) {
            this.cc.viewport.toFront();
            this.cc.viewport.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton button;
        Object s = e.getSource();
        if (s instanceof JButton) {
            JButton button2 = (JButton)s;
            if (button2 == this.okButton) {
                JTextField[] fields;
                for (JTextField field : fields = new JTextField[]{this.x509ca, this.x509crl, this.sshClient, this.sshConfig, this.sshKeyFile}) {
                    File f;
                    if (field.getText() == null || field.getText().equals("") || (f = new File(field.getText())).exists() && f.canRead()) continue;
                    String msg = new String("The file " + f.getAbsolutePath() + " specified for option " + field.getName() + " does not exist or cannot be read.  Please correct before proceeding.");
                    JOptionPane.showMessageDialog(this, msg, "WARNING", 2);
                    return;
                }
                if (this.cc != null) {
                    this.cc.getOptions();
                }
                this.endDialog();
            } else if (button2 == this.cancelButton) {
                this.endDialog();
            } else if (button2 == this.cfLoadButton) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Path to configuration file");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    String filename = fc.getSelectedFile().toString();
                    if (filename != null) {
                        Configuration.load(filename);
                    }
                    this.cc.setOptions();
                }
            } else if (button2 == this.cfSaveAsButton) {
                String filename;
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Save current configuration as:");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0 && (filename = fc.getSelectedFile().toString()) != null) {
                    Configuration.save(filename);
                }
            } else if (button2 == this.defSaveButton) {
                this.updatePreferences();
                UserPreferences.save();
            } else if (button2 == this.defReloadButton) {
                this.restorePreferences();
            } else if (button2 == this.defClearButton) {
                UserPreferences.clear();
                this.cc.setOptions();
            } else if (button2 == this.caButton) {
                JFileChooser fc = new JFileChooser(new File(CSecurityTLS.getDefaultCA()));
                fc.setDialogTitle("Path to X509 CA certificate");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    this.x509ca.setText(fc.getSelectedFile().toString());
                }
            } else if (button2 == this.crlButton) {
                JFileChooser fc = new JFileChooser(new File(CSecurityTLS.getDefaultCRL()));
                fc.setDialogTitle("Path to X509 CRL file");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    this.x509crl.setText(fc.getSelectedFile().toString());
                }
            } else if (button2 == this.sshClientBrowser) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Path to external SSH client");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    this.sshClient.setText(fc.getSelectedFile().toString());
                }
            } else if (button2 == this.sshConfigBrowser) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Path to OpenSSH client config file");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    this.sshConfig.setText(fc.getSelectedFile().toString());
                }
            } else if (button2 == this.sshKeyFileBrowser) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Path to SSH key file");
                fc.setApproveButtonText("OK");
                fc.setFileHidingEnabled(false);
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    this.sshKeyFile.setText(fc.getSelectedFile().toString());
                }
            }
        } else if (s instanceof JRadioButton && ((button = (JRadioButton)s) == this.sshArgsCustom || button == this.sshArgsDefault)) {
            this.sshArguments.setEnabled(this.sshArgsCustom.isSelected());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object s = e.getSource();
        if (s instanceof JCheckBox) {
            JCheckBox item = (JCheckBox)s;
            boolean enable = item.isSelected();
            if (item == this.autoSelect) {
                ButtonGroup[] groups;
                for (ButtonGroup grp : groups = new ButtonGroup[]{this.encodingGroup, this.colourGroup}) {
                    Enumeration<AbstractButton> elems = grp.getElements();
                    while (elems.hasMoreElements()) {
                        elems.nextElement().setEnabled(!enable);
                    }
                }
            } else if (item == this.customCompressLevel) {
                this.compressLevel.setEnabled(enable);
            } else if (item == this.desktopSize) {
                this.desktopWidth.setEnabled(enable);
                this.desktopHeight.setEnabled(enable);
            } else if (item == this.noJpeg) {
                this.qualityLevel.setEnabled(enable);
            } else if (item == this.encX509) {
                this.x509ca.setEnabled(enable);
                this.caButton.setEnabled(enable);
                this.x509crl.setEnabled(enable);
                this.crlButton.setEnabled(enable);
            } else if (item == this.secVeNCrypt) {
                this.encNone.setEnabled(enable);
                this.encTLS.setEnabled(enable);
                this.encX509.setEnabled(enable);
                this.x509ca.setEnabled(enable && this.encX509.isSelected());
                this.caButton.setEnabled(enable && this.encX509.isSelected());
                this.x509crl.setEnabled(enable && this.encX509.isSelected());
                this.crlButton.setEnabled(enable && this.encX509.isSelected());
                this.secIdent.setEnabled(enable);
                this.secPlain.setEnabled(enable);
                this.sendLocalUsername.setEnabled(enable);
            } else if (item == this.encNone) {
                this.secNone.setSelected(enable && UserPreferences.getBool("viewer", "secNone", true));
                this.secVnc.setSelected(enable && UserPreferences.getBool("viewer", "secVnc", true));
            } else if (item == this.secIdent || item == this.secPlain) {
                this.sendLocalUsername.setEnabled(this.secIdent.isSelected() || this.secPlain.isSelected());
            } else if (item == this.sshTunnel) {
                this.sshUseGateway.setEnabled(enable);
                this.sshUser.setEnabled(enable && this.sshUseGateway.isEnabled() && this.sshUseGateway.isSelected());
                this.sshHost.setEnabled(enable && this.sshUseGateway.isEnabled() && this.sshUseGateway.isSelected());
                this.sshPort.setEnabled(enable && this.sshUseGateway.isEnabled() && this.sshUseGateway.isSelected());
                this.sshUseExt.setEnabled(enable);
                this.sshClient.setEnabled(enable && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
                this.sshClientBrowser.setEnabled(enable && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
                this.sshArgsDefault.setEnabled(enable && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
                this.sshArgsCustom.setEnabled(enable && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected());
                this.sshArguments.setEnabled(enable && this.sshUseExt.isEnabled() && this.sshUseExt.isSelected() && this.sshArgsCustom.isSelected());
                this.sshConfig.setEnabled(enable && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
                this.sshConfigBrowser.setEnabled(enable && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
                this.sshKeyFile.setEnabled(enable && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
                this.sshKeyFileBrowser.setEnabled(enable && this.sshUseExt.isEnabled() && !this.sshUseExt.isSelected());
            } else if (item == this.sshUseExt) {
                this.sshClient.setEnabled(enable);
                this.sshClientBrowser.setEnabled(enable);
                this.sshArgsDefault.setEnabled(enable);
                this.sshArgsCustom.setEnabled(enable);
                this.sshArguments.setEnabled(enable && this.sshArgsCustom.isSelected());
                this.sshConfig.setEnabled(!enable);
                this.sshConfigBrowser.setEnabled(!enable);
                this.sshKeyFile.setEnabled(!enable);
                this.sshKeyFileBrowser.setEnabled(!enable);
            } else if (item == this.sshUseGateway) {
                this.sshUser.setEnabled(enable);
                this.sshHost.setEnabled(enable);
                this.sshPort.setEnabled(enable);
            }
        }
    }

    private class IntegerTextField
    extends JFormattedTextField {
        public IntegerTextField(int digits) {
            this.setDocument(new IntegerDocument(digits));
            Font f = this.getFont();
            String template = String.format("%0" + digits + "d", 0);
            int w = this.getFontMetrics(f).stringWidth(template) + this.getMargin().left + this.getMargin().right + this.getInsets().left + this.getInsets().right;
            int h = this.getPreferredSize().height;
            this.setPreferredSize(new Dimension(w, h));
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            if (e.getID() == 1005 && (this.getText() == null || this.getText().isEmpty())) {
                this.setValue(null);
            }
            super.processFocusEvent(e);
        }
    }

    private class IntegerDocument
    extends PlainDocument {
        private int limit;

        public IntegerDocument(int max) {
            this.limit = max;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str == null || !str.matches("^[0-9]+$")) {
                return;
            }
            if (this.getLength() + str.length() > this.limit) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.insertString(offset, str, a);
            }
        }
    }
}

