/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Hostname;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.Dialog;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.UserPreferences;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ServerDialog
extends Dialog {
    CConn cc;
    Dialog.MyJComboBox server;
    ComboBoxEditor editor;
    JButton aboutButton;
    JButton optionsButton;
    JButton okButton;
    JButton cancelButton;
    OptionsDialog options;
    static LogWriter vlog = new LogWriter("ServerDialog");

    public ServerDialog(OptionsDialog options_, String defaultServerName, CConn cc_) {
        super(true);
        this.cc = cc_;
        this.setDefaultCloseOperation(0);
        this.setTitle("VNC Viewer: Connection Details");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (VncViewer.nViewers == 1) {
                    ServerDialog.this.cc.viewer.exit(1);
                } else {
                    ServerDialog.this.ret = false;
                    ServerDialog.this.endDialog();
                }
            }
        });
        this.options = options_;
        JLabel serverLabel = new JLabel("VNC Server:", 4);
        String valueStr = new String("");
        if (UserPreferences.get("ServerDialog", "history") != null) {
            valueStr = UserPreferences.get("ServerDialog", "history");
        }
        this.server = new Dialog.MyJComboBox(valueStr.split(","));
        if (valueStr.equals("")) {
            this.server.setPrototypeDisplayValue("255.255.255.255:5900");
        }
        this.server.setEditable(true);
        this.editor = this.server.getEditor();
        this.editor.getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ServerDialog.this.server.insertItemAt(ServerDialog.this.editor.getItem(), 0);
                    ServerDialog.this.server.setSelectedIndex(0);
                    ServerDialog.this.commit();
                }
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JLabel icon = new JLabel(VncViewer.logoIcon);
        this.optionsButton = new JButton("Options...");
        this.aboutButton = new JButton("About...");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        contentPane.add((Component)icon, new GridBagConstraints(0, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        contentPane.add((Component)serverLabel, new GridBagConstraints(1, 0, 1, 1, LIGHT, LIGHT, 21, 0, new Insets(5, 10, 5, 5), 0, 0));
        contentPane.add((Component)this.server, new GridBagConstraints(2, 0, 0, 1, HEAVY, LIGHT, 21, 2, new Insets(5, 0, 5, 5), 0, 0));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new GridLayout(1, 4, 5, 5));
        buttonPane.add(this.aboutButton);
        buttonPane.add(this.optionsButton);
        buttonPane.add(this.okButton);
        buttonPane.add(this.cancelButton);
        contentPane.add((Component)buttonPane, new GridBagConstraints(0, 1, 0, 1, LIGHT, LIGHT, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.addListeners(this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s instanceof JButton && (JButton)s == this.okButton) {
            this.commit();
        } else if (s instanceof JButton && (JButton)s == this.cancelButton) {
            if (VncViewer.nViewers == 1) {
                this.cc.viewer.exit(1);
            }
            this.ret = false;
            this.endDialog();
        } else if (s instanceof JButton && (JButton)s == this.optionsButton) {
            this.options.showDialog(this);
        } else if (s instanceof JButton && (JButton)s == this.aboutButton) {
            this.cc.showAbout();
        } else if (s instanceof JComboBox && (JComboBox)s == this.server && e.getActionCommand().equals("comboBoxEdited")) {
            this.server.insertItemAt(this.editor.getItem(), 0);
            this.server.setSelectedIndex(0);
        }
    }

    private void commit() {
        String serverName = (String)this.server.getSelectedItem();
        if (serverName == null || serverName.equals("")) {
            vlog.error("Invalid servername specified");
            if (VncViewer.nViewers == 1) {
                this.cc.viewer.exit(1);
            }
            this.ret = false;
            this.endDialog();
        }
        Configuration.setParam("Server", Hostname.getHost(serverName));
        Configuration.setParam("Port", Integer.toString(Hostname.getPort(serverName)));
        String valueStr = UserPreferences.get("ServerDialog", "history");
        String t = valueStr == null ? "" : valueStr;
        StringTokenizer st = new StringTokenizer(t, ",");
        StringBuffer sb = new StringBuffer().append((String)this.server.getSelectedItem());
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str.equals((String)this.server.getSelectedItem()) || str.equals("")) continue;
            sb.append(',');
            sb.append(str);
        }
        UserPreferences.set("ServerDialog", "history", sb.toString());
        UserPreferences.save("ServerDialog");
        this.endDialog();
    }
}

