/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import java.util.List;
import org.sikuli.basics.Debug;
import se.vidstige.jadb.AdbServerLauncher;
import se.vidstige.jadb.JadbConnection;
import se.vidstige.jadb.JadbDevice;

public class ADBClient {
    private static JadbConnection jadb = null;
    private static boolean shouldStopServer = false;
    private static JadbDevice device = null;
    public static boolean isAdbAvailable = true;

    private static void init() {
        ADBClient.getConnection(true);
        if (jadb == null) {
            try {
                new AdbServerLauncher().launch();
                Debug.log(3, "ADBClient: ADBServer started", new Object[0]);
                ADBClient.getConnection(false);
                if (jadb != null) {
                    shouldStopServer = true;
                }
            }
            catch (Exception e) {
                if (e.getMessage().startsWith("Cannot run program")) {
                    isAdbAvailable = false;
                    Debug.error("ADBClient: package adb not available. need to be installed", new Object[0]);
                }
                Debug.error("ADBClient: ADBServer problem: %s", e.getMessage());
            }
        }
        String serial = null;
        if (jadb != null) {
            List<JadbDevice> devices = null;
            try {
                devices = jadb.getDevices();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (devices != null && devices.size() > 0) {
                device = devices.get(0);
                serial = device.getSerial();
            } else {
                device = null;
                Debug.error("ADBClient: init: no devices attached", new Object[0]);
            }
        }
        if (device != null) {
            Debug.log(3, "ADBClient: init: attached device: serial(%s)", serial);
        }
    }

    public static void reset() {
        device = null;
        jadb = null;
        Process p = null;
        if (!shouldStopServer) {
            return;
        }
        try {
            p = Runtime.getRuntime().exec(new String[]{"adb", "kill-server"});
            p.waitFor();
        }
        catch (Exception e) {
            Debug.error("ADBClient: reset: kill-server did not work", new Object[0]);
        }
    }

    private static void getConnection(boolean quiet) {
        if (jadb == null) {
            try {
                jadb = new JadbConnection();
                jadb.getHostVersion();
                Debug.log(3, "ADBClient: ADBServer connection established", new Object[0]);
            }
            catch (Exception e) {
                if (!quiet) {
                    Debug.error("ADBClient: ADBServer connection not possible: %s", e.getMessage());
                }
                jadb = null;
            }
        }
    }

    public static JadbDevice getDevice() {
        ADBClient.init();
        return device;
    }

    public boolean isValid() {
        return jadb != null;
    }

    public boolean hasDevices() {
        return device != null;
    }
}

