/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import java.awt.Rectangle;
import org.sikuli.android.ADBDevice;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;
import org.sikuli.util.OverlayCapturePrompt;
import org.sikuli.util.ScreenHighlighter;

public class ADBScreen
extends Region
implements EventObserver,
IScreen {
    private static String me;
    private static boolean isFake;
    protected IRobot robot = null;
    private static int logLvl;
    private ScreenImage lastScreenImage = null;
    private Rectangle bounds;
    private boolean waitPrompt = false;
    protected OverlayCapturePrompt prompt;
    private String promptMsg = "Select a region on the screen";
    private static int waitForScreenshot;
    public boolean needsUnLock = false;
    public int waitAfterAction = 1;
    private ADBDevice device = null;
    private static ADBScreen screen;
    private EventObserver captureObserver = null;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public static ADBScreen start() {
        if (screen == null) {
            try {
                screen = new ADBScreen();
            }
            catch (Exception e) {
                ADBScreen.log(-1, "start: No devices attached", new Object[0]);
                screen = null;
            }
        }
        return screen;
    }

    public static void stop() {
        ADBDevice.reset();
        screen = null;
    }

    public ADBScreen() {
        this.setOtherScreen(this);
        this.device = ADBDevice.init();
        if (this.device != null) {
            this.robot = this.device.getRobot(this);
            this.robot.setAutoDelay(10);
            this.bounds = this.device.getBounds();
            this.w = this.bounds.width;
            this.h = this.bounds.height;
        }
    }

    @Override
    public boolean isValid() {
        return null != this.device;
    }

    public ADBDevice getDevice() {
        return this.device;
    }

    @Override
    public String toString() {
        if (null == this.device) {
            return "ADBScreen: No Android device attached";
        }
        return String.format("ADBScreen: Android device: %s", this.getDeviceDescription());
    }

    public String getDeviceDescription() {
        return String.format("%s (%d x %d)", this.device.getDeviceSerial(), this.bounds.width, this.bounds.height);
    }

    public void wakeUp(int seconds) {
        if (null == this.device) {
            return;
        }
        if (null == this.device.isDisplayOn()) {
            ADBScreen.log(-1, "wakeUp: not possible - see log", new Object[0]);
            return;
        }
        if (!this.device.isDisplayOn().booleanValue()) {
            this.device.wakeUp(seconds);
            if (this.needsUnLock) {
                this.aSwipeUp();
            }
        }
    }

    public String exec(String command, String ... args) {
        if (this.device == null) {
            return null;
        }
        return this.device.exec(command, args);
    }

    @Override
    public IScreen getScreen() {
        return this;
    }

    @Override
    public void update(EventSubject s) {
        this.waitPrompt = false;
    }

    @Override
    public IRobot getRobot() {
        return this.robot;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.x, this.y, -1, -1);
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        ScreenImage simg = null;
        if (this.device != null) {
            ADBScreen.log(logLvl, "ADBScreen.capture: (%d,%d) %dx%d", x, y, w, h);
            simg = this.device.captureScreen(new Rectangle(x, y, w, h));
        } else {
            ADBScreen.log(-1, "capture: no ADBRobot available", new Object[0]);
        }
        this.lastScreenImage = simg;
        return simg;
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.x, reg.y, reg.w, reg.h);
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        return this.capture(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void showTarget(Location loc) {
        this.showTarget(loc, Settings.SlowMotionDelay);
    }

    protected void showTarget(Location loc, double secs) {
        if (Settings.isShowActions()) {
            ScreenHighlighter overlay = new ScreenHighlighter(this, null);
            overlay.showTarget(loc, (float)secs);
        }
    }

    @Override
    public int getID() {
        return 0;
    }

    @Override
    public String getIDString() {
        return "Android";
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    @Override
    public ScreenImage userCapture(final String msg) {
        if (this.robot == null) {
            return null;
        }
        this.waitPrompt = true;
        Thread th = new Thread(){

            @Override
            public void run() {
                ADBScreen.this.prompt = new OverlayCapturePrompt(ADBScreen.this);
                ADBScreen.this.prompt.prompt(msg);
            }
        };
        th.start();
        boolean hasShot = false;
        ScreenImage simg = null;
        int count = 0;
        while (!hasShot) {
            this.wait(0.1f);
            if (count++ > waitForScreenshot) break;
            if (this.prompt == null || !this.prompt.isComplete()) continue;
            simg = this.prompt.getSelection();
            if (simg != null) {
                this.lastScreenImage = simg;
                hasShot = true;
            }
            this.prompt.close();
        }
        this.prompt.close();
        this.prompt = null;
        return simg;
    }

    @Override
    public int getIdFromPoint(int srcx, int srcy) {
        return 0;
    }

    public Region set(Region element) {
        return this.setOther(element);
    }

    public Location set(Location element) {
        return this.setOther(element);
    }

    @Override
    public Region setOther(Region element) {
        return element.setOtherScreen(this);
    }

    @Override
    public Location setOther(Location element) {
        return element.setOtherScreen(this);
    }

    @Override
    public Region newRegion(Location loc, int width, int height) {
        return new Region(loc.x, loc.y, width, height, this);
    }

    @Override
    public Region newRegion(Region reg) {
        return new Region(reg).setOtherScreen(this);
    }

    @Override
    public Region newRegion(int _x, int _y, int width, int height) {
        return new Region(_x, _y, width, height, this);
    }

    @Override
    public Location newLocation(int _x, int _y) {
        return new Location(_x, _y).setOtherScreen(this);
    }

    @Override
    public Location newLocation(Location loc) {
        return new Location(loc).setOtherScreen(this);
    }

    static {
        RunTime.loadLibrary("VisionProxy");
        me = "ADBScreen: ";
        isFake = false;
        logLvl = 3;
        waitForScreenshot = 300;
        screen = null;
    }
}

