/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.natives;

import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import javax.swing.JOptionPane;
import org.sikuli.natives.OSUtil;
import org.sikuli.script.App;
import org.sikuli.script.RunTime;
import org.sikuli.script.Runner;

public class MacUtil
implements OSUtil {
    private static boolean _askedToEnableAX = false;
    private String usedFeature;
    private static RunTime runTime = null;
    static String cmd = "tell application \"System Events\"\nset found to \"NotFound\"\ntry\n#LINE#\nend try\nend tell\nif not found is equal to \"NotFound\" then\nset windowName to \"\"\ntry\nset windowName to name of first window of application (name of found)\nend try\nset found to {name of found, \u00abclass idux\u00bb of found, windowName}\nend if\nfound\n";
    static String cmdLineApp = "set found to first item of (processes whose name is \"#APP#\")";
    static String cmdLinePID = "set found to first item of (processes whose unix id is equal to #PID#)";

    @Override
    public void checkFeatureAvailability() {
        runTime = RunTime.get();
        RunTime.loadLibrary("MacUtil");
    }

    @Override
    public App.AppEntry getApp(int appPID, String appName) {
        App.AppEntry app = null;
        String name = "";
        String theCmd = "";
        int pid = -1;
        Object filter = appPID < 0 ? appName : Integer.valueOf(appPID);
        if (filter instanceof String) {
            name = (String)filter;
            theCmd = cmd.replace("#LINE#", cmdLineApp);
            theCmd = theCmd.replaceAll("#APP#", name);
        } else if (filter instanceof Integer) {
            pid = (Integer)filter;
            theCmd = cmd.replace("#LINE#", cmdLinePID);
            theCmd = theCmd.replaceAll("#PID#", "" + pid);
        } else {
            return app;
        }
        int retVal = Runner.runas(theCmd, true);
        String result = RunTime.get().getLastCommandResult();
        String title = "???";
        String sPid = "-1";
        String sName = "NotKnown";
        if (retVal > -1 && !result.contains("NotFound")) {
            String[] parts = result.split(",");
            if (parts.length > 1) {
                sName = parts[0];
                sPid = parts[1];
            }
            if (parts.length > 2) {
                title = parts[2];
            }
            if (parts.length > 3) {
                for (int i = 3; i < parts.length; ++i) {
                    title = title + "," + parts[i];
                }
            }
            app = new App.AppEntry(sName.trim(), sPid.trim(), title.trim(), "", "");
        }
        return app;
    }

    @Override
    public int isRunning(App.AppEntry app) {
        if (app.pid > 0) {
            return 1;
        }
        if (app.name.isEmpty()) {
            return -1;
        }
        if (this.getWindow(app.name, 0) != null) {
            return 1;
        }
        App.AppEntry ae = this.getApp(app.pid, app.name);
        if (ae != null && ae.pid > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public int open(String appName) {
        if (MacUtil._openApp(appName)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int open(App.AppEntry app) {
        String appName = app.execName.startsWith(app.name) ? app.name : app.execName;
        int retval = 0;
        if (MacUtil.runTime.osVersion.startsWith("10.10.")) {
            if (Runner.runas(String.format("tell app \"%s\" to activate", appName), true) != 0) {
                retval = -1;
            }
        } else {
            retval = this.open(appName);
        }
        if (retval == 0) {
            retval = MacUtil.getPID(appName);
        }
        return retval;
    }

    @Override
    public int switchto(String appName) {
        return this.open(appName);
    }

    @Override
    public int switchto(int pid, int num) {
        return -1;
    }

    @Override
    public int switchto(String appName, int winNum) {
        return this.open(appName);
    }

    @Override
    public int switchto(App.AppEntry app, int num) {
        String appName = app.execName.startsWith(app.name) ? app.name : app.execName;
        int retval = 0;
        if (MacUtil.runTime.osVersion.startsWith("10.10.")) {
            if (Runner.runas(String.format("tell app \"%s\" to activate", appName), true) < 0) {
                retval = -1;
            }
        } else {
            retval = this.open(appName);
        }
        if (retval == 0) {
            retval = MacUtil.getPID(appName);
        }
        return retval;
    }

    @Override
    public int close(String appName) {
        try {
            String[] cmd = new String[]{"sh", "-c", "ps aux |  grep \"" + appName + "\" | awk '{print $2}' | xargs kill"};
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int close(int pid) {
        try {
            String[] cmd = new String[]{"sh", "-c", "kill " + pid};
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int close(App.AppEntry app) {
        if (app.pid > -1) {
            return this.close(app.pid);
        }
        String appName = app.execName.startsWith(app.name) ? app.name : app.execName;
        return this.close(appName);
    }

    private void checkAxEnabled(String name) {
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            return;
        }
        if (Integer.parseInt(System.getProperty("os.version").replace(".", "")) > 108 && !MacUtil.isAxEnabled()) {
            if (name == null) {
                JOptionPane.showMessageDialog(null, "This app uses Sikuli feature " + this.usedFeature + ", which needs\naccess to the Mac's assistive device support.\nYou have to explicitly allow this in the System Preferences.\n(System Preferences -> Security & Privacy -> Privacy)\nCurrently we cannot do this for you.\n\nBe prepared to get some crash after clicking ok.\nPlease check the System Preferences and come back.", "SikuliX on Mac Mavericks Special", -1);
                System.out.println("[error] MacUtil: on Mavericks: no access to assistive device support");
            }
            this.usedFeature = name;
            return;
        }
        if (!MacUtil.isAxEnabled()) {
            if (_askedToEnableAX) {
                return;
            }
            int ret = JOptionPane.showConfirmDialog(null, "You need to enable Accessibility API to use the function \"" + name + "\".\nShould I open te System Preferences for you?", "Accessibility API not enabled", 0, 0);
            if (ret == 0) {
                MacUtil.openAxSetting();
                JOptionPane.showMessageDialog(null, "Check \"Enable access for assistant devices\"in the System Preferences\n and then close this dialog.", "Enable Accessibility API", 1);
            }
            _askedToEnableAX = true;
        }
    }

    @Override
    public Rectangle getWindow(String appName, int winNum) {
        this.checkAxEnabled("getWindow");
        int pid = MacUtil.getPID(appName);
        return this.getWindow(pid, winNum);
    }

    @Override
    public Rectangle getWindow(String appName) {
        return this.getWindow(appName, 0);
    }

    @Override
    public Rectangle getWindow(int pid) {
        return this.getWindow(pid, 0);
    }

    @Override
    public Rectangle getWindow(int pid, int winNum) {
        Rectangle rect = MacUtil.getRegion(pid, winNum);
        this.checkAxEnabled(null);
        return rect;
    }

    @Override
    public Rectangle getFocusedWindow() {
        this.checkAxEnabled("getFocusedWindow");
        Rectangle rect = MacUtil.getFocusedRegion();
        this.checkAxEnabled(null);
        return rect;
    }

    @Override
    public native void bringWindowToFront(Window var1, boolean var2);

    public static native boolean _openApp(String var0);

    public static native int getPID(String var0);

    public static native Rectangle getRegion(int var0, int var1);

    public static native Rectangle getFocusedRegion();

    public static native boolean isAxEnabled();

    public static native void openAxSetting();

    @Override
    public Map<Integer, String[]> getApps(String name) {
        return null;
    }
}

