/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sikuli.script.FindFailed;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Image;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;

public class ObserveEvent {
    private Type type;
    private Region region = null;
    private Object pattern = null;
    private Match match = null;
    private Image image = null;
    private FindFailedResponse response = FindFailed.defaultFindFailedResponse;
    private int index = -1;
    private List<Match> changes = null;
    private long time;
    private String name;
    private Object[] vals = new Object[]{null, null, null};

    protected ObserveEvent() {
    }

    protected ObserveEvent(String name, Type type, Object v1, Object v2, Object v3, long now) {
        this.init(name, type, v1, v2, v3, now);
    }

    private void init(String name, Type type, Object v1, Object v2, Object v3, long now) {
        this.name = name;
        this.type = type;
        this.time = now > 0L ? now : new Date().getTime();
        if (Type.GENERIC.equals((Object)type)) {
            this.setVals(v1, v2, v3);
        } else if (Type.FINDFAILED.equals((Object)type) || Type.MISSING.equals((Object)type)) {
            this.setRegion(v3);
            this.setImage(v2);
            this.setPattern(v1);
        } else {
            this.setRegion(v3);
            this.setMatch(v2);
            this.setPattern(v1);
        }
    }

    public String getType() {
        return this.type.toString();
    }

    public boolean isAppear() {
        return Type.APPEAR.equals((Object)this.type);
    }

    public boolean isVanish() {
        return Type.VANISH.equals((Object)this.type);
    }

    public boolean isChange() {
        return Type.CHANGE.equals((Object)this.type);
    }

    public boolean isGeneric() {
        return Type.GENERIC.equals((Object)this.type);
    }

    public boolean isFindFailed() {
        return Type.FINDFAILED.equals((Object)this.type);
    }

    public boolean isMissing() {
        return Type.MISSING.equals((Object)this.type);
    }

    protected void setVals(Object v1, Object v2, Object v3) {
        this.vals[0] = v1;
        this.vals[1] = v2;
        this.vals[2] = v3;
    }

    public Object[] getVals() {
        return this.vals;
    }

    public String getName() {
        return this.name;
    }

    public Region getRegion() {
        return this.region;
    }

    protected void setRegion(Object r) {
        if (r instanceof Region) {
            this.region = (Region)r;
        }
    }

    public Match getMatch() {
        return this.match;
    }

    protected void setMatch(Object m) {
        if (null != m && m instanceof Match) {
            this.match = new Match((Match)m);
        }
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public List<Match> getChanges() {
        return this.changes;
    }

    protected void setChanges(List<Match> c) {
        if (c != null) {
            this.changes = new ArrayList<Match>();
            this.changes.addAll(c);
        }
    }

    public Pattern getPattern() {
        return (Pattern)this.pattern;
    }

    public void setPattern(Object p) {
        if (null != p) {
            if (p.getClass().isInstance("")) {
                this.pattern = new Pattern((String)p);
            } else if (p instanceof Pattern) {
                this.pattern = new Pattern((Pattern)p);
            } else if (p instanceof Image) {
                this.pattern = new Pattern((Image)p);
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Object img) {
        this.image = (Image)img;
    }

    public void setResponse(FindFailedResponse resp) {
        this.response = resp;
    }

    public FindFailedResponse getResponse() {
        return this.response;
    }

    public long getTime() {
        return this.time;
    }

    public void repeat() {
        this.repeat(0L);
    }

    public void repeat(long secs) {
        this.region.getObserver().repeat(this.name, secs);
    }

    public int getCount() {
        return this.region.getObserver().getCount(this.name);
    }

    public void stopObserver() {
        this.region.stopObserver();
    }

    public void stopObserver(String text) {
        this.region.stopObserver(text);
    }

    public String toString() {
        if (this.type == Type.CHANGE) {
            return String.format("Event(%s) %s on: %s with: %d count: %d", new Object[]{this.type, this.name, this.region, this.index, this.getCount()});
        }
        return String.format("Event(%s) %s on: %s with: %s\nmatch: %s count: %d", new Object[]{this.type, this.name, this.region, this.pattern, this.match, this.getCount()});
    }

    public static enum Type {
        APPEAR,
        VANISH,
        CHANGE,
        GENERIC,
        FINDFAILED,
        MISSING;

    }
}

