/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.Date;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.RobotDesktop;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;
import org.sikuli.script.Sikulix;
import org.sikuli.util.EventObserver;
import org.sikuli.util.OverlayCapturePrompt;
import org.sikuli.util.ScreenHighlighter;

public class Screen
extends Region
implements IScreen {
    static RunTime runTime = RunTime.get();
    private static String me = "Screen: ";
    private static int lvl = 3;
    private static Region fakeRegion;
    private static IRobot globalRobot;
    protected static Screen[] screens;
    protected static int primaryScreen;
    private static int waitForScreenshot;
    protected IRobot robot = null;
    protected int curID = -1;
    protected int oldID = 0;
    protected int monitor = -1;
    protected boolean waitPrompt;
    protected OverlayCapturePrompt prompt;
    private static final String promptMsg = "Select a region on the screen";
    public static boolean ignorePrimaryAtCapture;
    public ScreenImage lastScreenImage = null;
    private static boolean isActiveCapturePrompt;
    private static EventObserver captureObserver;
    private long lastCaptureTime = -1L;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private static synchronized boolean setActiveCapturePrompt() {
        if (isActiveCapturePrompt) {
            return false;
        }
        Debug.log(3, "TRACE: Screen: setActiveCapturePrompt", new Object[0]);
        isActiveCapturePrompt = true;
        return true;
    }

    private static synchronized void resetActiveCapturePrompt() {
        Debug.log(3, "TRACE: Screen: resetActiveCapturePrompt", new Object[0]);
        isActiveCapturePrompt = false;
        captureObserver = null;
    }

    public int getcurrentID() {
        return this.curID;
    }

    private static void initScreens(boolean reset) {
        if (screens != null && !reset) {
            return;
        }
        Screen.log(lvl + 1, "initScreens: entry", new Object[0]);
        primaryScreen = 0;
        Screen.setMouseRobot();
        if (null == globalRobot) {
            screens = new Screen[1];
            Screen.screens[0] = null;
        } else {
            screens = new Screen[Screen.runTime.nMonitors];
            Screen.screens[0] = new Screen(0, Screen.runTime.mainMonitor);
            screens[0].initScreen();
            int nMonitor = 0;
            for (int i = 1; i < screens.length; ++i) {
                if (nMonitor == Screen.runTime.mainMonitor) {
                    ++nMonitor;
                }
                Screen.screens[i] = new Screen(i, nMonitor);
                screens[i].initScreen();
                ++nMonitor;
            }
            Mouse.init();
            if (Screen.getNumberScreens() > 1) {
                Screen.log(lvl, "initScreens: multi monitor mouse check", new Object[0]);
                Location lnow = Mouse.at();
                float mmd = Settings.MoveMouseDelay;
                Settings.MoveMouseDelay = 0.0f;
                Location lc = null;
                Location lcn = null;
                for (Screen s : screens) {
                    lc = s.getCenter();
                    Mouse.move(lc);
                    lcn = Mouse.at();
                    if (!lc.equals(lcn)) {
                        Screen.log(lvl, "*** multimonitor click check: %s center: (%d, %d) --- NOT OK:  (%d, %d)", s.toStringShort(), lc.x, lc.y, lcn.x, lcn.y);
                        continue;
                    }
                    Screen.log(lvl, "*** checking: %s center: (%d, %d) --- OK", s.toStringShort(), lc.x, lc.y);
                }
                Mouse.move(lnow);
                Settings.MoveMouseDelay = mmd;
            }
        }
    }

    public static IRobot getGlobalRobot() {
        return globalRobot;
    }

    private static void setMouseRobot() {
        try {
            if (globalRobot == null && !GraphicsEnvironment.isHeadless()) {
                globalRobot = new RobotDesktop();
            }
        }
        catch (AWTException e) {
            Debug.error("Can't initialize global Robot for Mouse: " + e.getMessage(), new Object[0]);
        }
    }

    private IRobot getMouseRobot() {
        Screen.setMouseRobot();
        if (null == globalRobot && !GraphicsEnvironment.isHeadless()) {
            Screen.log(-1, "problem getting a java.awt.Robot", new Object[0]);
            Sikulix.endError(999);
        }
        return globalRobot;
    }

    protected static Region getFakeRegion() {
        if (fakeRegion == null) {
            fakeRegion = new Region(0, 0, 5, 5);
        }
        return fakeRegion;
    }

    public static ScreenUnion all() {
        return new ScreenUnion();
    }

    private Screen(int id, boolean init) {
        this.curID = id;
    }

    private Screen(int id, int monitor) {
        this.curID = id;
        this.monitor = monitor;
    }

    public static Screen as(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen(%d) not in valid range 0 to %d - using primary %d", id, Screen.runTime.nMonitors - 1, primaryScreen);
            return screens[0];
        }
        return screens[id];
    }

    public Screen(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen(%d) not in valid range 0 to %d - using primary %d", id, Screen.runTime.nMonitors - 1, primaryScreen);
            this.curID = primaryScreen;
        } else {
            this.curID = id;
        }
        this.monitor = Screen.screens[this.curID].monitor;
        this.initScreen();
    }

    public Screen(boolean isScreenUnion) {
        super(isScreenUnion);
    }

    public void setAsScreenUnion() {
        this.oldID = this.curID;
        this.curID = -1;
    }

    public void setAsScreen() {
        this.curID = this.oldID;
    }

    public Screen() {
        this.curID = primaryScreen;
        this.initScreen();
    }

    public void initScreen(Screen scr) {
        this.updateSelf();
    }

    private void initScreen() {
        Rectangle bounds = this.getBounds();
        this.x = (int)bounds.getX();
        this.y = (int)bounds.getY();
        this.w = (int)bounds.getWidth();
        this.h = (int)bounds.getHeight();
        this.robot = globalRobot;
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    protected Region setScreen(IScreen s) {
        throw new UnsupportedOperationException("The setScreen() method cannot be called from a Screen object.");
    }

    public static void showMonitors() {
        Debug.logp("*** monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.logp("*** Primary is Screen %d", primaryScreen);
        for (int i = 0; i < Screen.runTime.nMonitors; ++i) {
            Debug.logp("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.logp("*** end monitor configuration ***", new Object[0]);
    }

    public static void resetMonitors() {
        Debug.error("*** BE AWARE: experimental - might not work ***", new Object[0]);
        Debug.error("Re-evaluation of the monitor setup has been requested", new Object[0]);
        Debug.error("... Current Region/Screen objects might not be valid any longer", new Object[0]);
        Debug.error("... Use existing Region/Screen objects only if you know what you are doing!", new Object[0]);
        Screen.initScreens(true);
        Debug.logp("*** new monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.logp("*** Primary is Screen %d", primaryScreen);
        for (int i = 0; i < Screen.runTime.nMonitors; ++i) {
            Debug.logp("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.error("*** end new monitor configuration ***", new Object[0]);
    }

    protected boolean useFullscreen() {
        return false;
    }

    private static int getValidID(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen: invalid screen id %d - using primary screen", id);
            return primaryScreen;
        }
        return id;
    }

    private static int getValidMonitor(int id) {
        if (id < 0 || id >= Screen.runTime.nMonitors) {
            Debug.error("Screen: invalid screen id %d - using primary screen", id);
            return Screen.runTime.mainMonitor;
        }
        return Screen.screens[id].monitor;
    }

    public static int getNumberScreens() {
        return Screen.runTime.nMonitors;
    }

    public static int getPrimaryId() {
        return primaryScreen;
    }

    public static Screen getPrimaryScreen() {
        return screens[primaryScreen];
    }

    public static Screen getScreen(int id) {
        return screens[Screen.getValidID(id)];
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(runTime.getMonitor(this.monitor));
    }

    public static Rectangle getBounds(int id) {
        return new Rectangle(runTime.getMonitor(Screen.getValidMonitor(id)));
    }

    public static IRobot getRobot(int id) {
        return Screen.getScreen(id).getRobot();
    }

    @Override
    public int getID() {
        return this.curID;
    }

    @Override
    public int getIdFromPoint(int x, int y) {
        return this.curID;
    }

    @Override
    public IRobot getRobot() {
        return this.getMouseRobot();
    }

    protected static IRobot getRobot(Region reg) {
        if (reg == null || null == reg.getScreen()) {
            return Screen.getPrimaryScreen().getMouseRobot();
        }
        return reg.getScreen().getRobot();
    }

    @Override
    public Region newRegion(Location loc, int width, int height) {
        return Region.create(loc.copyTo(this), width, height);
    }

    @Override
    public Region newRegion(Region reg) {
        return null;
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    @Override
    public Location newLocation(Location loc) {
        return new Location(loc).copyTo(this);
    }

    @Override
    public Region newRegion(int x, int y, int w, int h) {
        return null;
    }

    public ScreenImage cmdCapture(Object ... args) {
        if (args.length == 0) {
            return this.userCapture("capture an image");
        }
        Object arg0 = args[0];
        if (args.length == 1) {
            if (arg0 instanceof String) {
                return this.userCapture((String)arg0);
            }
            if (arg0 instanceof Region) {
                return this.capture((Region)arg0);
            }
            if (arg0 instanceof Rectangle) {
                return this.capture((Rectangle)arg0);
            }
        } else if (args.length > 1 && args.length < 4) {
            Object arg1 = args[1];
            String path = "";
            String name = "";
            if ((arg0 instanceof Region || arg0 instanceof String) && arg1 instanceof String) {
                if (args.length == 3) {
                    Object arg2 = args[2];
                    if (arg2 instanceof String) {
                        name = (String)arg2;
                        path = (String)arg1;
                    }
                } else {
                    name = (String)arg1;
                }
                if (!name.isEmpty()) {
                    ScreenImage shot = null;
                    shot = arg0 instanceof Region ? this.capture((Region)arg0) : this.userCapture((String)arg0);
                    if (shot != null) {
                        if (!path.isEmpty()) {
                            shot.getFile(path, name);
                        } else {
                            shot.saveInBundle(name);
                        }
                        return shot;
                    }
                    return null;
                }
            }
        } else if (args.length == 4) {
            Integer argInt = null;
            for (Object arg : args) {
                argInt = null;
                try {
                    argInt = (Integer)arg;
                }
                catch (Exception ex) {
                    break;
                }
            }
            if (argInt != null) {
                return this.capture((Integer)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3]);
            }
        }
        return this.userCapture("Invalid parameter for capture");
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getRect());
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        Rectangle rect = this.newRegion(new Location(x, y), w, h).getRect();
        return this.capture(rect);
    }

    public ScreenImage captureforHighlight(int x, int y, int w, int h) {
        return this.robot.captureScreen(new Rectangle(x, y, w, h));
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        this.lastCaptureTime = new Date().getTime();
        ScreenImage simg = this.robot.captureScreen(rect);
        if (Settings.FindProfiling) {
            Debug.logp("[FindProfiling] Screen.capture [%d x %d]: %d msec", rect.width, rect.height, new Date().getTime() - this.lastCaptureTime);
        }
        this.lastScreenImage = simg;
        if (Debug.getDebugLevel() > lvl) {
            simg.saveLastScreenImage(Screen.runTime.fSikulixStore);
        }
        return simg;
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.getRect());
    }

    public static void doPrompt(String message, EventObserver obs) {
        captureObserver = obs;
        Screen.getPrimaryScreen().userCapture(message);
    }

    public static void closePrompt() {
        for (int is = 0; is < Screen.getNumberScreens(); ++is) {
            if (!Screen.getScreen(is).hasPrompt()) continue;
            Screen.getScreen((int)is).prompt.close();
        }
    }

    public static void closePrompt(Screen scr) {
        for (int is = 0; is < Screen.getNumberScreens(); ++is) {
            if (Screen.getScreen(is).getID() == scr.getID() || !Screen.getScreen(is).hasPrompt()) continue;
            Screen.getScreen((int)is).prompt.close();
            Screen.getScreen((int)is).prompt = null;
        }
    }

    public static void resetPrompt(OverlayCapturePrompt ocp) {
        int scrID = ocp.getScrID();
        if (scrID > -1) {
            Screen.getScreen((int)scrID).prompt = null;
        }
        Screen.resetActiveCapturePrompt();
    }

    public boolean hasPrompt() {
        return this.prompt != null;
    }

    public ScreenImage userCapture() {
        return this.userCapture("");
    }

    @Override
    public ScreenImage userCapture(final String message) {
        if (!Screen.setActiveCapturePrompt()) {
            return null;
        }
        Debug.log(3, "TRACE: Screen: userCapture", new Object[0]);
        this.waitPrompt = true;
        Thread th = new Thread(){

            @Override
            public void run() {
                String msg = message.isEmpty() ? Screen.promptMsg : message;
                for (int is = 0; is < Screen.getNumberScreens(); ++is) {
                    if (ignorePrimaryAtCapture && is == 0) continue;
                    Screen.getScreen((int)is).prompt = new OverlayCapturePrompt(Screen.getScreen(is));
                    Screen.getScreen((int)is).prompt.addObserver(captureObserver);
                    Screen.getScreen((int)is).prompt.prompt(msg);
                }
            }
        };
        th.start();
        if (captureObserver != null) {
            return null;
        }
        boolean isComplete = false;
        ScreenImage simg = null;
        int count = 0;
        while (!isComplete) {
            this.wait(0.1f);
            if (count++ > waitForScreenshot) break;
            for (int is = 0; is < Screen.getNumberScreens(); ++is) {
                OverlayCapturePrompt ocp = Screen.getScreen((int)is).prompt;
                if (ocp == null || !ocp.isComplete()) continue;
                Screen.closePrompt(Screen.getScreen(is));
                simg = ocp.getSelection();
                if (simg != null) {
                    Screen.getScreen((int)is).lastScreenImage = simg;
                }
                ocp.close();
                Screen.getScreen((int)is).prompt = null;
                isComplete = true;
            }
        }
        Screen.resetActiveCapturePrompt();
        return simg;
    }

    public String saveCapture(String name) {
        return this.saveCapture(name, null);
    }

    public String saveCapture(String name, Region reg) {
        ScreenImage simg = reg == null ? this.userCapture("Capture for image " + name) : this.capture(reg);
        if (simg == null) {
            return null;
        }
        return simg.saveInBundle(name);
    }

    public Region selectRegion() {
        return this.selectRegion(promptMsg);
    }

    public Region selectRegion(String message) {
        Debug.log(3, "TRACE: Screen: selectRegion", new Object[0]);
        ScreenImage sim = this.userCapture(message);
        if (sim == null) {
            return null;
        }
        Rectangle r = sim.getROI();
        return Region.create((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @Override
    public void showTarget(Location loc) {
        this.showTarget(loc, Settings.SlowMotionDelay);
    }

    protected void showTarget(Location loc, double secs) {
        if (Settings.isShowActions()) {
            ScreenHighlighter overlay = new ScreenHighlighter(this, null);
            overlay.showTarget(loc, (float)secs);
        }
    }

    @Override
    public String toString() {
        Rectangle r = this.getBounds();
        String scrText = this.curID == -1 ? "Union" : "" + this.curID;
        return String.format("S(%s)[%d,%d %dx%d] E:%s, T:%.1f", scrText, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight(), this.getThrowException() ? "Y" : "N", this.getAutoWaitTimeout());
    }

    @Override
    public String toStringShort() {
        Rectangle r = this.getBounds();
        String scrText = this.curID == -1 ? "Union" : "" + this.curID;
        return String.format("S(%s)[%d,%d %dx%d]", scrText, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @Override
    public Region setOther(Region element) {
        return element.setOtherScreen(this);
    }

    @Override
    public Location setOther(Location element) {
        return element.setOtherScreen(this);
    }

    @Override
    public Location newLocation(int x, int y) {
        return new Location(x, y).setOtherScreen(this);
    }

    static {
        globalRobot = null;
        screens = null;
        primaryScreen = -1;
        waitForScreenshot = 300;
        ignorePrimaryAtCapture = false;
        isActiveCapturePrompt = false;
        captureObserver = null;
        RunTime.loadLibrary("VisionProxy");
        Screen.initScreens(false);
    }
}

