/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.setup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.LineBorder;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;
import org.sikuli.basics.SplashFrame;
import org.sikuli.script.RunTime;
import org.sikuli.setup.SetUpSelect;
import org.sikuli.util.LinuxSupport;
import org.sikuli.util.ProcessRunner;

public class RunSetup {
    private static File fDownloadsGeneric = null;
    private static String downloadedFiles;
    private static boolean noSetup;
    private static String workDir;
    private static File fWorkDir;
    private static String logfile;
    private static String version;
    private static String minorversion;
    private static String majorversion;
    private static String updateVersion;
    private static String downloadIDE;
    private static String downloadAPI;
    private static String downloadLibsMac;
    private static String downloadLibsWin;
    private static String downloadLibsLux;
    private static String downloadRServer;
    private static String downloadJython;
    private static String downloadJython25;
    private static String downloadJRuby;
    private static String downloadJRubyAddOns;
    private static String localAPI;
    private static String localIDE;
    private static String localSetup;
    private static String localTess;
    private static String localJython;
    private static String localJRuby;
    private static String localJRubyAddOns;
    private static String runsikulix;
    private static String localLogfile;
    private static SetUpSelect winSU;
    private static JFrame winSetup;
    private static boolean getIDE;
    private static boolean getJython;
    private static boolean getAPI;
    private static boolean getRServer;
    private static boolean forAllSystems;
    private static boolean getTess;
    private static boolean getJRuby;
    private static boolean getJRubyAddOns;
    private static String localJar;
    private static boolean hasOptions;
    private static List<String> options;
    private static JFrame splash;
    private static String me;
    private static int lvl;
    private static String msg;
    private static boolean shouldPackBundledLibs;
    private static long start;
    private static boolean logToFile;
    private static boolean forSystemWin;
    private static boolean forSystemMac;
    private static boolean forSystemLux;
    private static String libsMac;
    private static String libsWin;
    private static String libsLux;
    private static File folderLib;
    private static File folderLibsWin;
    private static File folderLibsLux;
    private static String linuxDistro;
    private static String osarch;
    private static boolean isLinux;
    private static boolean libsProvided;
    private static String[] addonFileList;
    private static String[] addonFilePrefix;
    private static int addonVision;
    private static int addonGrabKey;
    private static int addonLibswindows;
    private static int addonFolderLib;
    private static boolean notests;
    private static boolean clean;
    private static RunTime runTime;
    private static File fDownloadsGenericApp;
    private static boolean useLibsProvided;
    private static File fDownloadsObsolete;
    private static boolean runningWithProject;
    private static boolean shouldBuildVision;
    private static boolean bequiet;
    private static String sikulixMavenGroup;
    private static boolean withExtensions;
    static Map<String, String> downloadsLookfor;
    static Map<String, File> downloadsFound;
    private static File fSetupStuff;
    private static boolean hasAPI;
    private static String[] jarsList;
    private static boolean testingMaven;
    private static boolean useLocalMavenRepo;
    static String useReleaseVersion;
    static String releaseVersion;

    private static void logp(String message, Object ... args) {
        System.out.println(String.format(message, args));
    }

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + ": " + message, args);
    }

    private static void logPlus(int level, String message, Object ... args) {
        String sout = Debug.logx(level, me + ": " + message, args);
        if (logToFile) {
            System.out.println(sout);
        }
    }

    public static void main(String[] args) throws IOException {
        String sDownloadedName;
        String targetJar;
        String sDownloaded;
        String dlDir;
        runTime = RunTime.get(RunTime.Type.SETUP, args);
        version = runTime.getVersionShort();
        minorversion = runTime.getVersionShort().substring(0, 5);
        majorversion = runTime.getVersionShort().substring(0, 3);
        if (args.length > 0 && "test".equals(args[0])) {
            testingMaven = true;
        }
        localSetup = String.format("sikulixsetup-%s-%s-project.jar", version, RunSetup.runTime.sxBuildStamp);
        if (RunSetup.runTime.fSxBaseJar.getPath().contains(localSetup)) {
            runningWithProject = true;
        }
        if (!testingMaven && (RunSetup.runTime.runningInProject || runningWithProject)) {
            runningWithProject = true;
            RunSetup.runTime.shouldCleanDownloads = true;
            downloadIDE = String.format("sikulixsetupIDE-%s-%s.jar", version, RunSetup.runTime.sxBuildStamp);
            downloadAPI = String.format("sikulixsetupAPI-%s-%s.jar", version, RunSetup.runTime.sxBuildStamp);
            downloadLibsMac = String.format("sikulixlibsmac-%s-%s.jar", version, RunSetup.runTime.sxBuildStamp);
            downloadLibsWin = String.format("sikulixlibswin-%s-%s.jar", version, RunSetup.runTime.sxBuildStamp);
            downloadLibsLux = String.format("sikulixlibslux-%s-%s.jar", version, RunSetup.runTime.sxBuildStamp);
        } else {
            localSetup = "sikulixsetup-" + version + ".jar";
            downloadIDE = RunSetup.getMavenJarName("sikulixsetupIDE#forsetup");
            downloadAPI = RunSetup.getMavenJarName("sikulixsetupAPI#forsetup");
            downloadLibsMac = RunSetup.getMavenJarName("sikulixlibsmac");
            downloadLibsWin = RunSetup.getMavenJarName("sikulixlibswin");
            downloadLibsLux = RunSetup.getMavenJarName("sikulixlibslux");
        }
        downloadJython = new File(RunSetup.runTime.SikuliJythonMaven).getName();
        downloadJython25 = new File(RunSetup.runTime.SikuliJythonMaven25).getName();
        downloadJRuby = new File(RunSetup.runTime.SikuliJRubyMaven).getName();
        updateVersion = RunSetup.runTime.SikuliVersionBetaN > 0 && RunSetup.runTime.SikuliVersionBetaN < 99 ? String.format("%d.%d.%d-Beta%d", RunSetup.runTime.SikuliVersionMajor, RunSetup.runTime.SikuliVersionMinor, RunSetup.runTime.SikuliVersionSub, 1 + RunSetup.runTime.SikuliVersionBetaN) : (RunSetup.runTime.SikuliVersionBetaN < 1 ? String.format("%d.%d.%d", RunSetup.runTime.SikuliVersionMajor, RunSetup.runTime.SikuliVersionMinor, 1 + RunSetup.runTime.SikuliVersionSub) : String.format("%d.%d.%d", RunSetup.runTime.SikuliVersionMajor, 1 + RunSetup.runTime.SikuliVersionMinor, 0));
        options.addAll(Arrays.asList(args));
        if (args.length > 0 && "stamp".equals(args[0])) {
            System.out.println(RunSetup.runTime.SikuliProjectVersion + "-" + RunSetup.runTime.sxBuildStamp);
            System.exit(0);
        }
        if (args.length > 0 && "frommavenforsed".equals(args[0])) {
            bequiet = true;
            String name = RunSetup.getMavenJarPath(args[2]);
            if (name == null) {
                name = RunSetup.runTime.dlMavenSnapshot + sikulixMavenGroup;
            }
            name = name.replaceAll("/", "\\\\/");
            System.out.println(name);
            System.exit(0);
        }
        if (args.length > 0 && "build".equals(args[0])) {
            System.out.println(RunSetup.runTime.SikuliVersionBuild);
            System.exit(0);
        }
        if (args.length > 0 && "pversion".equals(args[0])) {
            System.out.println(RunSetup.runTime.SikuliProjectVersion);
            System.exit(0);
        }
        if (args.length > 0 && "uversion".equals(args[0])) {
            System.out.println(RunSetup.runTime.SikuliProjectVersionUsed);
            System.exit(0);
        }
        if (args.length > 0 && "version".equals(args[0])) {
            System.out.println(runTime.getVersionShort());
            System.exit(0);
        }
        if (args.length > 0 && "minorversion".equals(args[0])) {
            System.out.println(minorversion);
            System.exit(0);
        }
        if (args.length > 0 && "majorversion".equals(args[0])) {
            System.out.println(majorversion);
            System.exit(0);
        }
        if (args.length > 0 && "updateversion".equals(args[0])) {
            System.out.println(updateVersion);
            System.exit(0);
        }
        if (options.size() > 0 && "noSetup".equals(options.get(0))) {
            noSetup = true;
            options.remove(0);
        }
        if (testingMaven) {
            if (runTime.isVersionRelease()) {
                useLocalMavenRepo = true;
            }
            options.remove(0);
        }
        boolean makingScriptjar = false;
        if (options.size() > 0 && "scriptjar".equals(options.get(0))) {
            makingScriptjar = true;
            hasOptions = true;
            options.remove(0);
        }
        if (options.size() > 0 && "options".equals(options.get(0))) {
            options.remove(0);
            if (!options.isEmpty()) {
                for (String val : options) {
                    if (val.contains("1.1")) {
                        hasOptions = true;
                        getIDE = true;
                        getJython = true;
                        continue;
                    }
                    if (val.contains("1.2")) {
                        hasOptions = true;
                        getIDE = true;
                        getJRuby = true;
                        continue;
                    }
                    if (val.contains("1.3")) {
                        hasOptions = true;
                        getIDE = true;
                        getJRuby = true;
                        getJRubyAddOns = true;
                        continue;
                    }
                    if ("2".equals(val)) {
                        hasOptions = true;
                        getAPI = true;
                        continue;
                    }
                    if ("3".equals(val)) {
                        hasOptions = true;
                        getTess = true;
                        continue;
                    }
                    if ("4".equals(val)) {
                        hasOptions = true;
                        forAllSystems = true;
                        continue;
                    }
                    if (val.contains("4.1")) {
                        hasOptions = true;
                        forSystemWin = true;
                        continue;
                    }
                    if (val.contains("4.2")) {
                        hasOptions = true;
                        forSystemMac = true;
                        continue;
                    }
                    if (val.contains("4.3")) {
                        hasOptions = true;
                        forSystemLux = true;
                        continue;
                    }
                    if ("5".equals(val)) {
                        hasOptions = true;
                        getRServer = true;
                        continue;
                    }
                    if (val.toLowerCase().startsWith("lib")) {
                        hasOptions = true;
                        libsProvided = true;
                        continue;
                    }
                    if (val.toLowerCase().startsWith("buildv")) {
                        hasOptions = true;
                        shouldBuildVision = true;
                        continue;
                    }
                    if (val.toLowerCase().startsWith("not")) {
                        notests = true;
                        continue;
                    }
                    if (val.toLowerCase().startsWith("clean")) {
                        clean = true;
                        continue;
                    }
                    if (!val.toLowerCase().startsWith("ext")) continue;
                    hasOptions = true;
                    withExtensions = true;
                }
                options.clear();
            }
        }
        if (makingScriptjar) {
            String target = FileManager.makeScriptjar(options);
            if (null != target) {
                RunSetup.log(0, "makingScriptJar: ended successfully: %s", target);
                System.exit(0);
            } else {
                RunSetup.log(0, "makingScriptJar: did not work", new Object[0]);
                System.exit(1);
            }
        }
        String splashJava9 = "";
        if (runTime.isJava9(new String[0])) {
            splashJava9 = "*** on Java8+ *** ";
        }
        if (!hasOptions && !testingMaven) {
            Object msg = String.format("You are about to run a setup for %s (%s)", version, RunSetup.runTime.sxBuildStamp);
            msg = (String)msg + "\n\nYou should have a suitable backup, ";
            msg = (String)msg + "\nto go back in case to what you have now.";
            if (!RunSetup.popAsk((String)(msg = (String)msg + "\n\n" + splashJava9 + "Click NO to stop here "))) {
                RunSetup.userTerminated("");
            }
        }
        localLogfile = "SikuliX-" + version + "-SetupLog.txt";
        if (options.size() > 0) {
            if (!"-jar".equals(options.get(0))) {
                System.out.println("invalid command line options - terminating");
                for (String string : options) {
                    System.out.println("option: " + string);
                }
                System.exit(-1);
            }
            RunSetup.log(lvl, "Seems to be run using mvn exec:exec", new Object[0]);
        } else {
            RunSetup.log(lvl, "command line options:", new Object[0]);
            String strArgs = "";
            for (String arg : args) {
                strArgs = strArgs + arg + " ";
            }
            RunSetup.log(lvl, "%s", strArgs);
        }
        Settings.runningSetup = true;
        Settings.LogTime = true;
        runTime.makeFolders();
        fWorkDir = RunSetup.runTime.fSxBase;
        fDownloadsGeneric = RunSetup.runTime.fSikulixDownloadsGeneric;
        fDownloadsGeneric.mkdirs();
        fDownloadsGenericApp = RunSetup.runTime.fSikulixDownloadsBuild;
        fDownloadsGenericApp.mkdirs();
        if (testingMaven || RunSetup.runTime.runningInProject) {
            fWorkDir = RunSetup.runTime.fSikulixSetup;
            fWorkDir.mkdir();
        }
        fDownloadsObsolete = new File(fWorkDir, "Downloads");
        workDir = fWorkDir.getAbsolutePath();
        fSetupStuff = new File(fWorkDir, "SetupStuff");
        FileManager.resetFolder(fSetupStuff);
        osarch = "" + RunSetup.runTime.javaArch;
        if (RunSetup.runTime.runningLinux) {
            linuxDistro = RunSetup.runTime.linuxDistro;
            isLinux = true;
        }
        if (!testingMaven && RunSetup.runTime.runningInProject) {
            if (noSetup) {
                RunSetup.log(lvl, "creating Setup folder - not running setup", new Object[0]);
            } else {
                RunSetup.log(lvl, "have to create Setup folder before running setup", new Object[0]);
            }
            if (!RunSetup.createSetupFolder(fWorkDir)) {
                RunSetup.log(-1, "createSetupFolder: did not work- terminating", new Object[0]);
                System.exit(1);
            }
            if (noSetup) {
                System.exit(0);
            }
            logToFile = false;
        }
        RunSetup.checkDownloads();
        if (logToFile && !Debug.setLogFile(logfile = new File(fWorkDir, localLogfile).getAbsolutePath())) {
            RunSetup.popError(workDir + "\n... folder we are running in must be user writeable! \nplease correct the problem and start again.");
            System.exit(0);
        }
        if (args.length > 0) {
            RunSetup.logPlus(lvl, "... starting with: " + RunSetup.arrayToString(args), new Object[0]);
        } else {
            RunSetup.logPlus(lvl, "... starting with no args given", new Object[0]);
        }
        if (isLinux) {
            RunSetup.logPlus(lvl, "LinuxDistro: %s (%s-Bit)", linuxDistro, osarch);
        }
        RunSetup.logPlus(lvl, "Setup: %s %s in folder:\n%s", runTime.getVersionShort(), RunSetup.runTime.SikuliVersionBuild, fWorkDir);
        File localJarIDE = new File(fWorkDir, localIDE);
        File file = new File(fWorkDir, localAPI);
        folderLibsWin = new File(fSetupStuff, "sikulixlibs/windows");
        folderLib = new File(fSetupStuff, "Lib");
        folderLibsLux = RunSetup.runTime.fLibsProvided;
        if (!libsProvided && LinuxSupport.existsLibs()) {
            if (RunSetup.popAsk(String.format("Found a libs folder at\n%s\nClick YES to use the contained libs for setup (be sure they are useable).\nClick NO to make a clean setup (libs are deleted).", folderLibsLux))) {
                useLibsProvided = true;
            } else {
                FileManager.resetFolder(folderLibsLux);
            }
        }
        String proxyMsg = "";
        if (!hasOptions) {
            getIDE = false;
            getJython = false;
            getAPI = false;
            winSetup = new JFrame("SikuliX-Setup");
            LineBorder rpb = new LineBorder(Color.YELLOW, 8);
            winSetup.getRootPane().setBorder(rpb);
            Container winCP = winSetup.getContentPane();
            winCP.setLayout(new BorderLayout());
            winSU = new SetUpSelect();
            winCP.add((Component)winSU, "Center");
            RunSetup.winSU.option2.setSelected(true);
            winSetup.pack();
            winSetup.setLocationRelativeTo(null);
            winSetup.setDefaultCloseOperation(0);
            winSetup.setVisible(true);
            RunSetup.winSU.suVersion.setText(runTime.getVersionShort() + "   (" + RunSetup.runTime.SikuliVersionBuild + ")");
            Settings.getOS();
            msg = RunSetup.runTime.osName + " " + Settings.getOSVersion();
            if (isLinux) {
                msg = msg + " (" + linuxDistro + ")";
            }
            RunSetup.winSU.suSystem.setText(msg);
            RunSetup.logPlus(lvl, "RunningSystem: " + msg, new Object[0]);
            RunSetup.winSU.suFolder.setText(workDir);
            RunSetup.logPlus(lvl, "parent of jar/classes: %s", workDir);
            String osarch = System.getProperty("os.arch");
            msg = "Java " + Settings.JavaVersion + " (" + Settings.JavaArch + ") " + Settings.JREVersion;
            RunSetup.winSU.suJava.setText(msg);
            RunSetup.logPlus(lvl, "RunningJava: " + msg, new Object[0]);
            PreferencesUser prefs = PreferencesUser.getInstance();
            boolean prefsHaveProxy = false;
            String pName = prefs.get("ProxyName", "");
            String pPort = prefs.get("ProxyPort", "");
            if (!pName.isEmpty() && !pPort.isEmpty()) {
                prefsHaveProxy = true;
                RunSetup.winSU.pName.setText(pName);
                RunSetup.winSU.pPort.setText(pPort);
            }
            winSU.addPropertyChangeListener("background", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    winSetup.setVisible(false);
                }
            });
            while (winSU.getBackground() != Color.YELLOW) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            pName = RunSetup.winSU.pName.getText();
            pPort = RunSetup.winSU.pPort.getText();
            if (!pName.isEmpty() && !pPort.isEmpty()) {
                if (FileManager.setProxy(pName, pPort)) {
                    RunSetup.logPlus(lvl, "Requested to run with proxy: %s ", Settings.proxy);
                    proxyMsg = "... using proxy: " + Settings.proxy;
                }
            } else if (prefsHaveProxy) {
                prefs.put("ProxyName", "");
                prefs.put("ProxyPort", "");
            }
            Settings.proxyChecked = true;
            if (RunSetup.winSU.option1.isSelected()) {
                getIDE = true;
                if (RunSetup.winSU.option2.isSelected()) {
                    getJython = true;
                }
                if (RunSetup.winSU.option3.isSelected()) {
                    getJRuby = true;
                }
                if (!getJython && !getJRuby) {
                    getIDE = false;
                }
            }
            if (RunSetup.winSU.option4.isSelected()) {
                getAPI = true;
            }
            if (RunSetup.winSU.option5.isSelected()) {
                getTess = true;
            }
            if ((getTess || forAllSystems) && !getIDE && !getAPI) {
                RunSetup.popError("You only selected Option 3 !\nThis is currently not supported.\nPlease start allover again with valid options.\n");
                RunSetup.terminate("");
            }
            msg = "The following file(s) will be downloaded to\n" + workDir + "\n";
        }
        getTess = false;
        downloadedFiles = "";
        if (getIDE || getAPI || getRServer) {
            if (!proxyMsg.isEmpty()) {
                msg = msg + proxyMsg + "\n";
            }
            if (forAllSystems) {
                msg = msg + "\n--- Native support libraries for all systems (sikulixlibs...)\n";
                downloadedFiles = downloadedFiles + downloadLibsWin + " ";
                downloadedFiles = downloadedFiles + downloadLibsMac + " ";
                downloadedFiles = downloadedFiles + downloadLibsLux + " ";
            } else {
                msg = msg + "\n--- Native support libraries for " + RunSetup.runTime.osName + " (sikulixlibs...)\n";
                if (RunSetup.runTime.runningWindows) {
                    downloadedFiles = downloadedFiles + downloadLibsWin + " ";
                } else if (RunSetup.runTime.runningMac) {
                    downloadedFiles = downloadedFiles + downloadLibsMac + " ";
                } else if (RunSetup.runTime.runningLinux) {
                    downloadedFiles = downloadedFiles + downloadLibsLux + " ";
                }
            }
            if (getIDE) {
                downloadedFiles = downloadedFiles + downloadIDE + " ";
                downloadedFiles = downloadedFiles + downloadAPI + " ";
                msg = msg + "\n--- Package 1 ---\n" + downloadIDE + " (IDE/Scripting)\n" + downloadAPI + " (Java API)";
                if (getJython) {
                    downloadedFiles = downloadedFiles + downloadJython + " ";
                    msg = msg + "\n - with Jython";
                }
                if (getJRuby) {
                    downloadedFiles = downloadedFiles + downloadJRuby + " ";
                    msg = msg + "\n - with JRuby";
                    if (downloadJRubyAddOns != null) {
                        if (getJRubyAddOns) {
                            downloadedFiles = downloadedFiles + downloadJRubyAddOns + " ";
                            msg = msg + " incl. AddOns";
                        }
                    } else {
                        getJRubyAddOns = false;
                    }
                }
                if (Settings.isMac()) {
                    msg = msg + "\n - creating Mac application";
                }
                msg = msg + "\n";
            }
            if (getAPI) {
                msg = msg + "\n--- Package 2 ---\n" + downloadAPI;
                if (!getIDE) {
                    downloadedFiles = downloadedFiles + downloadAPI + " ";
                    msg = msg + " (Java API)";
                } else {
                    msg = msg + " (done in package 1)";
                }
            }
            if (getTess || getRServer) {
                if (getIDE || getAPI) {
                    msg = msg + "\n";
                }
                msg = msg + "\n--- Additions ---";
                if (getTess) {
                    downloadedFiles = downloadedFiles + "tessdata-eng ";
                    msg = msg + "\ntessdata-eng (Tesseract)";
                }
                if (downloadRServer != null) {
                    if (getRServer) {
                        downloadedFiles = downloadedFiles + downloadRServer + " ";
                        msg = msg + "\n" + downloadRServer + " (RemoteServer)";
                    }
                } else {
                    getRServer = false;
                }
            }
        }
        if (getIDE || getAPI || getRServer || withExtensions) {
            if (!RunSetup.popAsk(msg = msg + "\n\nOnly click NO, if you want to terminate setup now!\nClick YES even if you want to use local copies in Downloads!")) {
                RunSetup.terminate("");
            }
        } else {
            RunSetup.popError("Nothing selected! You might try again ;-)");
            RunSetup.terminate("");
        }
        String localTemp = "sikulixtemp.jar";
        localJar = null;
        boolean downloadOK = true;
        boolean dlOK = true;
        downloadOK = true;
        String dlDirGenericApp = fDownloadsGenericApp.getAbsolutePath();
        String dlDirGeneric = fDownloadsGeneric.getAbsolutePath();
        String dlDownloads = fDownloadsObsolete.getAbsolutePath();
        boolean shouldUseDownloads = hasOptions && fDownloadsObsolete.exists();
        String string = dlDir = shouldUseDownloads ? dlDownloads : dlDirGenericApp;
        if (!(forSystemWin || forSystemMac || forSystemLux)) {
            forSystemLux = isLinux;
            if (!isLinux) {
                forSystemWin = Settings.isWindows();
                forSystemMac = Settings.isMac();
            }
        }
        File fDownloaded = null;
        if (testingMaven) {
            fDownloaded = RunSetup.downloadJarFromMavenSx("sikulixsetup#forsetup", fWorkDir.getAbsolutePath(), "sikulixsetup");
            if (fDownloaded == null) {
                RunSetup.logPlus(-1, "%s not possible to copy from local MavenRepo", new Object[0]);
                downloadOK = false;
            }
            String fpDownloaded = fDownloaded.getAbsolutePath();
            fpDownloaded = fpDownloaded.replace("-forsetup", "");
            fDownloaded.renameTo(new File(fpDownloaded));
        }
        if (getIDE || getAPI) {
            if (forSystemLux || forAllSystems) {
                RunSetup.jarsList[8] = new File(workDir, libsLux + ".jar").getAbsolutePath();
                fDownloaded = RunSetup.downloadedAlready("lux", "Linux native libs", false);
                if (fDownloaded == null) {
                    fDownloaded = RunSetup.downloadJarFromMavenSx(libsLux, dlDirGeneric, libsLux);
                }
                if ((downloadOK &= RunSetup.copyFromDownloads(fDownloaded, libsLux, jarsList[8])) && isLinux) {
                    if (shouldBuildVision) {
                        RunSetup.logPlus(lvl, "Requested to build libVisionProxy.so on the fly", new Object[0]);
                        if (!LinuxSupport.haveToBuild()) {
                            RunSetup.terminate("Building libVisionproxy.so not possible - check the log");
                        }
                    }
                    RunSetup.logPlus(lvl, "checking usability of bundled, provided or built libs", new Object[0]);
                    if (!RunTime.loadLibrary("VisionProxy", useLibsProvided)) {
                        RunSetup.logPlus(-1, "libVisionproxy.so finally not useable", new Object[0]);
                        RunSetup.terminate("Giving up!");
                    } else {
                        RunSetup.logPlus(lvl, "Bundled, provided or built libVisionproxy.so is useable", new Object[0]);
                    }
                    boolean bl = useLibsProvided = RunSetup.runTime.useLibsProvided || LinuxSupport.shouldUseProvided;
                }
            }
            if (forSystemWin || forAllSystems) {
                boolean dlLibsWinOK;
                RunSetup.jarsList[6] = new File(workDir, libsWin + ".jar").getAbsolutePath();
                fDownloaded = RunSetup.downloadedAlready("win", "Windows native libs", false);
                if (fDownloaded == null) {
                    fDownloaded = RunSetup.downloadJarFromMavenSx(libsWin, dlDirGeneric, libsWin);
                }
                if (dlLibsWinOK = RunSetup.copyFromDownloads(fDownloaded, libsWin, jarsList[6])) {
                    FileManager.resetFolder(folderLibsWin);
                    String aJar = FileManager.normalizeAbsolute(jarsList[6], false);
                    if (null == runTime.resourceListAsSikulixContentFromJar(aJar, "sikulixlibs/windows", folderLibsWin, null)) {
                        RunSetup.terminate("libswin content list could not be created", 999);
                    }
                    RunSetup.addonFileList[RunSetup.addonLibswindows] = new File(folderLibsWin, RunSetup.runTime.fpContent).getAbsolutePath();
                    RunSetup.addonFilePrefix[RunSetup.addonLibswindows] = libsWin;
                }
                downloadOK &= dlLibsWinOK;
            }
            if (forSystemMac || forAllSystems) {
                RunSetup.jarsList[7] = new File(workDir, libsMac + ".jar").getAbsolutePath();
                fDownloaded = RunSetup.downloadedAlready("mac", "Mac native libs", false);
                if (fDownloaded == null) {
                    fDownloaded = RunSetup.downloadJarFromMavenSx(libsMac, dlDirGeneric, libsMac);
                }
                downloadOK &= RunSetup.copyFromDownloads(fDownloaded, libsMac, jarsList[7]);
            }
        }
        if (getAPI) {
            sDownloaded = "sikulixapi";
            localJar = new File(workDir, localAPI).getAbsolutePath();
            fDownloaded = RunSetup.downloadedAlready("api", "Java API package", true);
            if (fDownloaded == null) {
                fDownloaded = RunSetup.downloadJarFromMavenSx("sikulixsetupAPI#forsetup", dlDir, sDownloaded);
            }
            boolean dlApiOK = RunSetup.copyFromDownloads(fDownloaded, sDownloaded, localJar);
            downloadOK &= dlApiOK;
        }
        if (getIDE) {
            sDownloaded = "sikulix";
            localJar = new File(workDir, localIDE).getAbsolutePath();
            fDownloaded = RunSetup.downloadedAlready("ide", "SikuliX IDE package", true);
            if (fDownloaded == null) {
                fDownloaded = RunSetup.downloadJarFromMavenSx("sikulixsetupIDE#forsetup", dlDir, sDownloaded);
            }
            downloadOK &= RunSetup.copyFromDownloads(fDownloaded, sDownloaded, localJar);
        }
        if (getJython) {
            sDownloaded = "Jython";
            targetJar = new File(workDir, localJython).getAbsolutePath();
            if (Settings.isJava6()) {
                RunSetup.logPlus(lvl, "running on Java 6: need to use Jython 2.5 - which is downloaded", new Object[0]);
                fDownloaded = RunSetup.downloadedAlready("python25", "Jython 2.5", false);
                if (fDownloaded == null) {
                    fDownloaded = RunSetup.downloadJarFromMaven(RunSetup.runTime.SikuliJythonMaven25, dlDirGeneric, sDownloaded);
                }
                downloadedFiles.replace(downloadJython, downloadJython25);
            } else if (RunSetup.popAsk("If you click YES, you will get Jython version 2.7.0 (recommended)\n... but in rare cases there might be issues with UTF-8/Unicode\nthat usually appear on startup when UTF-8 characters\nare present somewhere in the system environment\nIf you encounter such problems with Jython 2.7.0\nrun setup again and\nclick NO to get Jython a 2.5.4 version")) {
                sDownloadedName = new File(RunSetup.runTime.SikuliJythonMaven).getName();
                fDownloaded = RunSetup.downloadedAlready("python", "Jython 2.7", false);
                if (fDownloaded == null) {
                    fDownloaded = RunSetup.downloadJarFromMaven(RunSetup.runTime.SikuliJythonMaven, dlDirGeneric, sDownloaded);
                }
            } else {
                fDownloaded = RunSetup.downloadedAlready("python25", "Jython 2.5", false);
                if (fDownloaded == null) {
                    fDownloaded = RunSetup.downloadJarFromMaven(RunSetup.runTime.SikuliJythonMaven25, dlDirGeneric, sDownloaded);
                }
                downloadedFiles = downloadedFiles.replace(downloadJython, downloadJython25);
            }
            downloadOK &= RunSetup.copyFromDownloads(fDownloaded, sDownloaded, targetJar);
        }
        if (getJRuby) {
            sDownloaded = "JRuby";
            sDownloadedName = new File(RunSetup.runTime.SikuliJRubyMaven).getName();
            targetJar = new File(workDir, localJRuby).getAbsolutePath();
            fDownloaded = downloadsFound.get("ruby");
            if (fDownloaded == null) {
                fDownloaded = RunSetup.downloadJarFromMaven(RunSetup.runTime.SikuliJRubyMaven, dlDirGeneric, sDownloaded);
            }
            if ((downloadOK &= RunSetup.copyFromDownloads(fDownloaded, sDownloaded, targetJar)) && getJRubyAddOns) {
                sDownloaded = "JRuby AddOns";
                targetJar = new File(workDir, localJRubyAddOns).getAbsolutePath();
                fDownloaded = downloadsFound.get("rubyaddons");
                fDownloaded = RunSetup.download(RunSetup.runTime.downloadBaseDir, dlDirGeneric, downloadJRubyAddOns, sDownloaded);
                downloadOK &= RunSetup.copyFromDownloads(fDownloaded, sDownloaded, targetJar);
            }
        }
        if (downloadOK && withExtensions) {
            String[] dlApiOK = RunSetup.runTime.standardExtensions;
            int aJar = dlApiOK.length;
            for (int i = 0; i < aJar; ++i) {
                String item;
                sDownloaded = item = dlApiOK[i];
                sDownloadedName = item + ".jar";
                File fTargetJar = new File(RunSetup.runTime.fSikulixExtensions, sDownloadedName);
                if (!fTargetJar.exists()) {
                    fDownloaded = RunSetup.download(RunSetup.runTime.downloadBaseDir, RunSetup.runTime.fSikulixExtensions.getAbsolutePath(), sDownloadedName, item);
                    downloadOK &= fDownloaded != null;
                    continue;
                }
                RunSetup.logPlus(lvl, "request to download: %s ignored - already there", sDownloadedName);
            }
        }
        if (getTess) {
            // empty if block
        }
        if (!downloadedFiles.isEmpty()) {
            RunSetup.logPlus(lvl, "Download ended", new Object[0]);
            RunSetup.logPlus(lvl, "Downloads for selected options:\n" + downloadedFiles, new Object[0]);
        }
        if (!downloadOK) {
            msg = "Some of the downloads did not complete successfully.\nCheck the logfile for possible error causes.\n\nIf you think, setup's inline download is blocked somehow on\nyour system, you might download the appropriate raw packages manually\ninto the folder Downloads in the setup folder and run setup again.\n\nfiles to download (information is in the setup log file too)\n\n";
            for (String fnToDownload : downloadedFiles.split(" ")) {
                msg = msg + fnToDownload + "\n";
            }
            msg = msg + "\nBe aware: The raw packages are not useable without being processed by setup!\n\nFor other reasons, you might simply try to run setup again.";
            RunSetup.popError(msg);
            RunSetup.terminate("download not completed successfully", 1);
        }
        if (!getIDE && !getAPI) {
            RunSetup.logPlus(lvl, "Nothing else to do", new Object[0]);
            System.exit(0);
        }
        if (isLinux) {
            if (libsProvided || useLibsProvided) {
                shouldPackBundledLibs = false;
            }
            if (!shouldPackBundledLibs) {
                RunSetup.addonFileList[RunSetup.addonVision] = new File(folderLibsLux, "libVisionProxy.so").getAbsolutePath();
                RunSetup.addonFileList[RunSetup.addonGrabKey] = new File(folderLibsLux, "libJXGrabKey.so").getAbsolutePath();
                for (int i = 0; i < 2; ++i) {
                    if (!new File(addonFileList[i]).exists()) {
                        RunSetup.addonFileList[i] = null;
                        continue;
                    }
                    RunSetup.logPlus(lvl, "user provided lib: %s", addonFileList[i]);
                }
                String libPrefix = "sikulixlibs/linux/libs" + osarch;
                RunSetup.logPlus(lvl, "libs will be stored in jar at %s", libPrefix);
                RunSetup.addonFilePrefix[RunSetup.addonVision] = libPrefix;
                RunSetup.addonFilePrefix[RunSetup.addonGrabKey] = libPrefix;
            }
        }
        boolean success = true;
        FileManager.JarFileFilter libsFilter = new FileManager.JarFileFilter(){

            @Override
            public boolean accept(ZipEntry entry, String jarname) {
                if (!forAllSystems && (forSystemWin ? entry.getName().startsWith("sikulixlibs/mac") || entry.getName().startsWith("sikulixlibs/linux") || entry.getName().endsWith("sikulixfoldercontent") || entry.getName().startsWith("jxgrabkey") : (forSystemMac ? entry.getName().startsWith("sikulixlibs/windows") || entry.getName().startsWith("sikulixlibs/linux") || entry.getName().startsWith("com.melloware.jintellitype") || entry.getName().startsWith("jxgrabkey") : forSystemLux && (entry.getName().startsWith("sikulixlibs/windows") || entry.getName().startsWith("sikulixlibs/mac") || entry.getName().startsWith("com.melloware.jintellitype"))))) {
                    return false;
                }
                if (forSystemLux || forAllSystems) {
                    if (!shouldPackBundledLibs && entry.getName().contains("libVisionProxy.so") && entry.getName().contains("libs" + osarch)) {
                        if (new File(folderLibsLux, "libVisionProxy.so").exists()) {
                            RunSetup.logPlus(lvl, "Adding provided lib: %s (libs%s)", new Object[]{"libVisionProxy.so", osarch});
                            return false;
                        }
                        return true;
                    }
                    if (!shouldPackBundledLibs && entry.getName().contains("libJXGrabKey.so") && entry.getName().contains("libs" + osarch)) {
                        if (new File(folderLibsLux, "libJXGrabKey.so").exists()) {
                            RunSetup.logPlus(lvl, "Adding provided lib: %s (libs%s)", new Object[]{"libJXGrabKey.so", osarch});
                            return false;
                        }
                        return true;
                    }
                }
                return true;
            }
        };
        splash = RunSetup.showSplash("Now creating jars, application and commandfiles", "please wait - may take some seconds ...");
        if (getTess) {
            // empty if block
        }
        if (success && getAPI) {
            File fAPI = new File(workDir, localAPI);
            RunSetup.jarsList[1] = fAPI.getAbsolutePath();
            hasAPI = fAPI.exists();
            RunSetup.logPlus(lvl, "adding needed stuff to sikulixapi.jar", new Object[0]);
            localJar = new File(workDir, localAPI).getAbsolutePath();
            targetJar = new File(workDir, localTemp).getAbsolutePath();
            success &= FileManager.buildJar("#" + targetJar, jarsList, addonFileList, addonFilePrefix, libsFilter);
            FileManager.deleteFileOrFolder(new File(fDownloadsGeneric, localAPI));
            if (success &= RunSetup.handleTempAfter(targetJar, localJar)) {
                FileManager.xcopy(new File(localJar), new File(fDownloadsGeneric, localAPI));
            }
        }
        if (!getAPI || getTess) {
            // empty if block
        }
        if (success && getIDE) {
            RunSetup.logPlus(lvl, "adding needed stuff to sikulix.jar", new Object[0]);
            RunSetup.jarsList[0] = localJar = new File(workDir, localIDE).getAbsolutePath();
            RunSetup.jarsList[1] = null;
            if (getJython) {
                RunSetup.jarsList[3] = new File(workDir, localJython).getAbsolutePath();
            }
            if (getJRuby) {
                RunSetup.jarsList[4] = new File(workDir, localJRuby).getAbsolutePath();
                if (getJRubyAddOns) {
                    RunSetup.jarsList[5] = new File(workDir, localJRubyAddOns).getAbsolutePath();
                }
            }
            targetJar = new File(workDir, localTemp).getAbsolutePath();
            success &= FileManager.buildJar("#" + targetJar, jarsList, null, null, libsFilter);
            FileManager.deleteFileOrFolder(new File(fDownloadsGeneric, localIDE));
            if (success &= RunSetup.handleTempAfter(targetJar, localJar)) {
                FileManager.xcopy(new File(localJar), new File(fDownloadsGeneric, localIDE));
            }
            if (Settings.isMac()) {
                RunSetup.logPlus(lvl, "making the Mac application Sikulix.app", new Object[0]);
                String macAppContentOrg = "macapp";
                File fMacApp = new File(workDir, "SikuliX.app");
                if (null == runTime.extractResourcesToFolder(macAppContentOrg, fMacApp, null)) {
                    RunSetup.log(-1, "did not work", new Object[0]);
                } else {
                    File fMacAppjar = new File(fMacApp, "Contents/Java/" + localIDE);
                    new File(fMacApp, "run").setExecutable(true);
                    new File(fMacApp, "Contents/MacOS/JavaAppLauncher").setExecutable(true);
                    fMacAppjar.getParentFile().mkdirs();
                    FileManager.xcopy(new File(localJar), fMacAppjar);
                    FileManager.deleteFileOrFolder(new File(localJar));
                    localJarIDE = fMacAppjar;
                }
            }
        }
        if (success && getIDE) {
            RunSetup.logPlus(lvl, "processing commandfiles", new Object[0]);
            if (RunSetup.runTime.runningWindows) {
                runTime.extractResourceToFile("Commands/windows", runsikulix + ".cmd", fWorkDir);
            } else if (RunSetup.runTime.runningMac) {
                runTime.extractResourceToFile("Commands/mac", runsikulix, fWorkDir);
                new File(fWorkDir, runsikulix).setExecutable(true);
            } else if (isLinux) {
                runTime.extractResourceToFile("Commands/linux", runsikulix, fWorkDir);
                new File(fWorkDir, runsikulix).setExecutable(true);
                new File(fWorkDir, localIDE).setExecutable(true);
            }
        }
        RunSetup.closeSplash(splash);
        if (!success) {
            RunSetup.popError("Bad things happened trying to add native stuff to selected jars --- terminating!");
            RunSetup.terminate("Adding stuff to jars did not work");
        }
        if (!notests && runTime.isHeadless()) {
            RunSetup.log(lvl, "Running headless --- skipping tests", new Object[0]);
        }
        boolean runAPITest = false;
        if (getAPI && !notests && !runTime.isHeadless()) {
            String apiTest = hasOptions ? "testSetupSilent" : "testSetup";
            RunSetup.logPlus(lvl, "Trying to run functional test: JAVA-API %s", splashJava9);
            splash = RunSetup.showSplash("Trying to run functional test(s) - wait for the result popup", splashJava9 + " Java-API: org.sikuli.script.Sikulix.testSetup()");
            start += 2000L;
            RunSetup.closeSplash(splash);
            if (runTime.isJava9("setup API test - with ProcessRunner")) {
                String result = null;
                try {
                    result = ProcessRunner.run("work=" + workDir, "java", "-jar", "?sikulixapi", apiTest);
                    if (!result.startsWith("success")) {
                        RunSetup.log(-1, "setup API test: did not work\n%s", result);
                        throw new Exception("testSetup returned false");
                    }
                    RunSetup.log(lvl, "setup API test: success", new Object[0]);
                }
                catch (Exception e) {
                    RunSetup.terminate("ProcessRunner: " + e.getMessage());
                }
            } else {
                if (!runTime.addToClasspath(file.getAbsolutePath())) {
                    RunSetup.closeSplash(splash);
                    RunSetup.log(-1, "Java-API test: ", new Object[0]);
                    RunSetup.popError("Something serious happened! Sikuli not useable!\nCheck the error log at " + (logfile == null ? "printout" : logfile));
                    RunSetup.terminate("Functional test JAVA-API did not work", 1);
                }
                try {
                    RunSetup.log(lvl, "trying to run org.sikuli.script.Sikulix.testSetup()", new Object[0]);
                    Class<URLClassLoader> sysclass = URLClassLoader.class;
                    Class<?> SikuliCL = Class.forName("org.sikuli.script.Sikulix");
                    RunSetup.log(lvl, "class found: " + SikuliCL.toString(), new Object[0]);
                    Method method = SikuliCL.getDeclaredMethod(apiTest, new Class[0]);
                    RunSetup.log(lvl, "getMethod: " + method.toString(), new Object[0]);
                    method.setAccessible(true);
                    RunSetup.closeSplash(splash);
                    RunSetup.log(lvl, "invoke: " + method.toString(), new Object[0]);
                    Object ret = method.invoke(null, new Object[0]);
                    if (!((Boolean)ret).booleanValue()) {
                        throw new Exception("testSetup returned false");
                    }
                }
                catch (Exception ex) {
                    RunSetup.closeSplash(splash);
                    RunSetup.log(-1, ex.getMessage(), new Object[0]);
                    RunSetup.popError("Something serious happened! Sikuli not useable!\nCheck the error log at " + (logfile == null ? "printout" : logfile));
                    RunSetup.terminate("Functional test Java-API did not work", 1);
                }
                runAPITest = true;
            }
        }
        if (getIDE && !notests && !runTime.isHeadless()) {
            String[] testargs;
            success = true;
            if (!runAPITest) {
                runTime.makeFolders();
            }
            if (!runTime.isJava9("setup IDE test - addToClasspath() skipped") && !runTime.addToClasspath(localJarIDE.getAbsolutePath())) {
                RunSetup.closeSplash(splash);
                RunSetup.popError("Something serious happened! Sikuli not useable!\nCheck the error log at " + (logfile == null ? "printout" : logfile));
                RunSetup.terminate("Functional test IDE did not work", 1);
            }
            if (getJython) {
                String testMethod = hasOptions ? "print('testSetup: Jython: success')" : "Sikulix.testSetup('Jython Scripting')";
                RunSetup.logPlus(lvl, "Jython: Trying to run functional test: running script statements via SikuliScript", new Object[0]);
                splash = RunSetup.showSplash("Jython Scripting: Trying to run functional test - wait for the result popup", splashJava9 + "   Running script statements via SikuliScript");
                start += 2000L;
                try {
                    testargs = new String[]{"-testSetup", "jython", testMethod};
                    RunSetup.closeSplash(splash);
                    RunSetup.runScriptTest(testargs);
                    if (null == testargs[0]) {
                        throw new Exception("testSetup ran with problems");
                    }
                }
                catch (Exception ex) {
                    RunSetup.closeSplash(splash);
                    success &= false;
                    RunSetup.log(-1, ex.getMessage(), new Object[0]);
                    RunSetup.popError("Something serious happened! Sikuli not useable!\nCheck the error log at " + (logfile == null ? "printout" : logfile));
                    RunSetup.terminate("Functional test Jython did not work", 1);
                }
            }
            if (getJRuby && !runTime.isJava9("JRuby test skipped")) {
                String testMethod = hasOptions ? (runTime.isJava9(new String[0]) ? "print \\\"testSetup: JRuby: success\\\"" : "print \"testSetup: JRuby: success\"") : (runTime.isJava9(new String[0]) ? "Sikulix.testSetup(\\\"JRuby Scripting\\\")" : "Sikulix.testSetup(\"JRuby Scripting\")");
                RunSetup.logPlus(lvl, "JRuby: Trying to run functional test: running script statements via SikuliScript", new Object[0]);
                splash = RunSetup.showSplash("JRuby Scripting: Trying to run functional test - wait for the result popup", splashJava9 + "Running script statements via SikuliScript");
                start += 2000L;
                try {
                    testargs = new String[]{"-testSetup", "jruby", testMethod};
                    RunSetup.closeSplash(splash);
                    RunSetup.runScriptTest(testargs);
                    if (null == testargs[0]) {
                        throw new Exception("testSetup ran with problems");
                    }
                }
                catch (Exception ex) {
                    RunSetup.closeSplash(splash);
                    success &= false;
                    RunSetup.log(-1, "content of returned error's (%s) message:\n%s", ex, ex.getMessage());
                    RunSetup.popError("Something serious happened! Sikuli not useable!\nCheck the error log at " + (logfile == null ? "printout" : logfile));
                    RunSetup.terminate("Functional test JRuby did not work", 1);
                }
            }
            if (success && Settings.isMac()) {
                RunSetup.logPlus(lvl, "MacApp created - should be moved to /Applications", new Object[0]);
                splash = RunSetup.showSplash(splashJava9 + "MacApp created", "Should be moved to /Applications");
                start += 3000L;
                RunSetup.closeSplash(splash);
            }
        }
        if (!notests) {
            splash = RunSetup.showSplash(splashJava9 + "Setup seems to have ended successfully!", "Detailed information see: " + (logfile == null ? "printout" : logfile));
            start += 2000L;
            RunSetup.closeSplash(splash);
        }
        RunSetup.logPlus(lvl, "... SikuliX Setup seems to have ended successfully ;-)", new Object[0]);
        RunSetup.finalCleanup();
        System.exit(RunTime.testing ? 1 : 0);
    }

    private static String arrayToString(String[] args) {
        String ret = "";
        for (String s : args) {
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            ret = ret + s + " ";
        }
        return ret;
    }

    private static void finalCleanup() {
        int i;
        if (hasAPI) {
            RunSetup.jarsList[1] = null;
        }
        int n = i = getAPI ? 2 : 1;
        while (i < jarsList.length) {
            if (jarsList[i] != null) {
                new File(jarsList[i]).delete();
            }
            ++i;
        }
        FileManager.deleteFileOrFolder(fSetupStuff);
    }

    private static void runScriptTest(String[] testargs) {
        if (runTime.isJava9("setup run script test " + testargs[1] + " - with ProcessRunner")) {
            String result = null;
            try {
                String jarSikulix = "sikulix.jar";
                if (RunSetup.runTime.runningMac) {
                    jarSikulix = "SikuliX.app/Contents/Java/sikulix.jar";
                }
                if (!(result = ProcessRunner.run("work=" + workDir, "java", "-jar", jarSikulix, testargs[0], testargs[1], testargs[2])).startsWith("success")) {
                    RunSetup.log(-1, "setup run script test " + testargs[1] + ": did not work\n%s", result);
                    testargs[0] = null;
                }
                RunSetup.log(lvl, "setup run script test " + testargs[1] + ": success", new Object[0]);
            }
            catch (Exception e) {
                RunSetup.terminate("ProcessRunner: " + e.getMessage());
            }
        } else {
            try {
                Class<?> scriptRunner = Class.forName("org.sikuli.scriptrunner.ScriptingSupport");
                Method mGetApplication = scriptRunner.getDeclaredMethod("runscript", String[].class);
                mGetApplication.invoke(null, new Object[]{testargs});
            }
            catch (Exception ex) {
                RunSetup.log(lvl, "runScriptTest: error: %s", ex.getMessage());
            }
        }
    }

    private static String addSeps(String item) {
        if (Settings.isWindows()) {
            return item.replace("/", "\\");
        }
        return item;
    }

    private static void checkDownloads() {
        RunSetup.log(lvl, "checkDownloads: workDir:\n%s", fWorkDir);
        RunSetup.log(lvl, "checkDownloads: workDirDownloads:\n%s", fDownloadsObsolete);
        RunSetup.log(lvl, "checkDownloads: downloadsGeneric:\n%s", fDownloadsGeneric);
        RunSetup.log(lvl, "checkDownloads: downloadsGenericApp:\n%s", fDownloadsGenericApp);
        downloadsLookfor.put("api", "sikulixsetupAPI-");
        downloadsFound.put("api", null);
        downloadsLookfor.put("ide", "sikulixsetupIDE-");
        downloadsFound.put("ide", null);
        downloadsLookfor.put("win", "sikulixlibswin-");
        downloadsFound.put("win", null);
        downloadsLookfor.put("mac", "sikulixlibsmac-");
        downloadsFound.put("mac", null);
        downloadsLookfor.put("lux", "sikulixlibslux-");
        downloadsFound.put("lux", null);
        downloadsLookfor.put("python", new File(RunSetup.runTime.SikuliJythonMaven).getName());
        downloadsFound.put("python", null);
        downloadsLookfor.put("python25", new File(RunSetup.runTime.SikuliJythonMaven25).getName());
        downloadsFound.put("python25", null);
        downloadsLookfor.put("ruby", "jruby");
        downloadsFound.put("ruby", null);
        downloadsLookfor.put("rubyaddons", "NotYetDefined");
        downloadsFound.put("rubyaddons", null);
        downloadsLookfor.put("tess", "tesseract");
        downloadsFound.put("tess", null);
        String doubleFiles = "";
        for (File aFolder : new File[]{fWorkDir, fDownloadsObsolete, fDownloadsGenericApp, fDownloadsGeneric}) {
            File[] filesContained = aFolder.listFiles(new FilenameFilter(){
                List<String> valid = new ArrayList<String>(downloadsLookfor.values());

                @Override
                public boolean accept(File dir, String name) {
                    for (String sFile : this.valid) {
                        if (!name.startsWith(sFile)) continue;
                        return true;
                    }
                    return false;
                }
            });
            if (filesContained == null) continue;
            for (File aFile : filesContained) {
                for (String prefix : downloadsLookfor.keySet()) {
                    if (prefix.startsWith("python")) {
                        if (!downloadsLookfor.get(prefix).equals(aFile.getName())) continue;
                        downloadsFound.put(prefix, aFile);
                        continue;
                    }
                    if (!aFile.getName().startsWith(downloadsLookfor.get(prefix))) continue;
                    if (null == downloadsFound.get(prefix)) {
                        downloadsFound.put(prefix, aFile);
                        continue;
                    }
                    if (!aFile.getParentFile().equals(downloadsFound.get(prefix).getParentFile())) continue;
                    doubleFiles = doubleFiles + aFile + "\n";
                }
            }
        }
        for (String prefix : downloadsFound.keySet()) {
            File fpDownloaded = downloadsFound.get(prefix);
            if (fpDownloaded != null) {
                RunSetup.log(lvl, "checkDownloads: found: %s:\n%s", prefix, fpDownloaded);
                continue;
            }
            RunSetup.log(lvl, "checkDownloads: not found: %s", prefix);
        }
        if (!doubleFiles.isEmpty()) {
            RunSetup.popError("The following files are double or even more often found in the\nrespective folders setup checks before downloading new artefacts:\n" + doubleFiles + "Please check and take care, that only one version of these files is found.\nCorrect the problem and try again");
            RunSetup.terminate("double downloaded files");
        }
    }

    private static boolean createSetupFolder(File fTargetDir) {
        String projectDir = RunSetup.runTime.fSxProject.getAbsolutePath();
        boolean success = true;
        File fSetup = RunSetup.getProjectJarFile(projectDir, "Setup", "sikulixsetup", "-forsetup.jar");
        success &= fSetup != null;
        File fIDEPlus = RunSetup.getProjectJarFile(projectDir, "SetupIDE", "sikulixsetupIDE", "-forsetup.jar");
        success &= fIDEPlus != null;
        File fAPIPlus = RunSetup.getProjectJarFile(projectDir, "SetupAPI", "sikulixsetupAPI", "-forsetup.jar");
        success &= fAPIPlus != null;
        File fJythonJar = new File(RunSetup.runTime.SikuliJython);
        if (!noSetup && !fJythonJar.exists()) {
            RunSetup.log(lvl, "createSetupFolder: missing: " + fJythonJar.getAbsolutePath(), new Object[0]);
            success = false;
        }
        File fJythonJar25 = new File(RunSetup.runTime.SikuliJython25);
        if (!noSetup && !fJythonJar25.exists()) {
            RunSetup.log(lvl, "createSetupFolder: missing: " + fJythonJar.getAbsolutePath(), new Object[0]);
            fJythonJar25 = null;
        }
        File fJrubyJar = new File(RunSetup.runTime.SikuliJRuby);
        if (!noSetup && !fJrubyJar.exists()) {
            RunSetup.log(lvl, "createSetupFolder: missing " + fJrubyJar.getAbsolutePath(), new Object[0]);
            success = false;
        }
        if (success) {
            FileManager.resetFolder(fDownloadsGenericApp);
            if (success &= FileManager.xcopy(fSetup, new File(fTargetDir, localSetup))) {
                for (String sFile : fTargetDir.list()) {
                    if (!sFile.contains("sikulixsetup") || !sFile.contains("-project") || sFile.contains(localSetup)) continue;
                    FileManager.deleteFileOrFolder(new File(fTargetDir, sFile));
                }
            }
            success &= FileManager.xcopy(fIDEPlus, new File(fDownloadsGenericApp, downloadIDE));
            success &= FileManager.xcopy(fAPIPlus, new File(fDownloadsGenericApp, downloadAPI));
            if (!noSetup) {
                success &= FileManager.xcopy(fJythonJar, new File(fDownloadsGeneric, downloadJython));
                if (fJythonJar25 != null) {
                    FileManager.xcopy(fJythonJar25, new File(fDownloadsGeneric, downloadJython25));
                }
                success &= FileManager.xcopy(fJrubyJar, new File(fDownloadsGeneric, downloadJRuby));
            }
            String jrubyAddons = "sikulixjrubyaddons-" + RunSetup.runTime.SikuliProjectVersion + "-plain.jar";
            File file = new File(projectDir, "JRubyAddOns/target/" + jrubyAddons);
        }
        return success;
    }

    private static File getProjectJarFile(String project, String jarFileDir, String jarFilePre, String jarFileSuf) {
        String jarFileName = RunSetup.getProjectJarFileName(jarFilePre, jarFileSuf);
        File fJarFile = new File(project, jarFileDir + "/target/" + jarFileName);
        if (!fJarFile.exists()) {
            RunSetup.log(-1, "createSetupFolder: missing: " + fJarFile.getAbsolutePath(), new Object[0]);
            return null;
        }
        return fJarFile;
    }

    private static String getProjectJarFileName(String jarFilePre, String jarFileSuf) {
        return String.format("%s-%s%s", jarFilePre, RunSetup.runTime.SikuliProjectVersion, jarFileSuf);
    }

    private static boolean handleTempAfter(String temp, String target) {
        boolean success = true;
        RunSetup.logPlus(lvl, "renaming sikulixtemp.jar to target jar: %s", new File(target).getName());
        FileManager.deleteFileOrFolder("#" + target);
        if ((success &= !new File(target).exists()) && !(success &= new File(temp).renameTo(new File(target)))) {
            RunSetup.logPlus(lvl, "rename did not work --- trying copy", new Object[0]);
            try {
                FileManager.xcopy(new File(temp).getAbsolutePath(), target);
                success = new File(target).exists();
                if (success) {
                    FileManager.deleteFileOrFolder(new File(temp).getAbsolutePath());
                    success = !new File(temp).exists();
                }
            }
            catch (IOException ex) {
                success &= false;
            }
            if (!success) {
                RunSetup.logPlus(-1, "did not work", new Object[0]);
                RunSetup.terminate("");
            }
        }
        return success;
    }

    private static boolean getProxy(String pn, String pp) {
        if (!pn.isEmpty()) {
            Pattern p = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
            if (p.matcher(pn).matches()) {
                Settings.proxyIP = pn;
            } else {
                Settings.proxyName = pn;
            }
            String msgp = String.format("Requested to use this Proxy: %s (%s)", pn, pp);
            RunSetup.logPlus(lvl, msgp, new Object[0]);
            if (pp.isEmpty()) {
                RunSetup.popError(String.format("Proxy specification invalid: %s (%s)", pn, pp));
                RunSetup.logPlus(-1, "Terminating --- Proxy invalid", new Object[0]);
                return false;
            }
            if (!RunSetup.popAsk(msgp)) {
                RunSetup.logPlus(-1, "Terminating --- User did not accept Proxy: %s %s", pn, pp);
                return false;
            }
            Settings.proxyPort = pp;
            return true;
        }
        return false;
    }

    protected static void helpOption(int option) {
        String om = "";
        String m = "\n-------------------- Some Information on this option, that might help to decide, wether to select it ------------------";
        switch (option) {
            case 1: {
                om = "Package 1: You get SikuliX (sikulix.jar) which supports all usages of Sikuli";
                m = m + "\nIt is recommended for people new to Sikuli to get a feeling about the features";
                m = m + "\n - and those who want to develop Sikuli scripts with the Sikuli IDE";
                m = m + "\n - and those who want to run Sikuli scripts from commandline.";
                m = m + "\nDirectly supported scripting languages are Jython and JRuby (you might choose one of them or even both)";
                m = m + "\n\nFor those who know ;-) additionally you can ...";
                m = m + "\n- develop Java programs with Sikuli features in IDE's like Eclipse, NetBeans, ...";
                m = m + "\n- develop in any Java aware scripting language adding Sikuli features in IDE's like Eclipse, NetBeans, ...";
                m = m + "\n\nSpecial INFO for Jython, JRuby and Java developement";
                m = m + "\nIf you want to use standalone Jython/JRuby or want to develop in Java in parallel,";
                m = m + "\nyou should select Package 2 additionally (Option 2)";
                m = m + "\nIn these cases, Package 1 (SikuliX) can be used for image management and for small tests/trials.";
                if (Settings.isWindows()) {
                    m = m + "\n\nSpecial info for Windows systems:";
                    m = m + "\nThe generated jars can be used out of the box with Java 32-Bit and Java 64-Bit as well.";
                    m = m + "\nThe Java version is detected at runtime and the native support is switched accordingly.";
                }
                if (!Settings.isMac()) break;
                m = m + "\n\nSpecial info for Mac systems:";
                m = m + "\nYou will have a SikuliX.app in the setup working folder, that runs the IDE.";
                m = m + "\nRecommendation: move it to the Applications folder.";
                m = m + "\nIf you need to run stuff from commandline: use runsikulix";
                break;
            }
            case 2: {
                om = "Package 2: To support developement in Java or any Java aware scripting language. you get sikulixapi.jar.\nYou might want Package 1 (SikuliX) additionally to use the IDE for managing the images or some trials.";
                m = m + "\nThe content of this package is stripped down to what is needed to develop in Java or any Java aware scripting language \n(no IDE, no bundled script run support for Jython/JRuby)";
                m = m + "\n\nHence this package is not runnable and must be in the class path to use it for developement or at runtime";
                m = m + "\n\nSpecial info for usage with Jython/JRuby: It contains the Sikuli Jython/JRuby API ...\n... and adds itself to Jython/JRuby path at runtime\n... and exports the Sikuli Jython/JRuby modules to the folder Libs at runtime\nthat helps to setup the auto-complete in IDE's like NetBeans, Eclipse ...";
                if (!Settings.isWindows()) break;
                m = m + "\n\nSpecial info for Windows systems:";
                m = m + "\nThe generated jars can be used out of the box with Java 32-Bit and Java 64-Bit as well.";
                m = m + "\nThe Java version is detected at runtime and the native support is switched accordingly.";
                break;
            }
            case 3: {
                om = "Tesseract support for language english is bundled";
                m = "";
                break;
            }
            default: {
                m = "";
                om = "Not available";
            }
        }
        RunSetup.popInfo("asking for option " + option + ": " + om + "\n" + m);
    }

    private static String packMessage(String msg) {
        msg = msg.replace("\n\n", "\n");
        if ((msg = msg.replace("\n\n", "\n")).startsWith("\n")) {
            msg = msg.substring(1);
        }
        if (msg.endsWith("\n")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        return "--------------------\n" + msg + "\n--------------------";
    }

    private static void popError(String msg) {
        RunSetup.logPlus(3, "\npopError: " + RunSetup.packMessage(msg), new Object[0]);
        if (!hasOptions) {
            JOptionPane.showMessageDialog(null, msg, "SikuliX-Setup: having problems ...", 0);
        }
    }

    private static void popInfo(String msg) {
        RunSetup.logPlus(3, "\npopInfo: " + RunSetup.packMessage(msg), new Object[0]);
        if (!hasOptions) {
            JOptionPane.showMessageDialog(null, msg, "SikuliX-Setup: info ...", -1);
        }
    }

    private static boolean popAsk(String msg) {
        RunSetup.logPlus(3, "\npopAsk: " + RunSetup.packMessage(msg), new Object[0]);
        if (hasOptions) {
            return true;
        }
        int ret = JOptionPane.showConfirmDialog(null, msg, "SikuliX-Setup: question ...", 0);
        return ret != -1 && ret != 1;
    }

    private static JFrame showSplash(String title, String msg) {
        if (hasOptions | notests) {
            return null;
        }
        start = new Date().getTime();
        return new SplashFrame(new String[]{"splash", "# " + title, "#... " + msg});
    }

    private static void closeSplash(JFrame splash) {
        if (splash == null) {
            return;
        }
        long elapsed = new Date().getTime() - start;
        if (elapsed < 3000L) {
            try {
                Thread.sleep(3000L - elapsed);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        splash.dispose();
    }

    private static File download(String sDir, String tDir, String item, String itemName) {
        String dlSource;
        if (item == null) {
            String[] items = sDir.split("/");
            item = items[items.length - 1];
            dlSource = sDir;
        } else {
            if (!sDir.endsWith("/")) {
                sDir = sDir + "/";
            }
            dlSource = sDir + item;
        }
        if (itemName == null) {
            itemName = item;
        }
        String fname = null;
        if (hasOptions) {
            RunSetup.logPlus(lvl, "SilentSetup: Downloading: %s", itemName);
            fname = FileManager.downloadURL(dlSource, tDir, null);
        } else {
            SplashFrame progress = new SplashFrame("download");
            fname = FileManager.downloadURL(dlSource, tDir, progress);
            progress.dispose();
        }
        if (null == fname) {
            return null;
        }
        return new File(fname);
    }

    private static File downloadedAlready(String item, String itemName, boolean isVersioned) {
        File targetFolder = isVersioned ? fDownloadsGenericApp : fDownloadsGeneric;
        File artefact = downloadsFound.get(item);
        if (artefact != null) {
            File target = new File(targetFolder, artefact.getName());
            if ((artefact = RunSetup.downloadedAlreadyAsk(artefact, itemName)) != null && !hasOptions) {
                if (artefact.getParentFile().equals(isVersioned ? fDownloadsGenericApp : fDownloadsGeneric)) {
                    return artefact;
                }
                if (FileManager.xcopy(artefact, target)) {
                    artefact.delete();
                    artefact = target;
                }
            }
        }
        return artefact;
    }

    private static File downloadedAlreadyAsk(File artefact, String itemName) {
        if (artefact.exists() && RunSetup.popAsk("You have for " + itemName + "\n" + artefact.getAbsolutePath() + "\nClick YES, if you want to use this for setup processing\n\n... or click NO, to ignore it and download a fresh copy")) {
            return artefact;
        }
        return null;
    }

    private static boolean copyFromDownloads(File artefact, String item, String jar) {
        if (artefact == null) {
            return false;
        }
        try {
            FileManager.xcopy(artefact.getAbsolutePath(), jar);
        }
        catch (IOException ex) {
            RunSetup.log(-1, "Unable to copy from Downloads: %s\n%s", artefact, ex.getMessage());
            return false;
        }
        RunSetup.logPlus(lvl, "Copied from Downloads: " + item, new Object[0]);
        return true;
    }

    private static String getMavenJarPath(String givenItem) {
        String mPath;
        String mJar = "";
        String itemSuffix = "";
        String item = givenItem;
        if (item.contains("#")) {
            String[] parts = item.split("#");
            item = parts[0];
            itemSuffix = "-" + parts[1];
        }
        String usedVersion = version;
        if (runTime.isVersionRelease() || useReleaseVersion.contains(item)) {
            if (useReleaseVersion.contains(item)) {
                usedVersion = releaseVersion;
            }
            mPath = String.format("%s%s/%s/", sikulixMavenGroup, item, usedVersion);
            mJar = String.format("%s-%s%s.jar", item, usedVersion, itemSuffix);
        } else {
            Matcher m;
            String dlMavenSnapshotPath = version + "-SNAPSHOT";
            String dlMavenSnapshotXML = "maven-metadata.xml";
            String dlMavenSnapshotPrefix = String.format("%s%s/%s/", sikulixMavenGroup, item, dlMavenSnapshotPath);
            String timeStamp = "";
            String buildNumber = "";
            mPath = RunSetup.runTime.dlMavenSnapshot + dlMavenSnapshotPrefix;
            String xml = mPath + dlMavenSnapshotXML;
            String xmlContent = FileManager.downloadURLtoString(xml);
            if (xmlContent != null && !xmlContent.isEmpty() && (m = Pattern.compile("<timestamp>(.*?)</timestamp>").matcher(xmlContent)).find()) {
                timeStamp = m.group(1);
                m = Pattern.compile("<buildNumber>(.*?)</buildNumber>").matcher(xmlContent);
                if (m.find()) {
                    buildNumber = m.group(1);
                }
            }
            if (!timeStamp.isEmpty() && !buildNumber.isEmpty()) {
                mJar = String.format("%s-%s-%s-%s%s.jar", item, version, timeStamp, buildNumber, itemSuffix);
                RunSetup.log(lvl, "getMavenJar: %s", mJar);
            } else {
                if (!bequiet) {
                    RunSetup.log(-1, "Maven download: could not get timestamp nor buildnumber for %s from:\n%s\nwith content:\n%s", givenItem, xml, xmlContent);
                }
                return null;
            }
        }
        return mPath + mJar;
    }

    private static String getMavenJarName(String item) {
        String fpJar = RunSetup.getMavenJarPath(item);
        if (fpJar == null) {
            return null;
        }
        return new File(fpJar).getName();
    }

    private static File downloadJarFromMavenSx(String item, String targetDir, String itemName) {
        String fpJar = RunSetup.getMavenJarPath(item);
        if (fpJar == null) {
            return null;
        }
        if (runTime.isVersionRelease() || useReleaseVersion.contains(item)) {
            return RunSetup.downloadJarFromMaven(fpJar, targetDir, itemName);
        }
        return RunSetup.download(fpJar, targetDir, null, itemName);
    }

    private static File downloadJarFromMaven(String item, String target, String itemName) {
        if (item.startsWith("http")) {
            return RunSetup.download(item, target, null, itemName);
        }
        if (useLocalMavenRepo) {
            try {
                URL theFile = new URL("file", null, RunSetup.runTime.SikuliLocalRepo + item);
                return RunSetup.download(theFile.toExternalForm(), target, null, itemName);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return RunSetup.download(RunSetup.runTime.dlMavenRelease + item, target, null, itemName);
    }

    private static void userTerminated(String msg) {
        if (!msg.isEmpty()) {
            RunSetup.logPlus(lvl, msg, new Object[0]);
        }
        RunSetup.logPlus(lvl, "User requested termination.", new Object[0]);
        System.exit(0);
    }

    private static void prepTerminate(String msg) {
        RunSetup.logPlus(-1, msg, new Object[0]);
        RunSetup.logPlus(-1, "... terminated abnormally :-(", new Object[0]);
        RunSetup.popError("Something serious happened! Sikuli not useable!\nCheck the error log at " + (logfile == null ? "printout" : logfile));
        RunSetup.finalCleanup();
    }

    private static void terminate(String msg) {
        RunSetup.prepTerminate(msg);
        System.exit(0);
    }

    private static void terminate(String msg, int ret) {
        RunSetup.prepTerminate(msg);
        System.exit(ret);
    }

    static {
        noSetup = false;
        localAPI = "sikulixapi.jar";
        localIDE = "sikulix.jar";
        localTess = "sikulixtessdata.jar";
        localJython = "sikulixjython.jar";
        localJRuby = "sikulixjruby.jar";
        localJRubyAddOns = "sikulixjrubyaddons.jar";
        runsikulix = "runsikulix";
        getRServer = false;
        forAllSystems = false;
        getTess = false;
        getJRuby = false;
        getJRubyAddOns = false;
        hasOptions = false;
        options = new ArrayList<String>();
        splash = null;
        me = "RunSetup";
        lvl = 2;
        shouldPackBundledLibs = true;
        logToFile = true;
        forSystemWin = false;
        forSystemMac = false;
        forSystemLux = false;
        libsMac = "sikulixlibsmac";
        libsWin = "sikulixlibswin";
        libsLux = "sikulixlibslux";
        linuxDistro = "*** testing Linux ***";
        isLinux = false;
        libsProvided = false;
        addonFileList = new String[]{null, null, null, null, null};
        addonFilePrefix = new String[]{null, null, null, null, null};
        addonVision = 0;
        addonGrabKey = 1;
        addonLibswindows = 2;
        addonFolderLib = 3;
        notests = false;
        clean = false;
        useLibsProvided = false;
        runningWithProject = false;
        shouldBuildVision = false;
        bequiet = false;
        sikulixMavenGroup = "com/sikulix/";
        withExtensions = false;
        downloadsLookfor = new HashMap<String, String>();
        downloadsFound = new HashMap<String, File>();
        fSetupStuff = null;
        hasAPI = true;
        jarsList = new String[]{null, null, null, null, null, null, null, null, null};
        testingMaven = false;
        useLocalMavenRepo = false;
        useReleaseVersion = "sikulixlibsmac sikulixlibswin sikulixlibslux";
        releaseVersion = "1.1.1";
    }
}

