/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.ImagePath;
import org.sikuli.script.RunTime;
import org.sikuli.script.Sikulix;
import org.sikuli.script.SikulixForJython;
import org.sikuli.util.JLangHelperInterface;

public class JythonHelper
implements JLangHelperInterface {
    static RunTime runTime = RunTime.get();
    private static final String me = "JythonSupport: ";
    private static int lvl = 3;
    static JythonHelper instance = null;
    static Object interpreter = null;
    List<String> sysPath = new ArrayList<String>();
    List<String> sysArgv = new ArrayList<String>();
    int nPathAdded = 0;
    int nPathSaved = -1;
    static Class[] nc = new Class[0];
    static Class[] nc1 = new Class[1];
    static Class cInterpreter = null;
    static Class cPyException = null;
    static Class cList = null;
    static Class cPy = null;
    static Class cPyFunction = null;
    static Class cPyMethod = null;
    static Class cPyInstance = null;
    static Class cPyObject = null;
    static Class cPyString = null;
    static Method mLen;
    static Method mGet;
    static Method mSet;
    static Method mAdd;
    static Method mRemove;
    static Method mClear;
    static Method mGetSystemState;
    static Method mExec;
    static Method mExecfile;
    static Field PI_path;
    private long lastRun = 0L;
    private List<File> importedScripts = new ArrayList<File>();
    String name = "";

    public void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private void logp(String message, Object ... args) {
        Debug.logx(-3, message, args);
    }

    private void logp(int level, String message, Object ... args) {
        if (level <= Debug.getDebugLevel()) {
            this.logp(message, args);
        }
    }

    public void terminate(int retVal, String msg, Object ... args) {
        runTime.terminate(retVal, me + msg, args);
    }

    private JythonHelper() {
    }

    public static JythonHelper get() {
        if (instance == null) {
            instance = new JythonHelper();
            instance.log(lvl, "init: starting", new Object[0]);
            try {
                cInterpreter = Class.forName("org.python.util.PythonInterpreter");
            }
            catch (Exception ex) {
                String sJython = new File(JythonHelper.runTime.SikuliJython).getName();
                File fJython = new File(JythonHelper.runTime.fSikulixDownloadsGeneric, sJython);
                if (fJython.exists()) {
                    runTime.addToClasspath(fJython.getAbsolutePath(), "JythonHelper.get");
                }
                cInterpreter = null;
            }
            try {
                cInterpreter = Class.forName("org.python.util.PythonInterpreter");
                mGetSystemState = cInterpreter.getMethod("getSystemState", nc);
                mExec = cInterpreter.getMethod("exec", String.class);
                mExecfile = cInterpreter.getMethod("execfile", String.class);
                Constructor PI_new = cInterpreter.getConstructor(nc);
                interpreter = PI_new.newInstance(null);
                cPyException = Class.forName("org.python.core.PyException");
                cList = Class.forName("org.python.core.PyList");
                cPy = Class.forName("org.python.core.Py");
                cPyFunction = Class.forName("org.python.core.PyFunction");
                cPyMethod = Class.forName("org.python.core.PyMethod");
                cPyInstance = Class.forName("org.python.core.PyInstance");
                cPyObject = Class.forName("org.python.core.PyObject");
                cPyString = Class.forName("org.python.core.PyString");
                mLen = cList.getMethod("__len__", nc);
                mClear = cList.getMethod("clear", nc);
                mGet = cList.getMethod("get", Integer.TYPE);
                mSet = cList.getMethod("set", Integer.TYPE, Object.class);
                mAdd = cList.getMethod("add", Object.class);
                mRemove = cList.getMethod("remove", Integer.TYPE);
            }
            catch (Exception ex) {
                cInterpreter = null;
            }
            instance.log(lvl, "init: success", new Object[0]);
        }
        if (cInterpreter == null) {
            runTime.terminate(1, "JythonHelper: no Jython available", new Object[0]);
        }
        JythonHelper.runTime.isJythonReady = true;
        return instance;
    }

    private void noOp() {
    }

    public boolean exec(String code) {
        try {
            mExec.invoke(interpreter, code);
        }
        catch (Exception ex) {
            PyException pex = new PyException(ex.getCause());
            if (pex.isTypeExit() < 0) {
                this.log(-1, "exec: returns:\n%s", ex.getCause());
            }
            return false;
        }
        return true;
    }

    public int execfile(String fpScript) {
        int retval;
        block2: {
            retval = -999;
            try {
                mExecfile.invoke(interpreter, fpScript);
            }
            catch (Exception ex) {
                PyException pex = new PyException(ex.getCause());
                retval = pex.isTypeExit();
                if (retval >= 0) break block2;
                this.log(-1, "execFile: returns:\n%s", ex.getCause());
            }
        }
        return retval;
    }

    public boolean checkCallback(Object[] args) {
        PyInstance inst = new PyInstance(args[0]);
        String mName = (String)args[1];
        Object method = inst.__getattr__(mName);
        if (method == null || !method.getClass().getName().contains("PyMethod")) {
            this.log(-100, "checkCallback: Object: %s, Method not found: %s", inst, mName);
            return false;
        }
        return true;
    }

    public boolean runLoggerCallback(Object[] args) {
        PyInstance inst = new PyInstance(args[0]);
        String mName = (String)args[1];
        String msg = (String)args[2];
        Object method = inst.__getattr__(mName);
        if (method == null || !method.getClass().getName().contains("PyMethod")) {
            this.log(-100, "runLoggerCallback: Object: %s, Method not found: %s", inst, mName);
            return false;
        }
        try {
            PyString pmsg = new PyString(msg);
            inst.invoke(mName, pmsg.get());
        }
        catch (Exception ex) {
            this.log(-100, "runLoggerCallback: invoke: %s", ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean runObserveCallback(Object[] args) {
        PyFunction func = new PyFunction(args[0]);
        boolean success = true;
        try {
            func.__call__(new Py().java2py(args[1]));
        }
        catch (Exception ex) {
            if (!func.toString().contains("<lambda>")) {
                this.log(-1, "runObserveCallback: jython invoke: %s", ex.getMessage());
                return false;
            }
            success = false;
        }
        if (success) {
            return true;
        }
        try {
            func.__call__();
        }
        catch (Exception ex) {
            this.log(-1, "runObserveCallback: jython invoke <lambda>: %s", ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean runCallback(Object[] args) {
        PyInstance inst = (PyInstance)args[0];
        String mName = (String)args[1];
        Object method = inst.__getattr__(mName);
        if (method == null || !method.getClass().getName().contains("PyMethod")) {
            this.log(-1, "runCallback: Object: %s, Method not found: %s", inst, mName);
            return false;
        }
        try {
            PyString pmsg = new PyString("not yet supported");
            inst.invoke(mName, pmsg.get());
        }
        catch (Exception ex) {
            this.log(-1, "runCallback: invoke: %s", ex.getMessage());
            return false;
        }
        return true;
    }

    public static JythonHelper set(Object ip) {
        JythonHelper.get();
        interpreter = ip;
        return instance;
    }

    public boolean prepareRobot() {
        if (runTime.isRunningFromJar()) {
            File fLibRobot = new File(JythonHelper.runTime.fSikulixLib, "robot");
            if (!fLibRobot.exists()) {
                this.log(-1, "prepareRobot: not available: %s", fLibRobot);
                Sikulix.terminate(1);
            }
            if (!this.hasSysPath(JythonHelper.runTime.fSikulixLib.getAbsolutePath())) {
                this.insertSysPath(JythonHelper.runTime.fSikulixLib);
            }
        }
        if (!this.hasSysPath(new File(Settings.BundlePath).getParent())) {
            this.appendSysPath(new File(Settings.BundlePath).getParent());
        }
        this.exec("import robot");
        return true;
    }

    public int runJar(String fpJarOrFolder) {
        return this.runJar(fpJarOrFolder, "");
    }

    public int runJar(String fpJarOrFolder, String imagePath) {
        SikulixForJython.get();
        String fpJar = this.load(fpJarOrFolder, true);
        ImagePath.addJar(fpJar, imagePath);
        String scriptName = new File(fpJar).getName().replace("_sikuli.jar", "");
        if (this.exec("try: reload(" + scriptName + ")\nexcept: import " + scriptName)) {
            return 0;
        }
        return -1;
    }

    public String load(String fpJarOrFolder) {
        return this.load(fpJarOrFolder, false);
    }

    public String load(String fpJarOrFolder, boolean scriptOnly) {
        this.log(lvl, "load: to be loaded:\n%s", fpJarOrFolder);
        if (!fpJarOrFolder.endsWith(".jar")) {
            fpJarOrFolder = fpJarOrFolder + ".jar";
        }
        File fJar = new File(FileManager.normalizeAbsolute(fpJarOrFolder, false));
        String fpBundle = ImagePath.getBundlePath();
        if (!(fJar.exists() || (fJar = new File(fpBundle, fpJarOrFolder)).exists() || (fJar = new File(new File(fpBundle).getParentFile(), fpJarOrFolder)).exists() || (fJar = new File(JythonHelper.runTime.fSikulixExtensions, fpJarOrFolder)).exists() || (fJar = new File(JythonHelper.runTime.fSikulixLib, fpJarOrFolder)).exists())) {
            fJar = null;
        }
        if (fJar != null) {
            if (!scriptOnly && !runTime.addToClasspath(fJar.getPath(), "JythonHelper.load")) {
                this.log(-1, "load: not possible: %s", fJar);
            }
        } else {
            this.log(-1, "load: not found: %s", fJar);
            return null;
        }
        if (!this.hasSysPath(fJar.getPath())) {
            this.insertSysPath(fJar);
        }
        return fJar.getAbsolutePath();
    }

    public void reloadImported() {
        if (this.lastRun > 0L) {
            for (File fMod : this.importedScripts) {
                this.name = this.getPyName(fMod);
                if (new File(fMod, this.name + ".py").lastModified() <= this.lastRun) continue;
                this.log(lvl, "reload: %s", fMod);
                JythonHelper.get().exec("reload(" + this.name + ")");
            }
        }
        this.lastRun = new Date().getTime();
    }

    private String getPyName(File fMod) {
        String ending = ".sikuli";
        String name = fMod.getName();
        if (name.endsWith(ending)) {
            name = name.substring(0, name.length() - ending.length());
        }
        return name;
    }

    public String findModule(String modName, Object packPath, Object sysPath) {
        if (modName.endsWith(".*")) {
            this.log(lvl + 1, "findModule: %s", modName);
            return null;
        }
        if (packPath != null) {
            this.log(lvl + 1, "findModule: in pack: %s (%s)", modName, packPath);
            return null;
        }
        int nDot = modName.lastIndexOf(".");
        String modNameFull = modName;
        if (nDot > -1) {
            modName = modName.substring(nDot + 1);
        }
        String fpBundle = ImagePath.getBundlePath();
        File fParentBundle = null;
        File fModule = null;
        if (fpBundle != null) {
            fParentBundle = new File(fpBundle).getParentFile();
            fModule = this.existsModule(modName, fParentBundle);
        }
        if (fModule == null && (fModule = this.existsSysPathModule(modName)) == null) {
            return null;
        }
        this.log(lvl + 1, "findModule: final: %s [%s]", fModule.getName(), fModule.getParent());
        if (fModule.getName().endsWith(".sikuli")) {
            this.importedScripts.add(fModule);
            return fModule.getAbsolutePath();
        }
        return null;
    }

    public String loadModulePrepare(String modName, String modPath) {
        this.log(lvl + 1, "loadModulePrepare: %s in %s", modName, modPath);
        int nDot = modName.lastIndexOf(".");
        if (nDot > -1) {
            modName = modName.substring(nDot + 1);
        }
        this.addSysPath(modPath);
        if (modPath.endsWith(".sikuli")) {
            ImagePath.add(modPath);
        }
        return modName;
    }

    private File existsModule(String mName, File fFolder) {
        if (mName.endsWith(".sikuli") || mName.endsWith(".py")) {
            return null;
        }
        File fSikuli = new File(fFolder, mName + ".sikuli");
        if (fSikuli.exists()) {
            return fSikuli;
        }
        File fPython = new File(fFolder, mName + ".py");
        if (fPython.exists()) {
            return fPython;
        }
        return null;
    }

    public void getSysArgv() {
        this.sysArgv = new ArrayList<String>();
        if (null == cInterpreter) {
            this.sysArgv = null;
            return;
        }
        try {
            Object aState = mGetSystemState.invoke(interpreter, (Object[])null);
            Field fArgv = aState.getClass().getField("argv");
            Object pyArgv = fArgv.get(aState);
            Integer argvLen = (Integer)mLen.invoke(pyArgv, (Object[])null);
            for (int i = 0; i < argvLen; ++i) {
                String entry = (String)mGet.invoke(pyArgv, i);
                this.log(lvl + 1, "sys.path[%2d] = %s", i, entry);
                this.sysArgv.add(entry);
            }
        }
        catch (Exception ex) {
            this.sysArgv = null;
        }
    }

    public void setSysArgv(String[] args) {
        if (null == cInterpreter || null == this.sysArgv) {
            return;
        }
        try {
            Object aState = mGetSystemState.invoke(interpreter, (Object[])null);
            Field fArgv = aState.getClass().getField("argv");
            Object pyArgv = fArgv.get(aState);
            mClear.invoke(pyArgv, null);
            for (String arg : args) {
                mAdd.invoke(pyArgv, arg);
            }
        }
        catch (Exception ex) {
            this.sysArgv = null;
        }
    }

    public void getSysPath() {
        this.sysPath = new ArrayList<String>();
        if (null == cInterpreter) {
            this.sysPath = null;
            return;
        }
        try {
            Object aState = mGetSystemState.invoke(interpreter, (Object[])null);
            Field fPath = aState.getClass().getField("path");
            Object pyPath = fPath.get(aState);
            Integer pathLen = (Integer)mLen.invoke(pyPath, (Object[])null);
            for (int i = 0; i < pathLen; ++i) {
                String entry = (String)mGet.invoke(pyPath, i);
                this.log(lvl + 1, "sys.path[%2d] = %s", i, entry);
                this.sysPath.add(entry);
            }
        }
        catch (Exception ex) {
            this.sysPath = null;
        }
    }

    public void setSysPath() {
        if (null == cInterpreter || null == this.sysPath) {
            return;
        }
        try {
            String entry;
            int i;
            Object aState = mGetSystemState.invoke(interpreter, (Object[])null);
            Field fPath = aState.getClass().getField("path");
            Object pyPath = fPath.get(aState);
            Integer pathLen = (Integer)mLen.invoke(pyPath, (Object[])null);
            for (i = 0; i < pathLen && i < this.sysPath.size(); ++i) {
                entry = this.sysPath.get(i);
                this.log(lvl + 1, "sys.path.set[%2d] = %s", i, entry);
                mSet.invoke(pyPath, i, entry);
            }
            if (pathLen < this.sysPath.size()) {
                for (i = pathLen.intValue(); i < this.sysPath.size(); ++i) {
                    entry = this.sysPath.get(i);
                    this.log(lvl + 1, "sys.path.add[%2d] = %s", i, entry);
                    mAdd.invoke(pyPath, entry);
                }
            }
            if (pathLen > this.sysPath.size()) {
                for (i = this.sysPath.size(); i < pathLen; ++i) {
                    entry = (String)mGet.invoke(pyPath, i);
                    this.log(lvl + 1, "sys.path.rem[%2d] = %s", i, entry);
                    mRemove.invoke(pyPath, i);
                }
            }
        }
        catch (Exception ex) {
            this.sysPath = null;
        }
    }

    public void addSitePackages() {
        String fpBundle;
        File fLibFolder = JythonHelper.runTime.fSikulixLib;
        File fSitePackages = new File(fLibFolder, "site-packages");
        if (fSitePackages.exists()) {
            this.addSysPath(fSitePackages);
            if (this.hasSysPath(fSitePackages.getAbsolutePath())) {
                this.log(lvl, "added as Jython::sys.path[0]:\n%s", fSitePackages);
            }
            File fSites = new File(fSitePackages, "sites.txt");
            String sSites = "";
            if (fSites.exists() && !(sSites = FileManager.readFileToString(fSites)).isEmpty()) {
                String[] listSites;
                this.log(lvl, "found Lib/site-packages/sites.txt", new Object[0]);
                for (String site : listSites = sSites.split("\n")) {
                    String path = site.trim();
                    if (path.isEmpty()) continue;
                    this.appendSysPath(path);
                    this.log(lvl, "adding from Lib/site-packages/sites.txt:\n%s", path);
                }
            }
        }
        if ((fpBundle = ImagePath.getPath(0)) != null) {
            this.addSysPath(fpBundle);
        }
    }

    public void addSysPath(String fpFolder) {
        if (!this.hasSysPath(fpFolder)) {
            this.sysPath.add(0, fpFolder);
            this.setSysPath();
            ++this.nPathAdded;
        }
    }

    public void appendSysPath(String fpFolder) {
        if (!this.hasSysPath(fpFolder)) {
            this.sysPath.add(fpFolder);
            this.setSysPath();
            ++this.nPathAdded;
        }
    }

    public void putSysPath(String fpFolder, int n) {
        if (n < 1 || n > this.sysPath.size()) {
            this.addSysPath(fpFolder);
        } else {
            this.sysPath.add(n, fpFolder);
            this.setSysPath();
            ++this.nPathAdded;
        }
    }

    public void addSysPath(File fFolder) {
        this.addSysPath(fFolder.getAbsolutePath());
    }

    public void insertSysPath(File fFolder) {
        this.getSysPath();
        this.sysPath.add(this.nPathSaved > -1 ? this.nPathSaved : 0, fFolder.getAbsolutePath());
        this.setSysPath();
        this.nPathSaved = -1;
    }

    public void removeSysPath(File fFolder) {
        int n = this.getSysPathEntry(fFolder);
        if (-1 < n) {
            int n2;
            this.sysPath.remove(n);
            this.nPathSaved = n;
            this.setSysPath();
            if (this.nPathAdded == 0) {
                n2 = 0;
            } else {
                int n3 = this.nPathAdded;
                n2 = n3;
                this.nPathAdded = n3 - 1;
            }
            this.nPathAdded = n2;
        }
    }

    public boolean hasSysPath(String fpFolder) {
        this.getSysPath();
        for (String fpPath : this.sysPath) {
            if (!FileManager.pathEquals(fpPath, fpFolder)) continue;
            return true;
        }
        return false;
    }

    public int getSysPathEntry(File fFolder) {
        this.getSysPath();
        int n = 0;
        for (String fpPath : this.sysPath) {
            if (FileManager.pathEquals(fpPath, fFolder.getAbsolutePath())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public File existsSysPathModule(String modname) {
        String fpPath;
        this.getSysPath();
        File fModule = null;
        Iterator<String> iterator = this.sysPath.iterator();
        while (iterator.hasNext() && null == (fModule = this.existsModule(modname, new File(fpPath = iterator.next())))) {
        }
        return fModule;
    }

    public File existsSysPathJar(String fpJar) {
        String fpPath;
        this.getSysPath();
        File fJar = null;
        Iterator<String> iterator = this.sysPath.iterator();
        while (iterator.hasNext() && !(fJar = new File(fpPath = iterator.next(), fpJar)).exists()) {
            fJar = null;
        }
        return fJar;
    }

    public void showSysPath() {
        if (Debug.is(lvl)) {
            this.getSysPath();
            this.log(lvl, "***** Jython sys.path", new Object[0]);
            for (int i = 0; i < this.sysPath.size(); ++i) {
                this.logp(lvl, "%2d: %s", i, this.sysPath.get(i));
            }
            this.log(lvl, "***** Jython sys.path end", new Object[0]);
        }
    }

    public String getCurrentLine() {
        String trace = "";
        Object frame = null;
        Object back = null;
        try {
            Method mGetFrame = cPy.getMethod("getFrame", nc);
            Class<?> cPyFrame = Class.forName("org.python.core.PyFrame");
            Field fLineno = cPyFrame.getField("f_lineno");
            Field fCode = cPyFrame.getField("f_code");
            Field fBack = cPyFrame.getField("f_back");
            Class<?> cPyBaseCode = Class.forName("org.python.core.PyBaseCode");
            Field fFilename = cPyBaseCode.getField("co_filename");
            frame = mGetFrame.invoke((Object)cPy, (Object[])null);
            back = fBack.get(frame);
            if (null == back) {
                trace = "Jython: at " + this.getCurrentLineTraceElement(fLineno, fCode, fFilename, frame);
            } else {
                trace = "Jython traceback - current first:\n" + this.getCurrentLineTraceElement(fLineno, fCode, fFilename, frame);
                while (null != back) {
                    String line = this.getCurrentLineTraceElement(fLineno, fCode, fFilename, back);
                    if (!line.startsWith("Region (")) {
                        trace = trace + "\n" + line;
                    }
                    back = fBack.get(back);
                }
            }
        }
        catch (Exception ex) {
            trace = String.format("Jython: getCurrentLine: INSPECT EXCEPTION: %s", ex);
        }
        return trace;
    }

    private String getCurrentLineTraceElement(Field fLineno, Field fCode, Field fFilename, Object frame) {
        String trace = "";
        try {
            int lineno = fLineno.getInt(frame);
            Object code = fCode.get(frame);
            Object filename = fFilename.get(code);
            String fname = FileManager.getName((String)filename);
            fname = fname.replace(".py", "");
            trace = String.format("%s (%d)", fname, lineno);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trace;
    }

    class PyString {
        String aString = "";
        Object pyString = null;

        public PyString(String s) {
            this.aString = s;
            try {
                this.pyString = cPyString.getConstructor(String.class).newInstance(this.aString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object get() {
            return this.pyString;
        }
    }

    class Py {
        Method mJava2py = null;

        public Py() {
            try {
                this.mJava2py = cPy.getMethod("java2py", Object.class);
            }
            catch (Exception ex) {
                JythonHelper.this.noOp();
            }
        }

        Object java2py(Object arg) {
            if (this.mJava2py == null) {
                return null;
            }
            Object pyObject = null;
            try {
                pyObject = this.mJava2py.invoke(null, arg);
            }
            catch (Exception ex) {
                JythonHelper.this.noOp();
            }
            return pyObject;
        }
    }

    class PyFunction {
        public String __name__;
        Object func = null;
        Method mCall = null;
        Method mCall1 = null;

        public PyFunction(Object f) {
            this.func = f;
            try {
                cPyFunction.cast(this.func);
                this.mCall = cPyFunction.getMethod("__call__", new Class[0]);
                this.mCall1 = cPyFunction.getMethod("__call__", cPyObject);
            }
            catch (Exception ex) {
                this.func = null;
            }
            if (this.func == null) {
                try {
                    this.func = f;
                    cPyMethod.cast(this.func);
                    this.mCall = cPyMethod.getMethod("__call__", new Class[0]);
                    this.mCall1 = cPyMethod.getMethod("__call__", cPyObject);
                }
                catch (Exception ex) {
                    this.func = null;
                }
            }
        }

        void __call__(Object arg) {
            if (this.mCall1 != null) {
                try {
                    this.mCall1.invoke(this.func, arg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void __call__() {
            if (this.mCall != null) {
                try {
                    this.mCall.invoke(this.func, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class PyInstance {
        Object inst = null;
        Method mGetAttr = null;
        Method mInvoke = null;

        public PyInstance(Object i) {
            this.inst = i;
            cPyInstance.cast(this.inst);
            try {
                this.mGetAttr = cPyInstance.getMethod("__getattr__", String.class);
                this.mInvoke = cPyInstance.getMethod("invoke", String.class, cPyObject);
            }
            catch (Exception ex) {
                JythonHelper.this.noOp();
            }
        }

        public Object get() {
            return this.inst;
        }

        Object __getattr__(String mName) {
            if (this.mGetAttr == null) {
                return null;
            }
            Object method = null;
            try {
                method = this.mGetAttr.invoke(this.inst, mName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return method;
        }

        public void invoke(String mName, Object arg) {
            if (this.mInvoke != null) {
                try {
                    this.mInvoke.invoke(this.inst, mName, arg);
                }
                catch (Exception ex) {
                    JythonHelper.this.noOp();
                }
            }
        }
    }

    class PyException {
        Object inst = null;
        Field fType = null;
        Field fValue = null;
        Field fTrBack = null;

        public PyException(Object i) {
            this.inst = i;
            cPyException.cast(this.inst);
            try {
                this.fType = cPyException.getField("type");
                this.fValue = cPyException.getField("value");
                this.fTrBack = cPyException.getField("traceback");
            }
            catch (Exception ex) {
                JythonHelper.this.noOp();
            }
        }

        public int isTypeExit() {
            try {
                if (this.fType.get(this.inst).toString().contains("SystemExit")) {
                    return Integer.parseInt(this.fValue.get(this.inst).toString());
                }
            }
            catch (Exception ex) {
                return -999;
            }
            return -1;
        }
    }
}

