/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.RunTime;

public class LinuxSupport {
    static final RunTime runTime = RunTime.get();
    private static final String me = "LinuxSupport: ";
    private static int lvl = 3;
    private static boolean isCopiedProvided = false;
    private static boolean haveBuilt = false;
    public static boolean shouldUseProvided = false;
    static File fWorkDir = null;
    private static final String buildFolderSrc = "Build/Source";
    private static final String buildFolderInclude = "Build/Include";
    private static final String buildFolderTarget = "Build/Target";
    static File fLibs = LinuxSupport.runTime.fLibsFolder;
    public static final String slibVision = "VisionProxy";
    public static final String libVision = "libVisionProxy.so";
    public static final String libGrabKey = "libJXGrabKey.so";
    static boolean libSearched = false;
    private static String libOpenCVcore = "";
    private static String libOpenCVimgproc = "";
    private static String libOpenCVhighgui = "";
    private static String libTesseract = "";
    private static boolean opencvAvail = true;
    private static boolean tessAvail = true;
    private static final String[] libsExport = new String[]{null, null};
    private static final String[] libsCheck = new String[]{null, null};

    public static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private static void logp(String message, Object ... args) {
        Debug.logx(-3, message, args);
    }

    public static boolean existsLibs() {
        return new File(LinuxSupport.runTime.fLibsProvided, libVision).exists() || new File(LinuxSupport.runTime.fLibsProvided, libGrabKey).exists();
    }

    public static boolean copyProvidedLibs(File fLibsFolder) {
        String[] toCopy = LinuxSupport.runTime.fLibsProvided.list(new FilenameFilter(){

            @Override
            public boolean accept(File folder, String name) {
                return name.endsWith(".so");
            }
        });
        boolean success = false;
        if (toCopy != null) {
            for (String aLib : toCopy) {
                success |= FileManager.xcopy(new File(LinuxSupport.runTime.fLibsProvided, aLib), new File(fLibsFolder, aLib));
            }
        }
        return success;
    }

    public static boolean checkAllLibs() {
        boolean success = false;
        if (!isCopiedProvided && !LinuxSupport.runTime.useLibsProvided) {
            success = true;
            String[] allLibs = LinuxSupport.runTime.fLibsProvided.list(new FilenameFilter(){

                @Override
                public boolean accept(File folder, String name) {
                    return name.toLowerCase().endsWith(".so");
                }
            });
            if (allLibs != null) {
                for (String sLib : allLibs) {
                    File fSrc = new File(LinuxSupport.runTime.fLibsProvided, sLib);
                    File fTgt = new File(LinuxSupport.runTime.fLibsFolder, sLib);
                    LinuxSupport.log(3, "Copy provided lib: %s (%s)", sLib, (success &= FileManager.xcopy(fSrc, fTgt)) ? "ok" : "did not work");
                }
            }
            isCopiedProvided = true;
        } else if (!haveBuilt) {
            haveBuilt = true;
            success = LinuxSupport.haveToBuild();
        }
        shouldUseProvided = success;
        return success;
    }

    public static boolean haveToBuild() {
        boolean success = true;
        LinuxSupport.log(3, "we have to build libVisionProxy.so", new Object[0]);
        if (success &= LinuxSupport.checkNeeded()) {
            success &= LinuxSupport.buildVision();
        }
        return success;
    }

    private static boolean checkNeeded() {
        boolean checkSuccess = true;
        LinuxSupport.log(lvl, "checking: availability of OpenCV and Tesseract", new Object[0]);
        LinuxSupport.log(lvl, "checking: scanning loader cache (ldconfig -p)", new Object[0]);
        String cmdRet = runTime.runcmd("ldconfig -p");
        if (cmdRet.contains("*****error*****")) {
            LinuxSupport.log(-1, "checking: ldconfig returns error:\ns", cmdRet);
            checkSuccess = false;
        } else {
            String[] libs;
            for (String libx : libs = cmdRet.split("\n")) {
                if (!(libx = libx.trim()).startsWith("lib")) continue;
                if (libx.startsWith("libopencv_core.so.")) {
                    libOpenCVcore = libx.split("=>")[1].trim();
                    continue;
                }
                if (libx.startsWith("libopencv_highgui.so.")) {
                    libOpenCVhighgui = libx.split("=>")[1].trim();
                    continue;
                }
                if (libx.startsWith("libopencv_imgproc.so.")) {
                    libOpenCVimgproc = libx.split("=>")[1].trim();
                    continue;
                }
                if (!libx.startsWith("libtesseract.so.")) continue;
                libTesseract = libx.split("=>")[1].trim();
            }
            if (libOpenCVcore.isEmpty() || libOpenCVhighgui.isEmpty() || libOpenCVimgproc.isEmpty()) {
                LinuxSupport.log(-1, "checking: OpenCV not in loader cache (see doc-note on OpenCV)", new Object[0]);
                checkSuccess = false;
                opencvAvail = false;
            } else {
                LinuxSupport.log(lvl, "checking: found OpenCV libs:\n%s\n%s\n%s", libOpenCVcore, libOpenCVhighgui, libOpenCVimgproc);
            }
            if (libTesseract.isEmpty()) {
                LinuxSupport.log(-1, "checking: Tesseract not in loader cache (see doc-note on Tesseract)", new Object[0]);
                checkSuccess = false;
                tessAvail = false;
            } else {
                LinuxSupport.log(lvl, "checking: found Tesseract lib:\n%s", libTesseract);
            }
        }
        return checkSuccess;
    }

    private static boolean runLdd(File lib) {
        String cmdRet = runTime.runcmd("ldd -r " + lib);
        boolean success = true;
        String[] retLines = cmdRet.split("continued: build on the fly on Linux at runtime: if bundled do not work, looking for provided - if these do not work, try to build. setup not ready yet. \n");
        String libName = lib.getName();
        String libsMissing = "";
        for (String line : retLines) {
            if (!line.contains("undefined symbol:") || !line.contains(libName)) continue;
            line = line.split("symbol:")[1].trim().split("\\s")[0];
            libsMissing = libsMissing + line + ":";
        }
        if (libsMissing.isEmpty()) {
            LinuxSupport.log(lvl, "checking: should work: %s", libName);
        } else {
            LinuxSupport.log(-1, "checking: might not work, has undefined symbols: %s", libName);
            LinuxSupport.log(lvl, "%s", libsMissing);
            success = false;
        }
        return success;
    }

    public static boolean buildVision() {
        boolean success;
        File fLibsSaveDir = LinuxSupport.runTime.fLibsProvided;
        fWorkDir = fLibsSaveDir.getParentFile();
        fWorkDir.mkdirs();
        fLibsSaveDir.mkdir();
        File fTarget = new File(fWorkDir, buildFolderTarget);
        File fSource = new File(fWorkDir, buildFolderSrc);
        File fInclude = new File(fWorkDir, buildFolderInclude);
        fInclude.mkdirs();
        File[] javas = new File[]{null, null};
        javas[0] = new File(System.getProperty("java.home"));
        String jhome = System.getenv("JAVA_HOME");
        if (jhome != null) {
            javas[1] = new File(jhome);
        }
        LinuxSupport.log(lvl, "buildVision: starting inline build: libVisionProxy.so", new Object[0]);
        LinuxSupport.log(lvl, "buildVision: java.home from java props: %s", javas[0]);
        LinuxSupport.log(lvl, "buildVision: JAVA_HOME from environment: %s", javas[1]);
        File javaHome = null;
        for (File jh : javas) {
            if (jh == null) continue;
            if (!new File(jh, "bin/javac").exists()) {
                jh = jh.getParentFile();
            }
            if (!new File(jh, "bin/javac").exists()) {
                jh = null;
            }
            if (jh == null || !new File(jh, "include/jni.h").exists()) continue;
            javaHome = jh;
            break;
        }
        if (javaHome == null) {
            LinuxSupport.log(-1, "buildVision: no valid Java JDK available nor found", new Object[0]);
            return false;
        }
        LinuxSupport.log(lvl, "buildVision: JDK: found at: %s", javaHome);
        File cmdFile = new File(fWorkDir, "runBuild");
        String libVisionPath = new File(fTarget, libVision).getAbsolutePath();
        String sRunBuild = runTime.extractResourceToString("/Support/Linux", "runBuild", "");
        sRunBuild = sRunBuild.replace("#jdkdir#", "jdkdir=" + javaHome.getAbsolutePath());
        String inclUsr = "/usr/include";
        String inclUsrLocal = "/usr/local/include";
        boolean exportIncludeOpenCV = false;
        boolean exportIncludeTesseract = false;
        String inclLib = "opencv2";
        if (!new File(inclUsr, inclLib).exists() && !new File(inclUsrLocal, inclLib).exists()) {
            LinuxSupport.log(lvl, "buildVision: opencv-include: not found - using the bundled include files", new Object[0]);
            exportIncludeOpenCV = true;
        }
        if (!new File(inclUsr, inclLib = "tesseract").exists() && !new File(inclUsrLocal, inclLib).exists()) {
            LinuxSupport.log(lvl, "buildVision: tesseract-include: not found - using the bundled include files", new Object[0]);
            exportIncludeTesseract = true;
        }
        boolean bl = success = null != runTime.extractResourcesToFolder("/srcnativelibs/Vision", fSource, null);
        if (!success) {
            LinuxSupport.log(-1, "buildVision: cannot export bundled sources", new Object[0]);
        }
        if (exportIncludeOpenCV && null == runTime.extractResourcesToFolder("/srcnativelibs/Include/OpenCV", fInclude, null)) {
            LinuxSupport.log(-1, "buildVision: cannot export opencv includes", new Object[0]);
            success = false;
        }
        if (exportIncludeTesseract && null == runTime.extractResourcesToFolder("/srcnativelibs/Include/Tesseract", fInclude, null)) {
            LinuxSupport.log(-1, "buildVision: cannot export tesseract includes", new Object[0]);
            success = false;
        }
        if (success && (exportIncludeOpenCV || exportIncludeTesseract)) {
            sRunBuild = sRunBuild.replace("#extrainclude#", "extrainclude=$work/Include");
        }
        if (success) {
            sRunBuild = sRunBuild.replace("#work#", "work=" + fTarget.getParentFile().getAbsolutePath());
            sRunBuild = sRunBuild.replace("#opencvcore#", "opencvcore=" + libOpenCVcore);
            sRunBuild = sRunBuild.replace("#opencvimgproc#", "opencvimgproc=" + libOpenCVimgproc);
            sRunBuild = sRunBuild.replace("#opencvhighgui#", "opencvhighgui=" + libOpenCVhighgui);
            sRunBuild = sRunBuild.replace("#tesseractlib#", "tesseractlib=" + libTesseract);
        }
        LinuxSupport.log(lvl, "**** content of build script:\n(stored at: %s)\n%s\n**** content end", cmdFile.getAbsolutePath(), sRunBuild);
        try {
            PrintStream psCmdFile = new PrintStream(cmdFile);
            psCmdFile.print(sRunBuild);
            psCmdFile.close();
        }
        catch (Exception ex) {
            LinuxSupport.log(-1, "buildVision: problem writing command file:\n%s", cmdFile);
            return false;
        }
        cmdFile.setExecutable(true);
        if (success && opencvAvail && tessAvail) {
            LinuxSupport.log(lvl, "buildVision: running build script", new Object[0]);
            String cmdRet = runTime.runcmd(cmdFile.getAbsolutePath());
            if (cmdRet.contains("*****error*****")) {
                LinuxSupport.log(-1, "buildVision: build script returns error:\n%s", cmdRet);
                return false;
            }
            LinuxSupport.log(lvl, "buildVision: checking created libVisionProxy.so", new Object[0]);
            if (!LinuxSupport.runLdd(new File(libVisionPath))) {
                LinuxSupport.log(-1, "------- output of the build run\n%s", cmdRet);
                return false;
            }
        } else {
            LinuxSupport.log(-1, "buildVision: corrrect the reported problems and try again", new Object[0]);
            return false;
        }
        File providedLib = new File(fLibsSaveDir, libVision);
        if (!FileManager.xcopy(new File(libVisionPath), providedLib)) {
            LinuxSupport.log(-1, "buildVision: could not save:\n%s", providedLib);
            return false;
        }
        if (LinuxSupport.runTime.fLibsFolder.exists()) {
            LinuxSupport.copyProvidedLibs(LinuxSupport.runTime.fLibsFolder);
        }
        LinuxSupport.log(lvl, "buildVision: ending inline build: success:\n%s", providedLib);
        return true;
    }

    private static boolean processLibs(String fpLibsJar) {
        return true;
    }

    private static boolean checklibs(File lib) {
        boolean checkSuccess = true;
        if (!libSearched) {
            checkSuccess = LinuxSupport.checkNeeded();
            libSearched = true;
        }
        LinuxSupport.log(lvl, "checking\n%s", lib);
        String cmdRet = runTime.runcmd("readelf -d " + lib);
        if (cmdRet.contains("*****error*****")) {
            LinuxSupport.log(-1, "checking: readelf returns error:\ns", cmdRet);
            checkSuccess = false;
        } else {
            String[] retLines = cmdRet.split("\n");
            String libsNeeded = "";
            for (String line : retLines) {
                if (!line.contains("(NEEDED)")) continue;
                line = line.split("\\[")[1].replace("]", "");
                libsNeeded = libsNeeded + line + ":";
            }
            LinuxSupport.log(lvl, libsNeeded, new Object[0]);
        }
        if (!LinuxSupport.runLdd(lib)) {
            checkSuccess = false;
        }
        return checkSuccess;
    }
}

