/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;

public class OverlayTransparentWindow
extends JFrame
implements EventSubject {
    private JPanel _panel = null;
    private Color _col = null;
    private OverlayTransparentWindow _win = null;
    private Graphics2D _currG2D = null;
    private EventObserver _obs;

    public OverlayTransparentWindow() {
        this.init(null, null);
    }

    public OverlayTransparentWindow(Color col, EventObserver o) {
        this.init(col, o);
    }

    private void init(Color col, EventObserver o) {
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        if (col != null) {
            this._obs = o;
            this._win = this;
            try {
                this.setBackground(col);
            }
            catch (Exception e) {
                Debug.error("OverlayTransparentWindow.setBackground: did not work", new Object[0]);
            }
            this._panel = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    if (g instanceof Graphics2D) {
                        Graphics2D g2d = (Graphics2D)g;
                        OverlayTransparentWindow.this._currG2D = g2d;
                        if (Settings.JavaVersion < 7) {
                            g2d.setColor(OverlayTransparentWindow.this._col);
                            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (OverlayTransparentWindow.this._obs != null) {
                            OverlayTransparentWindow.this._obs.update(OverlayTransparentWindow.this._win);
                        }
                    } else {
                        super.paintComponent(g);
                    }
                }
            };
            this._panel.setLayout(null);
            this.add(this._panel);
        }
    }

    @Override
    public void setOpacity(float alpha) {
        try {
            Class<?> c = Class.forName("javax.swing.JFrame");
            Method m = c.getMethod("setOpacity", Float.TYPE);
            m.invoke((Object)this, Float.valueOf(alpha));
        }
        catch (Exception e) {
            Debug.error("OverlayTransparentWindow.setOpacity: did not work", new Object[0]);
        }
    }

    public JPanel getJPanel() {
        return this._panel;
    }

    public Graphics2D getJPanelGraphics() {
        return this._currG2D;
    }

    @Override
    public void addObserver(EventObserver o) {
        this._obs = o;
    }

    @Override
    public void notifyObserver() {
        this._obs.update(this);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

