/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.sikuli.basics.Debug;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;
import org.sikuli.script.Sikulix;

public class SikulixFileChooser {
    static final int FILES = 0;
    static final int DIRS = 1;
    static final int DIRSANDFILES = 2;
    static final int SAVE = 1;
    static final int LOAD = 0;
    Frame _parent;
    boolean accessingAsFile = false;
    boolean loadingImage = false;

    public SikulixFileChooser(Frame parent) {
        this._parent = parent;
    }

    public SikulixFileChooser(Frame parent, boolean accessingAsFile) {
        this._parent = parent;
        this.accessingAsFile = accessingAsFile;
    }

    private boolean isGeneric() {
        if (this._parent == null) {
            return false;
        }
        return this._parent.getWidth() == 1 && this._parent.getHeight() == 1;
    }

    public File show(String title) {
        File ret = this.showFileChooser(title, 0, 2, new Object[0]);
        return ret;
    }

    public File load() {
        String type = "Sikuli Script (*.sikuli, *.skl)";
        String title = "Open a Sikuli Script";
        File ret = this.showFileChooser(title, 0, 2, new SikulixFileFilter(type, "o"));
        return ret;
    }

    public File save() {
        String type = "Sikuli Script (*.sikuli)";
        String title = "Save a Sikuli Script";
        File ret = this.showFileChooser(title, 1, 1, new SikulixFileFilter(type, "s"));
        return ret;
    }

    public File export() {
        String type = "Sikuli packed Script (*.skl)";
        String title = "Export as Sikuli packed Script";
        File ret = this.showFileChooser(title, 1, 0, new SikulixFileFilter(type, "e"));
        return ret;
    }

    public File loadImage() {
        this.loadingImage = true;
        File ret = this.showFileChooser("Load Image File", 0, 0, new FileNameExtensionFilter("Image files (jpg, png)", "jpg", "jpeg", "png"));
        return ret;
    }

    private File showFileChooser(final String title, final int mode, final int theSelectionMode, final Object ... filters) {
        final String theLast_dir = PreferencesUser.getInstance().get("LAST_OPEN_DIR", "");
        Debug.log(3, "showFileChooser: %s at %s", new Object[]{title.split(" ")[0], theLast_dir});
        final Object[] result = new Object[]{null};
        if (this.isGeneric()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SikulixFileChooser.this.processDialog(theSelectionMode, theLast_dir, title, mode, filters, result);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.processDialog(theSelectionMode, theLast_dir, title, mode, filters, result);
        }
        if (null != result[0]) {
            File fileChoosen = (File)result[0];
            String lastDir = fileChoosen.getParent();
            if (null == lastDir) {
                lastDir = fileChoosen.getAbsolutePath();
            }
            PreferencesUser.getInstance().put("LAST_OPEN_DIR", lastDir);
            return fileChoosen;
        }
        return null;
    }

    private void processDialog(int selectionMode, String last_dir, String title, int mode, Object[] filters, Object[] result) {
        JFileChooser fchooser = new JFileChooser();
        File file_Choosen = null;
        while (true) {
            int dialogResponse;
            if (!last_dir.isEmpty()) {
                fchooser.setCurrentDirectory(new File(last_dir));
            }
            fchooser.setSelectedFile(null);
            fchooser.setDialogTitle(title);
            boolean shouldTraverse = false;
            String btnApprove = "Select";
            if (this.isGeneric()) {
                fchooser.setFileSelectionMode(2);
                fchooser.setAcceptAllFileFilterUsed(true);
                shouldTraverse = true;
            } else {
                if (Settings.isMac() && Settings.isJava7() && selectionMode == 1) {
                    selectionMode = 2;
                }
                fchooser.setFileSelectionMode(selectionMode);
                if (mode == 1) {
                    fchooser.setDialogType(1);
                    btnApprove = "Save";
                }
                if (filters.length == 0) {
                    fchooser.setAcceptAllFileFilterUsed(true);
                    shouldTraverse = true;
                } else {
                    fchooser.setAcceptAllFileFilterUsed(false);
                    for (Object filter : filters) {
                        if (filter instanceof SikulixFileFilter) {
                            fchooser.addChoosableFileFilter((SikulixFileFilter)filter);
                            continue;
                        }
                        fchooser.setFileFilter((FileNameExtensionFilter)filter);
                        shouldTraverse = true;
                    }
                }
            }
            if (shouldTraverse && Settings.isMac()) {
                fchooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
            }
            if ((dialogResponse = fchooser.showDialog(this._parent, btnApprove)) != 0) {
                file_Choosen = null;
                break;
            }
            file_Choosen = fchooser.getSelectedFile();
            if (this.isGeneric() || mode != 0 || this.isValidScript(file_Choosen)) break;
            Sikulix.popError("Folder not a valid SikuliX script\nTry again.");
            last_dir = file_Choosen.getParentFile().getAbsolutePath();
        }
        result[0] = file_Choosen;
    }

    private boolean isValidScript(File f) {
        String[] endings = new String[]{".py", ".rb", ".js"};
        String fName = f.getName();
        if (this.loadingImage || fName.endsWith(".skl")) {
            return true;
        }
        if (fName.endsWith(".sikuli")) {
            fName = fName.substring(0, fName.length() - 7);
        }
        boolean valid = false;
        for (String ending : endings) {
            if (!new File(f, fName + ending).exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean isExt(String fName, String givenExt) {
        int i = fName.lastIndexOf(46);
        return i > 0 && fName.substring(i + 1).toLowerCase().equals(givenExt);
    }

    class SikulixFileFilter
    extends FileFilter {
        private String _type;
        private String _desc;

        public SikulixFileFilter(String desc, String type) {
            this._type = type;
            this._desc = desc;
        }

        @Override
        public boolean accept(File f) {
            if ("o".equals(this._type) && (SikulixFileChooser.isExt(f.getName(), "sikuli") || SikulixFileChooser.isExt(f.getName(), "skl"))) {
                return true;
            }
            if ("s".equals(this._type) && SikulixFileChooser.isExt(f.getName(), "sikuli")) {
                return true;
            }
            if ("e".equals(this._type)) {
                if (SikulixFileChooser.isExt(f.getName(), "skl")) {
                    return true;
                }
                if (Settings.isMac() && SikulixFileChooser.isExt(f.getName(), "sikuli")) {
                    return false;
                }
            }
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this._desc;
        }
    }
}

