/*
 * Decompiled with CFR 0.152.
 */
package com.netease.NEJ.ide.completions;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.netease.NEJ.core.define.DefineDepPath;
import com.netease.NEJ.core.util.NEJUtil;
import com.netease.NEJ.ide.completions.DefinePathInsertHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinePathReference
extends PsiReferenceBase<PsiElement> {
    private boolean complete;

    public DefinePathReference(PsiElement element, TextRange textRange, boolean complete) {
        super(element, textRange);
        this.complete = complete;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        List<PsiElement> filesToCompletion = NEJUtil.getFilesToCompletion(this.myElement);
        ArrayList<PsiElementResolveResult> results = new ArrayList<PsiElementResolveResult>();
        for (PsiElement p : filesToCompletion) {
            results.add(new PsiElementResolveResult(p));
        }
        ResolveResult[] resolveResultArray = results.toArray(new ResolveResult[results.size()]);
        if (resolveResultArray == null) {
            DefinePathReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        Path path;
        String substring = this.myElement.getText().substring(0, this.getRangeInElement().getEndOffset());
        DefineDepPath defineDepPath = new DefineDepPath(substring, this.myElement.getProject(), this.complete);
        Path resolvePath = defineDepPath.getResolvePath();
        if (resolvePath == null) {
            return null;
        }
        if (resolvePath.isAbsolute()) {
            path = resolvePath;
        } else {
            String elementFile = this.myElement.getContainingFile().getOriginalFile().getVirtualFile().getParent().getPath();
            path = Paths.get(elementFile, String.valueOf(resolvePath.normalize())).normalize();
        }
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(String.valueOf(path));
        if (fileByPath == null) {
            return null;
        }
        if (fileByPath.isDirectory()) {
            return PsiManager.getInstance((Project)this.myElement.getProject()).findDirectory(fileByPath);
        }
        return PsiManager.getInstance((Project)this.myElement.getProject()).findFile(fileByPath);
    }

    @NotNull
    public Object[] getVariants() {
        Path path;
        ArrayList<LookupElementBuilder> completionResultSet = new ArrayList<LookupElementBuilder>();
        String eleText = this.getRangeInElement().replace(this.myElement.getText(), "");
        DefineDepPath defineDepPath = new DefineDepPath(eleText, this.myElement.getProject(), false);
        Path resolvePath = defineDepPath.getResolvePath();
        if (resolvePath.isAbsolute()) {
            path = resolvePath;
        } else {
            String elementFile = this.myElement.getContainingFile().getOriginalFile().getVirtualFile().getParent().getPath();
            path = Paths.get(elementFile, String.valueOf(resolvePath));
        }
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(String.valueOf(path.normalize()));
        PsiManager instance = PsiManager.getInstance((Project)this.myElement.getProject());
        for (VirtualFile file : fileByPath.getChildren()) {
            PsiDirectory file1;
            if (file.isDirectory()) {
                file1 = instance.findDirectory(file);
                completionResultSet.add(LookupElementBuilder.create((Object)file1, (String)file1.getName()).withIcon(file1.getIcon(1)).withInsertHandler((InsertHandler)new DefinePathInsertHandler()));
                continue;
            }
            file1 = instance.findFile(file);
            if (file1 == null) continue;
            completionResultSet.add(LookupElementBuilder.create((PsiNamedElement)file1).withIcon(file1.getIcon(1)).withInsertHandler((InsertHandler)new DefinePathInsertHandler(defineDepPath.isShouldntHaveExt())));
        }
        Object[] objectArray = completionResultSet.toArray();
        if (objectArray == null) {
            DefinePathReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/netease/NEJ/ide/completions/DefinePathReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

