/*
 * Decompiled with CFR 0.152.
 */
package com.netease.NEJ.ide.configurable;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.netease.NEJ.core.settings.NEJSettings;
import com.netease.NEJ.ide.configurable.ParameterTableBuilder;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class NEJSettingsConfigurable
implements Configurable {
    private JComponent myComponent;
    private JPanel myPanel;
    private JTable parameterTable;
    private JButton addButton;
    private JButton delButton;
    private Project project;
    private NEJSettings settingsService;
    private boolean modified = false;
    private JScrollPane scrollPane;
    private ParameterTableBuilder parameterTableBuilder;

    public NEJSettingsConfigurable() {
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return "NEJ Path Configuration";
    }

    @Nullable
    public String getHelpTopic() {
        return "Configure to work correct with NEJ platform";
    }

    @Nullable
    public JComponent createComponent() {
        this.myComponent = this.myPanel;
        DataContext context = DataManager.getInstance().getDataContext();
        this.project = (Project)PlatformDataKeys.PROJECT.getData(context);
        this.settingsService = (NEJSettings)ServiceManager.getService((Project)this.project, NEJSettings.class);
        LinkedHashMap<String, String> parameterMap = this.settingsService.getParameterMap();
        LinkedHashMap parameterMapNow = parameterMap == null ? new LinkedHashMap() : (LinkedHashMap)parameterMap.clone();
        JTableHeader header = new JTableHeader();
        header.add(new JLabel("Parameter"));
        header.add(new JLabel("Value"));
        this.parameterTable.updateUI();
        this.scrollPane.setRowHeaderView(header);
        this.parameterTableBuilder = new ParameterTableBuilder(this.parameterTable, this.project, parameterMapNow);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NEJSettingsConfigurable.this.modified = true;
                NEJSettingsConfigurable.this.parameterTableBuilder.getTableModel().addRow(new String[]{"", ""});
            }
        });
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NEJSettingsConfigurable.this.modified = true;
                NEJSettingsConfigurable.this.parameterTableBuilder.getTableModel().removeRow(NEJSettingsConfigurable.this.parameterTable.getSelectedRow());
            }
        });
        return this.myPanel;
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        LinkedHashMap<String, String> parameterMapBefore = this.settingsService.getParameterMap();
        LinkedHashMap<String, String> parameterMapNow = this.parameterTableBuilder.getTableModel().getParameterMap();
        for (String key : parameterMapNow.keySet()) {
            if (!parameterMapBefore.containsKey(key)) {
                return true;
            }
            if (parameterMapNow.get(key) == parameterMapBefore.get(key)) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.modified = false;
        LinkedHashMap<String, String> parameterMapNow = this.parameterTableBuilder.getTableModel().getParameterMap();
        this.settingsService.setParameterMap(parameterMapNow);
    }

    public void reset() {
        LinkedHashMap<String, String> parameterMap = this.settingsService.getParameterMap();
        LinkedHashMap parameterMapNow = parameterMap == null ? new LinkedHashMap() : (LinkedHashMap)parameterMap.clone();
        this.parameterTableBuilder.updateMap(parameterMapNow);
        this.modified = false;
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JTable jTable;
        JScrollPane jScrollPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.scrollPane = jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.parameterTable = jTable = new JTable();
        jTable.setFillsViewportHeight(true);
        jTable.setUpdateSelectionOnSort(false);
        jScrollPane.setViewportView(jTable);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.addButton = jButton2 = new JButton();
        jButton2.setText("+");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.delButton = jButton = new JButton();
        jButton.setText("-");
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

