/*
 * Decompiled with CFR 0.152.
 */
package com.netease.NEJ.ide.configurable;

import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import javax.swing.table.AbstractTableModel;

public class ParameterTableModel
extends AbstractTableModel {
    private final String[] COLLUMNS_NAME = new String[]{"Parameter", "Value"};
    private LinkedHashMap<String, String> parameterMap;

    public LinkedHashMap<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public ParameterTableModel(Project project, LinkedHashMap<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.parameterMap.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.COLLUMNS_NAME[column];
    }

    @Override
    public int getColumnCount() {
        return this.COLLUMNS_NAME.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.parameterMap.keySet().toArray(new String[0])[rowIndex];
        }
        return this.parameterMap.values().toArray(new String[0])[rowIndex];
    }

    public void addRow(String[] rowData) {
        if (rowData.length != 2) {
            return;
        }
        this.parameterMap.put(rowData[0], rowData[1]);
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        String key = this.parameterMap.keySet().toArray(new String[0])[row];
        this.parameterMap.remove(key);
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String oldKey = this.parameterMap.keySet().toArray(new String[0])[rowIndex];
        if (columnIndex == 0) {
            String oldValue = this.parameterMap.get(oldKey);
            this.parameterMap.remove(oldKey);
            this.parameterMap.put((String)aValue, oldValue);
        } else {
            this.parameterMap.replace(oldKey, (String)aValue);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

