/*
 * Rafael - 24/03/2020
 * File automatically generated by BlockFactory and "var code" manually filled here
 *
 */


Blockly.Python['project_metadata'] = function(block) {
  var value_project_author = Blockly.Python.valueToCode(block, 'project_author', Blockly.Python.ORDER_ATOMIC);
  var value_project_iot_id = Blockly.Python.valueToCode(block, 'project_iot_id', Blockly.Python.ORDER_ATOMIC);
  var value_project_name = Blockly.Python.valueToCode(block, 'project_name', Blockly.Python.ORDER_ATOMIC);
  var code = '#Code automatically generated by BIPES (http://www.bipes.net.br)';
  code+='\n#Author: ' + value_project_author;
  code+='\n#IOT ID: ' + value_project_iot_id;
  code+='\n#Description: ' + value_project_name + '\n';
  return code;
};


Blockly.Python['delay'] = function(block) {
  var value_time = Blockly.Python.valueToCode(block, 'time', Blockly.Python.ORDER_ATOMIC);
  Blockly.Python.definitions_['import_time'] = 'import time';
  var code = 'time.sleep(' + value_time + ')\n';
  return code;
};

Blockly.Python['reset'] = function(block) {
  //var code = 'import machine\nmachine.reset()\n';
  Blockly.Python.definitions_['import_machine'] = 'import machine';
  var code = 'machine.reset()\n';
  return code;
};

Blockly.Python['gpio_set'] = function(block) {
  var value_pin = Blockly.Python.valueToCode(block, 'pin', Blockly.Python.ORDER_ATOMIC);
  var value_value = Blockly.Python.valueToCode(block, 'value', Blockly.Python.ORDER_ATOMIC);
  // TODO: Assemble Python into code variable.
  Blockly.Python.definitions_['import_machine'] = 'import machine';
  var code = 'p = machine.Pin(' + value_pin + ', machine.Pin.OUT)\n';
  if ((value_value >= 1) || (value_value == 'True')) 
	  code += 'p.on()\n';
  else
	  code += 'p.off()\n';
  return code;

};

Blockly.Python['exec_python'] = function(block) {
  var value_command = Blockly.Python.valueToCode(block, 'command', Blockly.Python.ORDER_ATOMIC);
  var code = value_command.replace('\'','').replace('\'','') + '\n';
  return code;
};

Blockly.Python['adc'] = function(block) {
  var value_pin = Blockly.Python.valueToCode(block, 'pin', Blockly.Python.ORDER_ATOMIC);
  var code = 'adc.read()\n';
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['gpio_get'] = function(block) {
  var value_pin = Blockly.Python.valueToCode(block, 'pin', Blockly.Python.ORDER_ATOMIC);
  Blockly.Python.definitions_['import_machine'] = 'import machine';
  var code = 'p2= Pin(' + value_pin + ', Pin.IN)\ngpio_value=p2.value()\n';
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['clear_oled'] = function(block) {
  // TODO: Assemble Python into code variable.
  var code = '...\n';
  return code;
};

Blockly.Python['write_oled'] = function(block) {
  var value_text = Blockly.Python.valueToCode(block, 'text', Blockly.Python.ORDER_ATOMIC);
  // TODO: Assemble Python into code variable.
  var code = '...\n';
  return code;
};

Blockly.Python['move_servo'] = function(block) {
  var value_angle = Blockly.Python.valueToCode(block, 'angle', Blockly.Python.ORDER_ATOMIC);
  // TODO: Assemble Python into code variable.
  Blockly.Python.definitions_['import_machine'] = 'import machine';
  var code = 'p4 = machine.Pin(4); servo = machine.PWM(p4,freq=50); servo.duty(' + value_angle + ')\n';
  return code;
};

Blockly.Python['net_get_request'] = function(block) {
  var value_url = Blockly.Python.valueToCode(block, 'URL', Blockly.Python.ORDER_ATOMIC);
  Blockly.Python.definitions_['import_urequests'] = 'import urequests';
  var code = 'urequests.get(' + value_url + ')\n';
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['net_post_request'] = function(block) {
  var value_url = Blockly.Python.valueToCode(block, 'URL', Blockly.Python.ORDER_ATOMIC);
  var value_url = Blockly.Python.valueToCode(block, 'URL', Blockly.Python.ORDER_ATOMIC);
  Blockly.Python.definitions_['import_urequests'] = 'import urequests';
  var code = 'response=urequests.post(\"' + value_url + '\", data = \"' + value_url + '\")\nprint(response.contet)\n';
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['net_ifconfig'] = function(block) {
  Blockly.Python.definitions_['import_network'] = 'import network';
  var code = 'sta_if = network.WLAN(network.STA_IF); sta_if.ifconfig()\n';
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['exec_python_output'] = function(block) {
  var value_name = Blockly.Python.valueToCode(block, 'NAME', Blockly.Python.ORDER_ATOMIC);
  // TODO: Assemble Python into code variable.
  var code = '...';
  // TODO: Change ORDER_NONE to the correct strength.
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['net_ap_mode'] = function(block) {
  var value_wifi_essid = Blockly.Python.valueToCode(block, 'wifi_essid', Blockly.Python.ORDER_ATOMIC);
  var value_wifi_key = Blockly.Python.valueToCode(block, 'wifi_key', Blockly.Python.ORDER_ATOMIC);
  // TODO: Assemble Python into code variable.
  var code = '...\n';
  return code;
};

Blockly.Python['wifi_client_connect'] = function(block) {
  var value_wifi_client_essid = Blockly.Python.valueToCode(block, 'wifi_client_essid', Blockly.Python.ORDER_ATOMIC);
  var value_wifi_client_key = Blockly.Python.valueToCode(block, 'wifi_client_key', Blockly.Python.ORDER_ATOMIC);
  Blockly.Python.definitions_['import_network'] = 'import network';
  var code = 'sta_if = network.WLAN(network.STA_IF); sta_if.connect()\n';
  return code;
};

Blockly.Python['wifi_client_scan_networks'] = function(block) {
  Blockly.Python.definitions_['import_network'] = 'import network';
  var code = 'sta_if = network.WLAN(network.STA_IF); sta_if.active(True)\nsta_if.scan()\n';
  // TODO: Change ORDER_NONE to the correct strength.
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['dht_init'] = function(block) {
  var value_pin = Blockly.Python.valueToCode(block, 'pin', Blockly.Python.ORDER_ATOMIC);
  Blockly.Python.definitions_['import_machine'] = 'import machine';
  Blockly.Python.definitions_['import_dht'] = 'import dht';
  var code = 'dhts=dht.DHT11(machine.Pin(' + value_pin + '))\n';
  return code;
};

Blockly.Python['dht_read_temp'] = function(block) {
  var code = 'dhts.measure()\ndhts.temperature()\n';
  // TODO: Change ORDER_NONE to the correct strength.
  return [code, Blockly.Python.ORDER_NONE];
};

Blockly.Python['dht_read_humidity'] = function(block) {
  var code = 'dhts.measure()\ndhts.humidity()\n';
  // TODO: Change ORDER_NONE to the correct strength.
  return [code, Blockly.Python.ORDER_NONE];
};


