# -*- coding: UTF-8 -*-

import sys
from xshare import addon, setContent, get_params, log


HANDLE = int(sys.argv[1])
setContent(HANDLE, 'movies')
home = addon.getAddonInfo('path')
name, url, img, mode, page, query = get_params(sys.argv[2][1:])


def deleteSubFiles():
	from xshare import deleteSubFolder
	deleteSubFolder()


if not mode:
	import os
	from xshare import addir, endDir, namecolor, xsharetinyData, add_sep_item, deleteSubFolder
	label = namecolor('Google Search phim Fshare','lime')
	icon = os.path.join(home, 'resources', 'icon', 'gsearch.png')
	addir(label,'',icon,'search',1,'search',True)
	
	label = namecolor('Nhập link/ID Fshare','orange')
	icon  = os.path.join(home, 'icon.png')
	addir(label,'',icon,'search',1,'inputLink',True)
	
	tinyData = xsharetinyData()
	deleteSubFolder()
	
	items  = [i for i in tinyData if i!='searchString']
	if items:
		add_sep_item('-')
		
		iconPath = os.path.join(home, 'resources', 'icon')
		for href in items:
			title = tinyData.get(href)
			menu  = [
						('Đổi tên mục này',title,href,'','search',1,'renameList'),
						('Xóa mục này',title,href,'','search',1,'removeList')
			]
	
			server = ["fshare.vn", "vaphim.com", "fsharefilm.com", "taiphimhd.net", "fcine.net"]
			srv = [i for i in server if i in href]
			if srv:
				srv = srv[0]
				icon = os.path.join(iconPath, '%s.png' % srv.split(".")[0])
				addir(title, href, icon, menu=menu)
			
	endDir(HANDLE)

elif mode == 'search':
	import os
	from xshare import search
	if query == "inputLink":
		icon = os.path.join(home, 'resources', 'icon', 'fshare.png')
	else:
		icon = os.path.join(home, 'resources', 'icon', 'gsearch.png')
	xs = search(HANDLE, name, url, icon, query, page)	

elif mode == 'fshare.vn':
	from xshare import fshare
	fs = fshare(HANDLE, addon.getSetting("fshareUser"), addon.getSetting("fsharePasswd"))

	if query == "play":
		fs.play(url)

	elif query == "folder":
		fs.listFolder(url, page, img)

elif mode=='vaphim.com':
	from xshare import vaphim
	vp = vaphim(HANDLE)
	vp.getLinks(url)

elif mode=='fcine.net':
	from xshare import fcine
	fc    = fcine(HANDLE)
	fc.getFshare(url)

elif mode == 'taiphimhd.net':
	from xshare import taiphimnet
	tp = taiphimnet(HANDLE)
	tp.getFshare(url, img)		

elif mode == 'fsharefilm.com':
	from xshare import fsharefilm
	fsharefilm(HANDLE, url, query)

elif mode == "subscene":
	from xshare import subscene
	subscene(HANDLE, url)
