#! /usr/bin/env pvpython
import glob
import os
import time

from paraview.simple import *
import paraview.servermanager

from os.path import join as ttk_path_join
ttk_plugins_path = "/usr/local/lib/plugins"
for    x in glob.glob(ttk_path_join(ttk_plugins_path,'*.so' if os.name=='posix' else '*.dll')):
    LoadPlugin(x, ns=globals())

# trace generated using paraview version 5.5.2

#### import the simple module from the paraview
from paraview.simple import *
#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

# Create a new 'Render View'
renderView1 = CreateView('RenderView')
SetActiveView(renderView1)

fileNameList = ['/DATA/data/main_example.vtu','/DATA/data/startingVortexGoodEnsemble.vti', '/DATA/data/vortexStreetGoodEnsemble2.vti', '/DATA/data/isabella_velocity_goodEnsemble.vti','/DATA/data/seaSurfaceHeightGoodEnsemble.vti']

gaussian_list = ['Gaussian_000', 'Gaussian_001', 'Gaussian_002', 'Gaussian_003', 'Gaussian_004', 'Gaussian_005', 'Gaussian_006', 'Gaussian_007', 'Gaussian_008', 'Gaussian_009', 'Gaussian_010', 'Gaussian_011', 'Gaussian_012', 'Gaussian_013', 'Gaussian_014', 'Gaussian_015', 'Gaussian_016', 'Gaussian_017', 'Gaussian_018', 'Gaussian_019', 'Gaussian_020', 'Gaussian_021', 'Gaussian_022', 'Gaussian_023', 'Gaussian_024', 'Gaussian_025', 'Gaussian_026', 'Gaussian_027', 'Gaussian_028', 'Gaussian_029', 'Gaussian_030', 'Gaussian_031', 'Gaussian_032', 'Gaussian_033', 'Gaussian_034', 'Gaussian_035', 'Gaussian_036', 'Gaussian_037', 'Gaussian_038', 'Gaussian_039', 'Gaussian_040', 'Gaussian_041', 'Gaussian_042', 'Gaussian_043', 'Gaussian_044', 'Gaussian_045', 'Gaussian_046', 'Gaussian_047', 'Gaussian_048', 'Gaussian_049', 'Gaussian_050', 'Gaussian_051', 'Gaussian_052', 'Gaussian_053', 'Gaussian_054', 'Gaussian_055', 'Gaussian_056', 'Gaussian_057', 'Gaussian_058', 'Gaussian_059', 'Gaussian_060', 'Gaussian_061', 'Gaussian_062', 'Gaussian_063', 'Gaussian_064', 'Gaussian_065', 'Gaussian_066', 'Gaussian_067', 'Gaussian_068', 'Gaussian_069', 'Gaussian_070', 'Gaussian_071', 'Gaussian_072', 'Gaussian_073', 'Gaussian_074', 'Gaussian_075', 'Gaussian_076', 'Gaussian_077', 'Gaussian_078', 'Gaussian_079', 'Gaussian_080', 'Gaussian_081', 'Gaussian_082', 'Gaussian_083', 'Gaussian_084', 'Gaussian_085', 'Gaussian_086', 'Gaussian_087', 'Gaussian_088', 'Gaussian_089', 'Gaussian_090', 'Gaussian_091', 'Gaussian_092', 'Gaussian_093', 'Gaussian_094', 'Gaussian_095', 'Gaussian_096', 'Gaussian_097', 'Gaussian_098', 'Gaussian_099']
startingVortex_list = ['vorticity_angle_02', 'vorticity_angle_03', 'vorticity_angle_04', 'vorticity_angle_05', 'vorticity_angle_06', 'vorticity_angle_08', 'vorticity_angle_38', 'vorticity_angle_39', 'vorticity_angle_40', 'vorticity_angle_41', 'vorticity_angle_42', 'vorticity_angle_43']
vortexStreet_list = ['100.0', '100.1', '100.2', '100.3', '100.4', '100.5', '100.6', '100.7', '100.9', '160.0', '160.1', '160.2', '160.3', '160.4', '160.5', '160.6', '160.7', '160.8', '200.0', '200.1', '200.2', '200.3', '200.4', '200.5', '200.6', '200.7', '200.8', '50.0', '50.1', '50.2', '50.3', '50.5', '50.6', '50.7', '50.8', '50.9', '60.1', '60.2', '60.3', '60.4', '60.5', '60.6', '60.7', '60.8', '60.9']
isabel_list =  ['velocityMag_02', 'velocityMag_03', 'velocityMag_04', 'velocityMag_05', 'velocityMag_30', 'velocityMag_31', 'velocityMag_32', 'velocityMag_33', 'velocityMag_45', 'velocityMag_46', 'velocityMag_47', 'velocityMag_48']
seaSurface_list= ['20120111', '20120115', '20120116', '20120117', '20120118', '20120119', '20120120', '20120121', '20120122', '20120123', '20120128', '20120129', '20120419', '20120420', '20120421', '20120422', '20120423', '20120424', '20120425', '20120426', '20120427', '20120428', '20120429', '20120430', '20120711', '20120712', '20120713', '20120714', '20120715', '20120716', '20120717', '20120718', '20120719', '20120720', '20120721', '20120722', '20121008', '20121009', '20121010', '20121011', '20121012', '20121016', '20121017', '20121018', '20121019', '20121020', '20121022', '20121023']
folder_name = ["gaussian","startingVortex","vortexStreet","isabel", "seaSurfaceHeight"]

list_of_data_list = [gaussian_list, startingVortex_list, vortexStreet_list, isabel_list, seaSurface_list]

for i_dataSet in [3]:
    start = time.time()
    filename = "/home/julius/ttk-data/isabel.vti"
    data_list = list_of_data_list[i_dataSet]

    if(i_dataSet==0):
        dataSet = XMLUnstructuredGridReader(FileName=filename)
    else:
        dataSet  = XMLImageDataReader(FileName=filename)

    dataSet.PointArrayStatus = data_list
    diagrams = []

    nb_point_average=0
    nb_point = 0
    i_diag = 0
    for data in data_list:
        tTKPersistenceDiagram = TTKPersistenceDiagram(Input=dataSet)
        tTKPersistenceDiagram.DebugLevel = 0
        tTKPersistenceDiagram.ScalarField = data
        tTKPersistenceDiagram.UseAllCores=1
        tTKPersistenceDiagram.ThreadNumber=16
        tTKPersistenceDiagram.InputOffsetField = data

        diagonal_threshold = Threshold(Input = tTKPersistenceDiagram)
        diagonal_threshold.Scalars = ['CELLS', 'PairIdentifier']
        [_,max_pair_identifier] = servermanager.Fetch(tTKPersistenceDiagram).GetCellData().GetArray(0).GetRange()
        diagonal_threshold.ThresholdRange = [0,max_pair_identifier]
        diagonal_threshold_Display = Show(diagonal_threshold, renderView1)

        persistence_threshold = Threshold(Input = diagonal_threshold)
        persistence_threshold.Scalars = ['CELLS', 'Persistence']
        [_,max_persistence] = servermanager.Fetch(diagonal_threshold).GetCellData().GetArray(2).GetRange()
        persistence_threshold.ThresholdRange = [0.01*max_persistence, 1.1*max_persistence]
        persistence_threshold_Display = Show(persistence_threshold, renderView1)

        nb_point = persistence_threshold.SMProxy.GetOutputPort(0).GetDataInformation().GetNumberOfPoints()
        nb_point_average += nb_point/len(data_list)
        savefilename = "./isabel_diagram_"+str(i_diag)+".vtu"
        SaveData(savefilename, proxy=persistence_threshold)
        Delete(tTKPersistenceDiagram)
        del tTKPersistenceDiagram
        Delete(diagonal_threshold)
        del diagonal_threshold
        Delete(persistence_threshold)
        del persistence_threshold
        i_diag = i_diag + 1
    Delete(dataSet)
    del dataSet
    end=time.time()
    print("Elapsed for data set ",i_dataSet, " : ", end-start)
