% the main.m
clear all
clc
rand ('state', sum(100*clock));
% the name of algorithm
algorithmDir = 'ABSO';
%% experimental condition
% population size
popuSize = 100;
% dimension
D = 30;
% benchmark function
benchmark = 2017;
%CEC2005 include 25 functions
%CEC2011 include 22 functions
%CEC2013 include 28 functions
%CEC2014 include 30 functions
%CEC2017 include 30 functions
problemIndex = [1:30];
fhd = @cec17_func;
% the max number of runtimes
runTime = 2;
%% loop start
for f = problemIndex
    convergenceChart = [];
    % count of runtimes
    run = 1;
    %% indenpendented run 
    while run <= runTime
        % timer
        tic
        % set of optima
        optimalChart = [];
%         DIV = [];
        %% initialization of each run
        % count of function evaluation
        nFES = 0;
        % count of iteration
        iter = 0;
        % count of exploration 
        exploreIter = 0;
        % count of exploitation
        exploitIter = 0;
        %% Population initialization
        % the max number of function evaluations
        FES = 10^4 * D;
        % max iteration number
        maxIter = FES / popuSize;
        % maxIter of Exploration
        maxExploreIter = maxIter;
                %%
        etaInit = 0.25;
        eta = etaInit;
        numC = 10;
%         nGInit = 10;
        nG = 20;
        maxUnimpro = 7;
%         maxUnexplore = 10;
        unexplore = 0;
        %%
        %% parameter setting of exploration
        % the number of grid 10 50 100
        lu = [-100*ones(1,D); 100*ones(1,D)];
        space = (lu(2,1)-lu(1,1)) / nG;
        sectionStep = space * ones(1,D);
        numCinit = numC;

        unimproved = 0;
        % the max number of unimproved; 
        flagChange = true;
        %% parameter setting of exploiration(BSO)
        % the number of cluster
        
        % center of each cluster
        best = zeros(numC,1);
        % The probability of selecting one cluster
        prob_one_cluster = 0.8;
        prob_one_center = 0.4;
        prob_two_center = 0.5;
        fitness_popu_sorted = 10e20*ones(popuSize,1);
        popu = zeros(popuSize,D);
        prob = zeros(numC,1);
        %% Build grid
        [sections,sectionSteps] = segmentation(lu, sectionStep, numCinit);
        valRow = 1;
        freqRow = 2;
        cIndex = repmat((1:numCinit),1,ceil(popuSize/ numCinit));
        for i = 1:popuSize
            section = sections{cIndex(i)};
            sectionStep = sectionSteps{cIndex(i)};
            for d = 1:D
                list = find(section{d}(freqRow,:) == min(section{d}(freqRow,:)));
                index = list(randperm(length(list), 1));
                section{d}(freqRow,index) = section{d}(freqRow,index) + 1;
                popu(i,d) = section{d}(valRow,index) + rand * sectionStep(d);
            end
            sections{cIndex(i)} = section;
        end
        popuFitness = feval(fhd,popu',f);
        [optimalFit, optI] = min(popuFitness);
        optimum = popu(optI,:);
        nFES = nFES + popuSize;
        optimalChart = [optimalChart;repmat(optimalFit,popuSize,1)];
        hBest = popu;
        hBestFit = popuFitness;
        %% make dir to save trajectory image
        %% start to search
        while nFES <= FES
            
            if flagChange
                %% exploration
                iter = iter + 1;
                exploreIter = exploreIter + 1;
                if exploreIter >= eta*maxExploreIter
                    eta = etaInit - etaInit * iter / maxIter;
                    flagChange = false;
                    fprintf('---------------------begin exploitation--------------------------\n');
                    maxExploitIter = maxExploreIter - exploreIter;
                    exploreIter = 0;
                    
                end
                cIndex = repmat((1:numCinit),1,ceil(popuSize/ numCinit));
                for i = 1:popuSize
                    section = sections{cIndex(i)};
                    sectionStep = sectionSteps{cIndex(i)};
                    compreInd = zeros(1,D);
                    for d = 1:D
                        tempSum = section{d}(freqRow,:);
                        seleList = find(tempSum == min(tempSum));
                        seleInd = seleList(randperm(length(seleList), 1));
                        section{d}(freqRow,seleInd) = section{d}(freqRow,seleInd) + 1;
                        popu(i,d) = section{d}(valRow,seleInd)+ rand * sectionStep(d);
                    end
                    sections{cIndex(i)} = section;
                end
                popu = BoundaryDetection(popu,lu);
                popuFitness = feval(fhd,popu',f);
                nFES = nFES + popuSize;
                for i = 1:popuSize
                    if hBestFit(i) > popuFitness(i)
                        hBestFit(i) = popuFitness(i);
                        hBest(i,:) = popu(i,:);
                    end
                end
                [optimalFit, optI] = min(hBestFit);
                optimum = hBest(optI,:);
                optimalChart = [optimalChart;repmat(optimalFit,popuSize,1)];
            else
                %% exploitatopm (BSO)
                iter = iter + 1;
                exploitIter = exploitIter + 1;
                [idx,C,~,~] = kmeans(hBest, numC,'Distance','sqeuclidean','Start','uniform','EmptyAction','drop');
                if isnan(sum(C))
                    dropIndex =find(isnan(sum(C,2)) == 1);
                    for l = 1:length(dropIndex)
                        dr = dropIndex(l);
                        idx(idx>dr) = idx(idx>dr) -1;
                        dropIndex = dropIndex - 1;
                        numC = numC-1;
                    end
                end
                fit_values = 10e200*ones(numC,1);
                number_in_cluster = zeros(numC,1);  % initialize 0 individual in each cluster
                popu_sorted  = hBest;
                for i = 1:popuSize
                    number_in_cluster(idx(i,1),1)= number_in_cluster(idx(i,1),1) + 1;
                    
                    % find the best individual in each cluster
                    if fit_values(idx(i,1),1) > hBestFit(i)  % minimization
                        fit_values(idx(i,1),1) = hBestFit(i);
                        best(idx(i,1),1) = i;
                    end
                    
                end
                
                % form population sorted according to clusters
                counter_cluster = zeros(numC,1);  % initialize cluster counter to be 0
                
                acculate_num_cluster = zeros(numC,1);  % initialize accumulated number of individuals in previous clusters
                %
                for i =2:numC
                    acculate_num_cluster(i,1) = acculate_num_cluster((i-1),1) + number_in_cluster((i-1),1);
                end
                
                %
                %     %start form sorted population
                for i = 1:popuSize
                    counter_cluster(idx(i,1),1) = counter_cluster(idx(i,1),1) + 1 ;
                    temIdx = acculate_num_cluster(idx(i,1),1) +  counter_cluster(idx(i,1),1);
                    popu_sorted(temIdx,:) = hBest(i,:);
                    fitness_popu_sorted(temIdx,1) = hBestFit(i);
                end
                
                % record the best individual in each cluster
                for i = 1:numC
                    centers(i,:) = hBest(best(i,1),:);
                end
                
                centers_copy = centers;
                
                % calculate cluster probabilities based on number of individuals in
                % each cluster
                for i = 1:numC
                    prob(i,1) = number_in_cluster(i,1)/popuSize;
                    if i > 1
                        prob(i,1) = prob(i,1) + prob(i-1,1);
                    end
                end
                % generate n_p new individuals by adding Gaussian random values
                for i = 1:popuSize
                    sectionStep = sectionSteps{cIndex(i)};
                    if rand() < prob_one_cluster % select one cluster
                        for idj = 1:numC
                            if rand() < prob(idj,1)
                                if rand() < prob_one_center  % use the center
                                    popu(i,:) = centers(idj,:);
                                else % use one randomly selected  cluster
                                    indi_1 = acculate_num_cluster(idj,1) + ceil(rand() * number_in_cluster(idj,1));
                                    popu(i,:) = popu_sorted(indi_1,:);
                                end
                                break
                            end
                        end
                    else % select two clusters
                        % pick two clusters
                        cluster_1 = ceil(rand() * numC);
                        indi_1 = acculate_num_cluster(cluster_1,1) + ceil(rand() * number_in_cluster(cluster_1,1));
                        
                        cluster_2 = ceil(rand() * numC);
                        indi_2 = acculate_num_cluster(cluster_2,1) + ceil(rand() * number_in_cluster(cluster_2,1));
                        
                        tem = rand();
                        if rand() < prob_two_center %use center
                            popu(i,:) = tem * centers(cluster_1,:) + (1-tem) * centers(cluster_2,:);
                        else   % use randomly selected individuals from each cluster
                            popu(i,:) = tem * popu_sorted(indi_1,:) + (1-tem) * popu_sorted(indi_2,:);
                        end
                    end
                    %
                    stepSize = tanh(maxIter - iter) * sectionStep .* rand(1,D);
                    popu(i,:) = popu(i,:) + stepSize .* normrnd(0,1,1,D);
                end
                % Boundary detection
                popu = BoundaryDetection(popu,lu);
                % Population evaluation
                popuFit = feval(fhd,popu',f);
                nFES = nFES + popuSize;
                count = 0;
                for i = 1:popuSize
                    if hBestFit(i) > popuFit(i)
                        hBestFit(i) = popuFit(i);
                        hBest(i,:) = popu(i,:);
                        count  = 1;
                    end
                end
                [optimalFit, optI] = min(hBestFit);
                optimum = hBest(optI,:);
                optimalChart = [optimalChart;repmat(optimalFit,popuSize,1)];
                for c = 1:numC
                    hBest(best(c,1),:) = centers_copy(c,:);
                    hBestFit(best(c,1)) = fit_values(c);
                end
                if count == 0
                    unimproved = unimproved + 1;
                    if unimproved >= maxUnimpro
%                         nG = nGInit - nGInit * iter/maxIter + 1;
                        tempSectionSteps = sectionSteps;
                        sections = cell(1,numC);
                        sectionSteps = cell(1,numC);
                        unimproved = 0;
                        flagChange = true;
                        
                        for c = 1:numC
                            subPop = hBest(idx==c,:);
                            [subPopuSize,~] = size(subPop);
                            [section, sectionStep] = resegmentation(subPop,tempSectionSteps{c},nG);
                            sections{c} = section;
                            sectionSteps{c} = sectionStep;
                        end
                        maxExploreIter = maxExploitIter - exploitIter;
                        exploitIter = 0;
                        numCinit = numC;
                        fprintf('---------------------begin exploration--------------------------\n');
                    end
                else
                    unimproved = 0;
                end
            end
%             div = Diversity(popu);
%             DIV = [DIV;div];
            fprintf('%s problem %5.0f time %5.0f |%5.0f -----> %9.16f\n', algorithmDir, f,run,nFES,optimalFit);
        end
        %%
        optimalChart = optimalChart(1:popuSize:FES);
        resultChart = [resultChart,optimalChart];
        run = run + 1;
        toc
    end
%     path = ['./BSOs_',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'.xls'];
%     sheetName = ['CEC_' num2str(benchmark) '_F'];
%     xlswrite(path,resultChart,[sheetName,num2str(f)]);
%     xlswrite(['./',algorithmDir,'_CEC',num2str(benchmark),'_D',num2str(D),'_div.xls'],DIV,['Sheet',num2str(f)]);
end


%% function
function [Grids,steps] = segmentation(lu, step, numS)
% [popuSize,D] = size(popu);
[~,D] = size(lu);
Grids = cell(1,numS);
steps = cell(1,numS);
for i = 1:numS
    Grid = cell(1,D);
    for d = 1:D
        valueList = lu(1,1):step(d):lu(2,1)-step(d);
        % limit number of one featuer
        lenList = length(valueList);
        % section and it's frequency for one demension
        % 1 section list
        % 2 selected frequency
        sectionTemp = vertcat(valueList,zeros(1,lenList));
        % for decreas space
        Grid{d} = sectionTemp;
    end
    Grids{i} = Grid;
    steps{i} = step;
end
end

function [Grid, sectionStep] = resegmentation(data,sectionStep,nG)
[dataSize, D] = size(data);
Grid = cell(1,D);
for d = 1:D
    maxValue = max(data(:,d));
    maxValue = maxValue(1) + sectionStep(d);
    minValue = min(data(:,d));
    minValue = minValue(1) - sectionStep(d);
    if maxValue == minValue
        sectionList = minValue;
    else
        sectionStep(d) = (maxValue - minValue) / nG;
%         if sectionStep(d) < 1.0e-8
%             sectionStep(d) = 1.0e-8;
%         end
        sectionList = minValue:sectionStep(d):maxValue-sectionStep(d);
    end
    lenList = length(sectionList);
    sectionList = vertcat(sectionList,zeros(1,lenList));
    Grid{d} = sectionList;
end
freqRow = 2;
for i = 1:dataSize
    for d = 1:D
        result = data(i,d) - Grid{d}(1,:);
        [~, I] = min(abs(result));
        Grid{d}(freqRow,I) = Grid{d}(freqRow,I) + 1;
    end
end
end