clear all
clc

rand ('state', sum(100*clock));

PopSize = 100;
DimSize = 30;
fhd = @cec17_func;

rang_r = 100;%100;
rang_l = -100;%-100;


runmax  = 30;
maxFES  = DimSize * 10e3;
genmax  = maxFES / PopSize;


prob_one_cluster = 0.8;
prob_one_center = 0.4;
prob_two_center = 0.5;

n_c = 5;

C = 1;
Cmin = 0.2;
Cmax = 0.8;
Discard_Interval = 10;
agbso_Cluster = parcluster('local');
agbso_Cluster.NumWorkers = 4;  % define how many processors to use
for function_number = 1:30
    function_number
    optima = function_number * 100;
    funvals=[];
    parfor run=1:runmax
        lu = [rang_l*ones(1,DimSize); rang_r*ones(1,DimSize)];
        Limits = zeros(PopSize,1);
        Step = (rang_r - rang_l)/20;
        RunBest = zeros(maxFES,1);
        FES = 0;
        Stagnation = 0;
        flag = true;
        %% Build grid
        nG = PopSize;
        sectionStep = (lu(2,:)-lu(1,:)) / nG .* ones(1,DimSize);
        [section,sectionStep] = segmentation(lu, sectionStep);
        
        % random initialization
        popu = rang_l + (rang_r - rang_l) * rand(PopSize,DimSize);
        
        % grid initialization
        for i = 1:PopSize
            for d = 1:DimSize
                list = find(section{d}(2,:) == min(section{d}(2,:)));
                index = list(randperm(length(list), 1));
                section{d}(2,index) = section{d}(2,index) + 1;
                popu(i,d) = section{d}(1,index) + rand * sectionStep(d);
            end
        end
        best = ones(n_c,1);
        centers = zeros(n_c,DimSize);
        
        indi_temp = zeros(PopSize,DimSize);
        
        fitness_popu = feval(fhd,popu',function_number);
        fitness_popu = fitness_popu';
        
        FES = FES + PopSize;
        
        [BestFit, minindex] = min(fitness_popu);
        BestIdea = popu(minindex,:);
        optimalFit = BestFit;
        gen = 1;
        
        RunBest(1:FES) = optimalFit;
%         RunBest = [RunBest;optimalFit];
%         for i = 1:PopSize
%             RunBest = [RunBest;optimalFit];
%         end
        while(FES<maxFES)
            if DimSize == 2
                showTraj(function_number, popu, indi_temp, BestIdea);
                pause
            end
            gen = gen + 1;
            %% GRID
            if flag
                for i = 1:PopSize
                    for d = 1:DimSize
                        list = find(section{d}(2,:) == min(section{d}(2,:)));
                        index = list(randperm(length(list), 1));
                        section{d}(2,index) = section{d}(2,index) + 1;
                        indi_temp(i,d) = section{d}(1,index) + rand * sectionStep(d);
                    end
                end
            else
                %% GBSO
                
                % Fitness-based Grouping
                group = {};
                fit_values = zeros(n_c,1);
                [fitness_popu,Indices] = sort(fitness_popu);
                popu = popu(Indices,:);
                Limits = Limits(Indices,:);
                subgroup = PopSize / n_c;
                for idx = 1 : n_c
                    index = idx : n_c : PopSize;
                    group = {group{1:end} index};
                    centers(idx,:) = popu(idx,:);
                    fit_values(idx,1) = fitness_popu(idx,1);
                end
                
                
                % assign a initial big fitness value  as best fitness for each cluster in minimization problems
                fit_values = 10^300*ones(n_c,1);
                
                
                for idx = 1:n_c
                    % find the best individual in each group
                    for idy=1:subgroup
                        if fit_values(idx,1) > fitness_popu(group{idx}(idy),1)  % minimization
                            fit_values(idx,1) = fitness_popu(group{idx}(idy),1);
                            best(idx,1) = group{idx}(idy);
                        end
                    end
                    % record the best individual in each group
                    centers(idx,:) = popu(best(idx,1),:);
                end
                
                %Generating new idea according to one or two grouping
                % One problem variable at a time
                indi_temp = popu;
                C = Cmin + ((Cmax-Cmin)/genmax)*gen;
                %indi_temp = zeros(PopSize,DimSize);
                for i=1:PopSize
                    Attractor = zeros(1,DimSize);
                    
                    for j=1:DimSize
                        r_1 = rand;  % probability for select one cluster to form new individual
                        %prob_one_cluster = prob_one_cluster_min + ((prob_one_cluster_max-prob_one_cluster_min)/genmax)*gen;
                        if r_1 < prob_one_cluster % select one cluster
                            %Attractor(j) = indi_temp(i,j);
                            r = rand;
                            idxe = ceil(rand * n_c);
                            if r < prob_one_center  % use the center
                                Attractor(j) = centers(idxe,j);
                            else % use one randomly selected  cluster
                                idye=ceil(rand * subgroup);
                                while(idye==1)
                                    idye=ceil(rand * subgroup);
                                end
                                Attractor(j) = popu(group{idxe}(idye),j);
                            end
                        else
                            % select two clusters
                            % pick two clusters
                            % make sure two clusters are different
                            % make sure selected members are not centers
                            idx1 = ceil(rand * n_c);
                            idy1 = ceil(rand * subgroup);
                            while(idy1==1)
                                idy1=ceil(rand * subgroup);
                            end
                            indi_1 = group{idx1}(idy1);
                            
                            idx2 = ceil(rand * n_c);
                            while(idx2==idx1)
                                idx2=ceil(rand * n_c);
                            end
                            idy2 = ceil(rand * subgroup);
                            while(idy2==1)
                                idy2=ceil(rand * subgroup);
                            end
                            indi_2 = group{idx2}(idy2);
                            
                            tem = rand;
                            if rand < prob_two_center %use center
                                Attractor(j) = (1-tem) * centers(idx1,j) + tem * centers(idx2,j);
                            else   % use randomly selected individuals from each cluster
                                Attractor(j) = (1-tem) * popu(indi_1,j) + tem *  popu(indi_2,j);
                            end
                        end
                    end
                    
                    % Origianl
                    indi_temp(i,:) = Attractor;
                    
                    
                    % Move Towards Global Best
                    if(rand<C)
                        indi_temp(i,:) = indi_temp(i,:) + C .* rand(1,DimSize) .* (BestIdea - indi_temp(i,:));
                    end
                    
                    stepSize = exp(1-genmax/(genmax+1-gen)) * rand(1,DimSize) .* Step;
                    indi_temp(i,:) = indi_temp(i,:) + stepSize .* normrnd(0,1,1,DimSize);
                    
                    %if (ObjFun~=7)&&(ObjFun~=25)
                    %for jj=1:DimSize
                    %indi_temp(i,j) = max(indi_temp(i,j),rang_l);
                    %indi_temp(i,j) = min(indi_temp(i,j),rang_r);
                    indi_temp(i,:) = max(indi_temp(i,:),rang_l);
                    indi_temp(i,:) = min(indi_temp(i,:),rang_r);
                    %end
                    %end
                    
                    %end
                end
            end
            fv = feval(fhd,indi_temp',function_number);
            fv = fv';
            
            [fitness_popu,I] = min([fitness_popu,fv],[],2);
            popu(I==2,:) = indi_temp(I==2,:);
            Limits(I==2) = 0;
            Limits(I==1) = Limits(I==1) + 1;
            

            
            [IterBestFit,minindex] = min(fitness_popu);
            if(IterBestFit<BestFit)
                BestFit = IterBestFit;
                BestIdea = popu(minindex,:);
                if BestFit < optimalFit
                    optimalFit = BestFit;
                end
                Stagnation = 0;
            else
                Stagnation = Stagnation + 1;
                if Stagnation > Discard_Interval
                    Stagnation = 0;
                    if flag
                        flag = false;
%                         fprintf('---------------------begin exploitation--------------------------\n');

                    else
                        if rand < 0.5
                            Indices = find(Limits>Discard_Interval);
                            if(~isempty(Indices))
                                for idea = 1 : length(Indices)
                                    Index = Indices(idea);
                                    if rand < 0.5
                                        rnd = randperm(PopSize);
                                        rnd(rnd == Index) = [];
                                        idx1 = rnd(1);
                                        idx2 = rnd(2);
                                        idx3 = rnd(3);
                                        popu(Index,:) = popu(idx1,:) + 0.5 * (popu(idx2,:) - popu(idx3,:));
                                        
                                        popu(Index,:) = max(popu(Index,:),rang_l);
                                        popu(Index,:) = min(popu(Index,:),rang_r);
                                    else
                                        popu(Index,:) = rang_l + (rang_r - rang_l) * rand(1,DimSize);
                                    end
                                end
                                fitness_popu(Indices,:) = feval(fhd,popu(Indices,:)',function_number);
                                Limits(Indices) = 0;
                                if min(fitness_popu(Indices,:)) < BestFit
                                    BestFit = min(fitness_popu(Indices,:));
                                    if BestFit < optimalFit
                                        optimalFit = BestFit;
                                    end
                                end
                                for nfes = 1:length(Indices)
                                    RunBest(FES+nfes) = optimalFit;
                                end
                            end
%                             rnd = randperm(PopSize);
%                             rnd(rnd == i) = [];
%                             r1 = rnd(1);
%                             r2 = rnd(2);
%                             r3 = rnd(3);
%                             BestIdea = popu(r1,:) + 0.5 * (popu(r2,:) - popu(r3,:));
%                             BestIdea = max(BestIdea,rang_l);
%                             BestIdea =  min(BestIdea,rang_r);
                        else
                            flag = true;
                            %                         fprintf('---------------------begin exploration--------------------------\n');
                            %
                            
                            [section, sectionStep] = resegmentation2(popu,nG);
%                             fitness_popu = 10e200 * ones(PopSize,1);
                            Indices = find(Limits>Discard_Interval);
                            if(~isempty(Indices))
                                for idea = 1 : length(Indices)
                                    Index = Indices(idea);
                                    fitness_popu(Index,:) = 10e200;                            
                                end
                                Limits(Indices) = 0;
                            end
                        end
                        
                    end
                        
                end
            end
%             RunBest = [RunBest;optimalFit];
            for nfes = 1:PopSize
                RunBest(FES+nfes) = optimalFit;
            end
            FES = FES + PopSize;
        end
        RunBest = RunBest(1:PopSize:end,:);
        RunBest = RunBest - optima;
        RunBest(RunBest <= 10^-8) = 0;
        funcval_out(run) = RunBest(end);
        fprintf('%d th run, best-so-far error value = %1.8e\n', run , funcval_out(run))
        funvals(run,:)=RunBest;
    end
    path = ['./BSOs_AGBSO_CEC2017','_D',num2str(DimSize)];
    xlswrite([path,'.xlsx'],funvals',['F',num2str(function_number)]);
end

function [Grid,step] = segmentation(lu, step)
% [popuSize,D] = size(popu);
[~,D] = size(lu);
Grid = cell(1,D);
for d = 1:D
    valueList = lu(1,d):step(d):lu(2,d)-step(d);
    % limit number of one featuer
    lenList = length(valueList);
    % section and it's frequency for one demension
    % 1 section list
    % 2 selected frequency
    sectionTemp = vertcat(valueList,zeros(1,lenList));
    % for decreas space
    Grid{d} = sectionTemp;
end
end

function [Grid, sectionStep] = resegmentation2(data,nG)
[~, D] = size(data);
Grid = cell(1,D);
sectionStep = zeros(1,D);
for d = 1:D
    maxValue = max(data(:,d));
    maxValue = maxValue(1);
    minValue = min(data(:,d));
    minValue = minValue(1);
    if maxValue == minValue
        sectionList = minValue * ones(1,nG);
    else
        sectionStep(d) = (maxValue - minValue) / nG;
        sectionList = minValue:sectionStep(d):maxValue-sectionStep(d);
    end
    lenList = length(sectionList);
    sectionList = vertcat(sectionList,zeros(1,lenList));
    Grid{d} = sectionList;
end
end

function showTraj(problemIndex, popu, offs, optimal)
func_plot(problemIndex);
h = plot(popu(:,1),popu(:,2),'.r','MarkerSize',15);
hold on
plot(optimal(1,1),optimal(1,2),'-rp','MarkerSize',20);
plot(offs(:,1),offs(:,2),'.b','MarkerSize',15);
hold off
end