function [cost] = DNMfunction(population,problem,popsize)
cost = zeros(popsize,1);
switch problem
    case 21
        I2=[0 0 0 0 1 1 1 1;0 0 1 1 0 0 1 1;0 1 0 1 0 1 0 1];
        T=[0 1 1 0 1 0 0 1];
        Hno = 6;
        dim = 36;
        for popindex = 1 : popsize
            W = population(popindex,1:3*Hno);
            B = population(popindex,3*Hno+1:dim);
            fitness = 0;
            for pp = 1:8
                actualvalue = my_DNM(3,Hno,1,W,B,I2(:,pp)');
                fitness = fitness +(T(pp)-actualvalue)^2;
            end
            fitness = fitness /8;
            cost(popindex) = fitness;
        end
    case 23
        load Iris.txt
        input = Iris(:,1:4);
        out = Iris(:,5);
        Hno = 7;
        dim = 4*7*2;
        for popindex = 1: popsize
            W = population(popindex,1:4*Hno);
            B = population(popindex,4*Hno+1:dim);
            fitness = 0;
            for pp = 1:150
                actualvalue=my_DNM(4,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness/150;
            cost(popindex) = fitness;
        end
    case 25
        load heart297.mat
        input = heart297(:,1:10);
        out = heart297(:,11);
        Hno=14;
        dim=10*14*2;       % 10*22*1
        for popindex = 1:popsize
            W = population(popindex,1:10*Hno);
            B = population(popindex,10*Hno+1:dim);
            fitness = 0;
            for pp = 1:80
                actualvalue=my_DNM(10,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / 80;
            cost(popindex) = fitness;
        end
    case 24
        load Cancer.txt
        x=Cancer;
        H2=x(1:699,2:11);
        for iii=1:699
            for jjj=1:10
                H2(iii,jjj)=((H2(iii,jjj)-1)/9);
            end
        end
        I2=H2(1:699,1:9);
        T=H2(1:699,10);
        Hno=12;
        dim=2*9*12;
        for popindex = 1:popsize
            W = population(popindex,1:9*Hno);
            B = population(popindex,9*Hno+1:dim);
            fitness = 0;
            for pp = 1:599
                actualvalue=my_DNM(9,Hno,1,W,B,I2(pp,:));
                fitness=fitness+(T(pp)-actualvalue)^2;
            end
            fitness = fitness / 599;
            cost(popindex) = fitness;
        end
    case 22
        load Baloon.txt
        input = Baloon(:,1:4);
        out = Baloon(:,5);
        
        Hno=7;
        dim=4*7*2;
        for popindex = 1:popsize
            W = population(popindex,1:4*Hno);
            B = population(popindex,4*Hno+1:dim);
            fitness = 0;
            for pp = 1:20
                actualvalue=my_DNM(4,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / 20;
            cost(popindex) = fitness;
        end
    case 221
        load MackeyGlass
        a = mapminmax(MackeyGlass',0,1);
        trainboundary = 450;
        dend = 981;
        input = zeros(dend,4);
        out = zeros(dend);
        for i= 1: dend
            input(i,1) = a(i);
            input(i,2) = a(i+6);
            input(i,3) = a(i+12);
            input(i,4) = a(i+18);
            out(i) = a(i+19);
        end
        Hno=12;
        dim=4*12*2;
        for popindex = 1:popsize
            W = population(popindex,1:4*Hno);
            B = population(popindex,4*Hno+1:dim);
            fitness = 0;
            for pp = 1:trainboundary
                actualvalue=my_DNM(4,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / trainboundary;
            cost(popindex) = fitness;
        end
    case 223
        load eegdata_task1
        a = mapminmax(eegdata_task1(1,:),0,1);  %һ
        
        trainboundary = 1000;  %ѵ
        dend = 2492;           %ܹ
        
        %
        input = zeros(dend,4);  % dend  4
        out = zeros(dend);
        for i= 1: dend
            input(i,1) = a(i);
            input(i,2) = a(i+4);
            input(i,3) = a(i+6);
            input(i,4) = a(i+7);
            out(i) = a(i+8);
        end
        Hno=12;
        dim=4*12*2;       % 4*15*1
        for popindex = 1:popsize
            W = population(popindex,1:4*Hno);
            B = population(popindex,4*Hno+1:dim);
            fitness = 0;
            for pp = 1:trainboundary
                actualvalue=my_DNM(4,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / trainboundary;
            cost(popindex) = fitness;
        end
    case 222
        load BoxJenkins
        a = mapminmax(BoxJenkins',0,1);  %һ
        
        trainboundary = 140;  %ѵ
        dend = 292;           %ܹ
        
        %
        input = zeros(dend,2);  % dend  4
        out = zeros(dend);
        for i= 1: dend
            input(i,1) = a(1,i+3);
            input(i,2) = a(2,i);
            out(i) = a(1,i+4);
        end
        
        Hno=15;
        dim=2*15*2;       % 2*15*1
        for popindex = 1:popsize
            W = population(popindex,1:2*Hno);
            B = population(popindex,2*Hno+1:dim);
            fitness = 0;
            for pp = 1:trainboundary
                actualvalue=my_DNM(2,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / trainboundary;
            cost(popindex) = fitness;
        end
    case 27
        input = 1.25:0.05:2.75;
        for i= 1:31
            buff(i) = fitfun_cosine( input(i) );
        end
        out = mapminmax(buff,0,1); % 鵽0-1
        
        Hno=23;
        dim=1*23*2;       % 1*15*1
        for popindex = 1:popsize
            W = population(popindex,1:1*Hno);
            B = population(popindex,1*Hno+1:dim);
            fitness = 0;
            for pp = 1:31
                actualvalue=my_DNM(1,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / 31;
            cost(popindex) = fitness;
        end
    case 210
        [in_x in_y] = meshgrid(-5:0.5:5 , -5:0.5:5 );
        buff(21,21)=0;
        for m= 1:21
            for n = 1:21
                buff(m,n) = fitfun_griewank( in_x(m,n) , in_y(m,n) );
            end
        end
        out = buff/2; % 鵽0-1  úԭķΧ0-2
        
        Hno=15;
        dim=2*15*2;
        for popindex = 1:popsize
            W = population(popindex,1:2*Hno);
            B = population(popindex,2*Hno+1:dim);
            fitness = 0;
            for p1 = 1:21                  % ѵݸ
                for p2 = 1:21
                    actualvalue = my_DNM(2,Hno,1,W,B,[in_x(p1,p2) ,in_y(p1,p2) ] );  %
                    fitness=fitness+(out(p1,p2)-actualvalue)^2;
                end
            end
            fitness = fitness / (21*21);
            cost(popindex) = fitness;
        end
    case 211
        x1 = -5:3:5;
        x2 = -5:3:5;
        x3 = -5:3:5;
        x4 = -5:3:5;
        x5 = -5:3:5;
        buff(4,4,4,4,4) = 0;
        for a=1:4
            for b=1:4
                for c=1:4
                    for d=1:4
                        for e=1:4
                            buff(a,b,c,d,e) = fitfun_rosenbrock([x1(a),x2(b),x3(c),x4(d),x5(e)]);
                        end
                    end
                end
            end
        end
        out = buff/120; % 鵽0-1  úԭķΧ0-120
        
        
        Hno=9;
        dim=5*9*2;       % 5*15*1
        for popindex = 1:popsize
            W = population(popindex,1:5*Hno);
            B = population(popindex,5*Hno+1:dim);
            fitness = 0;
            for a=1:4
                for b=1:4
                    for c=1:4
                        for d=1:4
                            for e=1:4
                                actualvalue = my_DNM(5,Hno,1,W,B,[x1(a),x2(b),x3(c),x4(d),x5(e)] );  %
                                fitness=fitness+(out(a,b,c,d,e)-actualvalue)^2;
                            end
                        end
                    end
                end
            end
            fitness = fitness / 1024;
            cost(popindex) = fitness;
        end
    case 26
        input = -3:0.1:3;
        for i= 1:61
            out(i) = fitfun_sigmoid( input(i) );
        end
        
        Hno=10;
        dim=1*10*2;
        for popindex = 1:popsize
            W = population(popindex,1:1*Hno);
            B = population(popindex,1*Hno+1:dim);
            fitness = 0;
            for pp = 1:61
                actualvalue=my_DNM(1,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / 61;
            cost(popindex) = fitness;
        end
    case 28
        input = -2*pi:0.1:2*pi;
        for i= 1:126
            buff(i) = fitfun_sine( input(i) );
        end
        out = mapminmax(buff,0,1); % 鵽0-1
        
        Hno=23;
        dim=1*23*2;
        for popindex = 1:popsize
            W = population(popindex,1:1*Hno);
            B = population(popindex,1*Hno+1:dim);
            fitness = 0;
            for pp = 1:126
                actualvalue=my_DNM(1,Hno,1,W,B,input(pp,:));
                fitness=fitness+(out(pp)-actualvalue)^2;
            end
            fitness = fitness / 126;
            cost(popindex) = fitness;
        end
    case 29
        
        [in_x in_y] = meshgrid(-2:0.2:2 , -2:0.2:2 );
        for m= 1:21
            for n = 1:21
                buff(m,n) = fitfun_sphere( in_x(m,n) , in_y(m,n) );
            end
        end
        out = buff/8; % 鵽0-1  úԭķΧ0-8
        
        Hno=15;
        dim=2*15*2;
        for popindex = 1:popsize
            W = population(popindex,1:2*Hno);
            B = population(popindex,2*Hno+1:dim);
            fitness = 0;
            for p1 = 1:21                  % ѵݸ
                for p2 = 1:21
                    actualvalue = my_DNM(2,Hno,1,W,B,[in_x(p1,p2) ,in_y(p1,p2) ] );  %
                    fitness=fitness+(out(p1,p2)-actualvalue)^2;
                end
            end
            fitness = fitness / (21*21);
            cost(popindex) = fitness;
        end
    otherwise
end
end

