clear;
clc;
tic;
%  inputs:
% N:  Number of agents.
% max_it: Maximum number of iterations (T).
% ElitistCheck: If ElitistCheck=1, algorithm runs with eq.21 and if =0, runs with eq.9.
% Rpower: power of 'R' in eq.7.
% F_index: The index of the test function. See tables 1,2,3 of the mentioned article.
%          Insert your own objective function with a new F_index in 'test_functions.m'
%          and 'test_functions_range.m'.
%  outputs:
% Fbest: Best result.
% Lbest: Best solution. The location of Fbest in search space.
% BestChart: The best so far Chart over iterations.
% MeanChart: The average fitnesses Chart over iterations.

N=100;
max_it=3000;
ElitistCheck=1;
Rpower=1;%RĴη
min_flag=1; % 1: minimization, 0: maximization
limit = 2;
p = 0.5;

for problem = [1,3:30]
    disp('run');
    P_index = problem;
    fhd = str2func('cec17_func');
    FbestChart=[];
    for t=1:30
        num = 0;
        [Fbest,BestChart]=GSA(fhd,N,max_it,ElitistCheck,min_flag,Rpower,P_index,limit,p);
        FbestChart=[FbestChart,BestChart];
        disp(['problem',num2str(problem),'-run',num2str(t)]);
    end
    
%     Mean=mean(FbestChart(max_it,:),2);
%     Std =std(FbestChart(max_it,:),0,2);
%     name = ['GSA theta 2 ' num2str(limit) ' ' num2str(p) '.xlsx'];
%     path = ['E:\Evolutionary Computation\GSA\Data\' name];
%     xlswrite(path,FbestChart,['Sheet',num2str(problem)]);
%     xlswrite(path,Mean,['Sheet',num2str(problem)],'A3002');
%     xlswrite(path,Std,['Sheet',num2str(problem)],'B3002');
end
toc;



