warning off all

clear all
clc
% mex cec17_func.cpp -DWINDOWS


n_p = 100;    % population size
n_d = 30;    % dimension
n_c = 5;    % number of clusters

for problem = 1:28;
    
    tic;
    
    varargin{:}=problem;
    
    fhd=str2func('cec13_func');
    
    rang_l = -100;
    
    rang_r = 100;
    
    max_iteration = 3000;    % maximal number of iterations
    
    FbestChart=[];
    
%     pdelta = 0.2;
    
%     a = 0.99;
    
    for t = 1:30 % run times
        
        prob_one_cluster = 0.8; % probability for select one cluster to form new individual;
        
        stepSize = ones(1,n_d); % effecting the step size of generating new individuals by adding random values
        popu = rang_l + (rang_r - rang_l) * rand(n_p,n_d); % initialize the population of individuals
        
        popu_sorted  = rang_l + (rang_r - rang_l) * rand(n_p,n_d); % initialize the  population of individuals sorted according to clusters
        
        n_iteration = 0; % current iteration number
        
        % initialize cluster probability to be zeros
        prob = zeros(n_c,1);
        
        best = zeros(n_c,1);  % index of best individual in each cluster
        
        centers = rang_l + (rang_r - rang_l) * rand(n_c,n_d);  % initialize best individual in each cluster
        centers_copy = rang_l + (rang_r - rang_l) * rand(n_c,n_d);
        % initialize best individual-COPY in each cluster FOR the purpose of introduce random best
        
        best_fitness = 1000000*ones(max_iteration,1); % store fitness value for each individual
        fitness_popu_sorted = 1000000*ones(n_p,1);  % store  fitness value for each sorted individual
        fv = 1000000*ones(n_p,1);%1000000
        
        indi_temp = zeros(n_p,n_d);  % store temperary individual
        
        % calculate fitness for each individual in the initialized population
        fitness_popu=feval(fhd,popu',varargin{:});
        fitness_popu=fitness_popu';
        
        FES = 0;
        
        temIdx = 0;
        
                %Record the number of success or failure
                index=4;
                ns = [];
                ns_total = [];
                select=zeros(1, n_p);
                pfit = ones(1, index);
                normfit=zeros(1,index);
                LEP=50;
                delta = 1;
%                 delta_LEP = n_p;
        
        while FES < n_d*10000;
            %%
                        aaaa = cell(1, index);
                        ccm = 0.5 * ones(1, index);
            %%
            cluster = kmeans(popu, n_c,'Distance','cityblock','Start',centers,'EmptyAction','singleton'); % k-mean cluster give each individual a cluster number
            
            % clustering
            fit_values = 10^55*ones(n_c,1);%100000000000000000000000000
            % assign a initial big fitness value  as best fitness for each cluster in minimization problems
            number_in_cluster = zeros(n_c,1);  % initialize 0 individual in each cluster
            
            for idx = 1:n_p
                number_in_cluster(cluster(idx,1),1)= number_in_cluster(cluster(idx,1),1) + 1;
                
                % find the best individual in each cluster
                if fit_values(cluster(idx,1),1) > fitness_popu(idx,1)  % minimization    fit_values and best store the fitness and population of cluster centers
                    fit_values(cluster(idx,1),1) = fitness_popu(idx,1);
                    best(cluster(idx,1),1) = idx;
                end
                
            end
            
            % form population sorted according to clusters
            counter_cluster = zeros(n_c,1);  % initialize cluster counter to be 0
            
            acculate_num_cluster = zeros(n_c,1);  % initialize accumulated number of individuals in previous clusters
            %
            for idx =2:n_c
                acculate_num_cluster(idx,1) = acculate_num_cluster((idx-1),1) + number_in_cluster((idx-1),1);
            end
            
            %
            %     %start form sorted population
            for idx = 1:n_p
                counter_cluster(cluster(idx,1),1) = counter_cluster(cluster(idx,1),1) + 1 ;
                temIdx = acculate_num_cluster(cluster(idx,1),1) +  counter_cluster(cluster(idx,1),1);
                popu_sorted(temIdx,:) = popu(idx,:);
                fitness_popu_sorted(temIdx,1) = fitness_popu(idx,1);
            end
            
            % record the best individual in each cluster
            for idx = 1:n_c
                centers(idx,:) = popu(best(idx,1),:);
            end
            
            centers_copy = centers;  % make a copy
            
            if (rand() < 0.2) %  select one cluster center to be replaced by a randomly generated center
                cenIdx = ceil(rand()*n_c);
                centers(cenIdx,:) = rang_l + (rang_r - rang_l) * rand(1,n_d);
            end
            
            %calculate cluster probabilities based on number of individuals in each cluster  
            for idx = 1:n_c
                prob(idx,1) = number_in_cluster(idx,1)/n_p;
                if idx > 1
                    prob(idx,1) = prob(idx,1) + prob(idx-1,1);
                end
            end
            
            %%
                        if (n_iteration >= LEP)
                            for i = 1:index
                                if  ~isempty(aaaa{i})
                                    ccm(i) = median(aaaa{i}(:, 1));
                                    d_index = find(aaaa{i}(:, 2) == aaaa{i}(1, 2));
                                    aaaa{i}(d_index, :) = [];
                                else
                                    ccm(i) = rand;
                                end
                            end
                        end
            
                        for i = 1 : index
                            cc_tmp = [];
                            for k = 1 : n_p
                                tt = normrnd(ccm(i), 0.1);
                                while tt > 1 || tt < 0
                                    tt = normrnd(ccm(i), 0.1);
                                end
                                cc_tmp = [cc_tmp; tt];
                            end
                            cc(:, i) = cc_tmp;
                        end
            
                        % Stochastic universal sampling
                        for idx = 1:n_p
                            rr = rand;
                            j=1;
                            partsum = 0;
                            for i=1:index;
                                normfit(i) = pfit(i) / sum(pfit);
                            end
                            while partsum<rr;
                                partsum = partsum + normfit(j);
                                j=j+1;
                            end
                            select(idx)=j-1;
                        end
            
                        for i = 1 : index
                            atemp = zeros(1, n_p);
                            aaa{i} = atemp;
                            numst{i} = [];
                            if ~isempty(find(select == i, 1))
                                numst{i} = find(select == i);
                                atemp(numst{i}) = 1;
                                aaa{i} = atemp;
                            end
                        end
            
            %% generate n_p new individuals by adding Gaussian random values
            for idx = 1:n_p
                r_1 = rand();  % probability for select one cluster to form new individual
                if r_1 < prob_one_cluster % select one cluster            P6b
                    r = rand();
                    for idj = 1:n_c
                        if r < prob(idj,1)    %randomly choose a cluster  P6bi
                            if rand() < 0.4  % use the center             P6biii
                                indi_temp(idx,:) = centers(idj,:);
                            else % use one randomly selected  cluster
                                indi_1 = acculate_num_cluster(idj,1) + ceil(rand() * number_in_cluster(idj,1));
                                indi_temp(idx,:) = popu_sorted(indi_1,:);
                            end
                            break
                        end
                    end
                else % select two clusters
                    % pick two clusters
                    cluster_1 = ceil(rand() * n_c);
                    indi_1 = acculate_num_cluster(cluster_1,1) + ceil(rand() * number_in_cluster(cluster_1,1));
                    
                    cluster_2 = ceil(rand() * n_c);
                    indi_2 = acculate_num_cluster(cluster_2,1) + ceil(rand() * number_in_cluster(cluster_2,1));
                    
                    tem = rand();
                    
                    if rand() < 0.5 %use center
                        indi_temp(idx,:) = tem * centers(cluster_1,:) + (1-tem) * centers(cluster_2,:);
                    else   % use randomly selected individuals from each cluster
                        indi_temp(idx,:) = tem * popu_sorted(indi_1,:) + (1-tem) * popu_sorted(indi_2,:);
                    end
                end
                
                
                %0.5
%                 if pdelta == 0.2
%                     delta = delta;
%                 elseif pdelta>0.2
%                     delta = delta/a;
%                 else delta = delta*a;
%                 end
                
                                % Strategy selection
                                if select(1, n_p)==1;
                                    stepSize = logsig(((0.5*max_iteration - n_iteration)/10)) * rand(1,n_d);
                                    indi_temp(idx,:) = indi_temp(idx,:) + stepSize .* normrnd(0,delta,1,n_d);%1.5
                                end
                
                                if select(1, n_p)==2;
                                    stepSize = logsig(((0.5*max_iteration - n_iteration)/20)) * rand(1,n_d);
                                    indi_temp(idx,:) = indi_temp(idx,:) + stepSize .* normrnd(0,delta,1,n_d);
                                end
                
                                if select(1, n_p)==3;
                                    stepSize = logsig(((0.5*max_iteration - n_iteration)/30)) * rand(1,n_d);
                                    indi_temp(idx,:) = indi_temp(idx,:) + stepSize .* normrnd(0,delta,1,n_d);
                                end
                                 
                                if select(1, n_p)==4;
                                    stepSize = logsig(((0.5*max_iteration - n_iteration)/40)) * rand(1,n_d);
                                    indi_temp(idx,:) = indi_temp(idx,:) + stepSize .* normrnd(0,delta,1,n_d);
                                end
                
                %Judge whether cross the border
                tp = indi_temp(idx,:)>rang_r;
                tm = indi_temp(idx,:)<rang_l;
                indi_temp(idx,:) = (indi_temp(idx,:) .* (~(tp+tm))) + rang_r .* tp + rang_l .* tm;
                
            end
            %%
                        lpcount = zeros(1,index);
%                         npcount = zeros(1,index);
            
%                         delta_memory = zeros(delta_LEP,1);
                        
                        % if better than the previous one, replace it            
                        fv = feval(fhd,indi_temp',varargin{:});
                        fv = fv';
                        for i = 1:n_p;
                            difference = abs(fv(i)-fitness_popu(i));
                            if fv(i) < fitness_popu(i)  % better than the previous one, replace
                                fitness_popu(i) = fv(i);
                                popu(i,:) = indi_temp(i,:);
            %
                                %delta_memory(i) = 1;
                                tlpcount = zeros(1, index);
                                for j = 1 : index
                                    temp = aaa{j};
                                    tlpcount(j) = temp(i);
                                    if tlpcount(j) == 1
                                        aaaa{j} = [aaaa{j}; cc(i, j) n_iteration];
                                    end
                                end
                                lpcount(i,:) = tlpcount*difference;                         
                            end
                        end
   
                        ns = [ns; sum(lpcount, 1)];
%                         nf = [nf; sum(npcount, 1)];
                   %     ns_total = [ns_total; sum(lpcount, 1)];

                        
%                         pdelta = sum(delta_memory)/delta_LEP;

                        % success and failure memory
                        if n_iteration > LEP;
                            for i = 1 : index
%                                 if (sum(ns(:, i)) + sum(nf(:, i))) == 0
                                if sum(ns(:, i)) == 0
                                    pfit(i) = 0.0000001;%to avoid the possible null success rates
                                else
%                                     pfit(i) = sum(ns(:, i)) / (sum(ns(:, i)) + sum(nf(:, i)))+0.0000001 ;
                                    pfit(i) = sum(ns(:, i)) / sum(ns(:, i)) +0.0000001 ;
                                end
                            end
                            if ~isempty(ns), ns(1, :) = [];  end
%                             if ~isempty(nf), nf(1, :) = [];  end%progress if memories overflow after LEP generations
                        end
            %%
            
            FES = FES + n_p;
            n_iteration = n_iteration +1;
            % record the best fitness in each iteration
            best_fitness(n_iteration, 1) = min(fit_values);
        end

        ['run', num2str(t)]
        
        FbestChart=[FbestChart,best_fitness];
        
        
    end
    
    toc;
    xlswrite(['C:\Users\Desktop\ADMBSO 13 10.xlsx'],FbestChart,['Sheet',num2str(problem)]);
    xlswrite(['C:\Users\Desktop\ADMBSO 13 10.xlsx'],mean(FbestChart(max_iteration,:)),['Sheet',num2str(problem)],'A3002');
    xlswrite(['C:\Users\Desktop\ADMBSO 13 10.xlsx'],std(FbestChart(max_iteration,:)),['Sheet',num2str(problem)],'B3002');
end



