clc;
clear
tic;
format long;
format compact;
% classification'1: XOR' '2: Balloon' '3: Iris' '4: Cancer' '5: Heart'
% approximation '6: Sigmoid'  '7: Cosine' '8: Sine' '9: Sphere' '10: Rosenbrock' '11: Griewank'
% prediction '12: MackeyGlass' '13: EEG' '14: BoxJenkins'
%% read data
problem ='Exactly';
algorithmDir='BBO_DNM';
disp(['The current running problem: ',num2str(problem)]);

[train_data,train_target,test_data,test_target] = read_data(problem);
imgPath = ['ROC'];
mkdir(imgPath);

[I,J] = size(train_data);

train_len = length(train_target);
% valid_len = train_len;
test_len = length(test_target);

%% Hyper-parameters
M =10;
qs = 0.9;
k = 5;

%% The parameter of DE
popsize = 100; % the size of population
D = J * M * 2; % the dimension of sample
F = 0.5; % scaling factor
CR = 0.9; % crossover rate
iter =300;
AUC=[];
Sensitivity=[];
Specificity=[];
%% parameter structure
Parameter.F = F;
Parameter.CR = CR;
Parameter.popsize = popsize;
Parameter.D = D;
Parameter.iter = iter;
% Parameter.problem_name = problem_name;
net.M = M;
net.qs = qs;
net.k = k;
maxrun = 30;
BestChart = zeros(1,maxrun);
for runnum = 1:maxrun
    
    %% train
    [w,q,best,out{runnum}] = bbotrain(Parameter,net,train_data,train_target);
    net.w = w;
    net.q = q;
    %% test
    test_fit=my_DNM(test_data,net);
    test_fit=round(test_fit);
    count=length(find(test_fit == test_target));
    acc(runnum,1) = count / test_len;
    out{runnum}.testacc= acc(runnum,1) ;
    disp(['problem:',problem,'|rumtimes=',num2str(runnum),'|test_accuract=',num2str( acc(runnum,1))]);
    [auc(runnum,1), sensitivity, specificity] = plot_roc(test_fit, test_target, imgPath, algorithmDir, problem, runnum);
    AUC = [AUC, auc(runnum,1)];
    Sensitivity = [Sensitivity, sensitivity];
    Specificity = [Specificity, specificity];
    AUC_Sensitivity_Specificity = [AUC; Sensitivity; Specificity];
end

save   BBO_Exactly.mat out
disp(mean(acc))
disp(std(acc))

toc;

function [auc, sensitivity, specificity] = plot_roc(deci, label_y, imgPath, algorithmDir, problem_name, runtimes)
[val,ind] = sort(deci,'descend');
roc_y = label_y(ind);
stack_x = cumsum(roc_y == 0)/sum(roc_y == 0);
stack_y = cumsum(roc_y == 1)/sum(roc_y == 1);
auc = sum((stack_x(2:length(roc_y),1)-stack_x(1:length(roc_y)-1,1)).*stack_y(2:length(roc_y),1));
plot(stack_x,stack_y);
xlabel('False Positive Rate');
ylabel('True Positive Rate');
title(['ROC curve of (AUC = ' num2str(auc) ' )']);
TP = sum((roc_y==1)&(val==1));
TN = sum((roc_y==0)&(val==0));
FN = sum((roc_y==1)&(val==0));
FP = sum((roc_y==0)&(val==1));
sensitivity = TP / (TP + FN);
specificity = TN / (TN + FP);
saveas(gcf,[[imgPath '/'],algorithmDir,'_',problem_name,'time',num2str(runtimes) '.png']);
saveas(gcf,[[imgPath '/'],algorithmDir,'_',problem_name,'time',num2str(runtimes) '.fig']);
end


