function [Fbest,BestChart,BestFitness,farmlayout,farmlayout_NA]=RDE(popsize,wf,iterations,NA_type,tn,wt,t) 
    BestChart=zeros(iterations,1);
    BestFitness=zeros(iterations,1);
    farmlayout = zeros(iterations,wf.rows*wf.cols);
    farmlayout_NA = zeros(iterations,wf.rows*wf.cols);
    pop_power = zeros(popsize,wf.cols * wf.rows);
    
    D = wf.turbine_num; down = 1;up = wf.rows *wf.cols;
    
    % Population initialization
    [popu,lu] = windfarm_init(popsize, wf.turbine_num,wf);
    % Population evaluation
    [popuFitness,power_order,lp_power_accum]= wf_fitness(wf,popu);
    optimal = max(popuFitness);
    for i = 1:popsize
        pop_power(i,power_order(i,:))  = pop_power(i,power_order(i,:)) + (lp_power_accum(i,:) / sum(lp_power_accum(i,:)));
    end

   %% Local parameters setting
    vel = zeros(popsize, D);
    pBest = popu;
    pBestFit = popuFitness;
    pBest_power = power_order;
    [~, gBestId] = max(pBestFit);
    gBest = pBest(gBestId,:);
    gBest_fitness = pBestFit(gBestId);
    old_gBest_fitness = gBest_fitness;
    gBest_power = pBest_power(gBestId,:);
    omega = 0.7298;
    c = 1.49618;
    flag = zeros(popsize,1);
    sg = 7;
    pm = 0.01;
    count = 0;
    pfit = ones(1, 12);
    LEP = 25;
    success_num =zeros(LEP,12);
    fail_num = zeros(LEP,12);
    temp_lep = 1;
    F = 0.5;
    CR = 0.05;
    num_not_update = 0;
    CR = 0.1;
    for iter = 1:iterations
        pjd = iter/iterations;
        p = 0.5;% + 0.3*(pjd);
%         p = 0.5*(1+pjd);
%         F = F*2^(1 ./ (1 + exp(-iterations/(iterations+1-iter)));
        self_sy = 2^exp(1-iterations/(iterations+1-iter));
%         p = 0.5 * self_sy;
        F = 0.5 * self_sy;
%         F = 0.5*(1-pjd);
%         F=0.5;

        CR = 0.1*pjd;%0.5;%0.001*self_sy;


        % 获取前一半
        [AllFitnessSorted,IndexSorted] = sort(popuFitness,'descend');
        N = popsize;
        N_half = round(N/2);
        index = floor(p*N_half);
        gBest = popu(IndexSorted(1),:);
        pBest = popu(IndexSorted(1:10),:);

        goodPops=popu(IndexSorted(1:N_half),:);
        goodPopsIdx = IndexSorted(1:N_half); % 对应的原始编号
        worstPops=popu(IndexSorted(N_half+1:N),:);
        worstPopsIdx = IndexSorted(N_half+1:N); % 对应的原始编号
        
        a = randperm(N_half);
        b = randperm(N_half);
        % c = randperm(N_half);
        % d = randperm(N_half);


        gP = goodPops(a,:);
        % gPIdx = goodPopsIdx(c); % 对应的原始编号


        gp1 = gP(1:index,:);  % 好的前index个
        % gp1Idx = gPIdx(1:floor(0.95*N_half)); % 对应的原始编号
        gp2 = gP(index+1:N_half,:); % 好的后N_half-index个
        % gp2Idx = gPIdx(index+1:N_half); % 对应的原始编号

        wP = worstPops(b,:);
        % wPIdx = worstPopsIdx(d); % 对应的原始编号

        wp1 = wP(1:N_half-index, :); % 差的前N_half-index个
        % wp1Idx = wPIdx(1:N_half-floor(0.05*N_half)); % 对应的原始编号
        wp2 = wP(N_half-index+1:N_half, :); % 差的后index个
        % wp2Idx = wPIdx(N_half-index+1:N_half); % 对应的原始编号

        V_pops = [gp1;wp1];
        % V_popsIdx = [gp1Idx; wp1Idx]; % V_pops 对应的原始编号
        
        U = [gp2;wp2];
        % UIdx = [gp2Idx; wp2Idx]; % U 对应的原始编号
            % Get indices for mutation
        [r1, r2, r3] = getindex(N_half);
             % Implement DE/rand/1 mutation
        % V = V_pops(r1, :) + F * (V_pops(r2, :) - V_pops(r3, :));
%         V = V_pops(r1, :) + F * (V_pops(r2, :)  - U(r3, :));
        V = V_pops(r1, :) + F * (V_pops(r2, :)  - U(r3, :));
%         V = pBest(floor(rand*3)+1, :) + F * (V_pops(r2, :) - U(r3, :));
%           V = V_pops(r1, :) + F * (V_pops(r2, :) - U(r3, :));
%         V = gBest + F * (V_pops(r2, :) - U(r3, :));
            % Check whether the mutant vector violates the boundaries or not
%         [V] = BoundaryDetection(V,lu);
            % Implement binomial crossover
            
        for i = 1:N_half
            j_rand = floor(rand * D) + 1;
            tt = rand(1, D) < CR;
            tt(1, j_rand) = 1;
%             tt = tt .* rand(1, D) * CR;
            t_ = 1 - tt;
            U(i, :) = tt .* V(i, :) + t_ .* pBest(floor(rand*5)+1, :);%V_pops(i, :);
%             U(i, :) = tt .* U(i, :) + t_ .* V(i, :);
            %X(IndexSorted(i), :) = t .* V(i, :) + t_ .* X(IndexSorted(i), :);
        end
        
       %% Boundary detection
        U = windfarm_constraint(U, wf.NA_loc, D,down,up);
        [fit_U,power_order,lp_power_accum] = wf_fitness(wf, U);
        
        % get bsf_fit_var
        for i = 1:N_half
            if fit_U(i) > gBest_fitness
                gBest_fitness = fit_U(i);
                % num_not_update =  0;
%                 CR = 0.1;
            end
            % popu_num = IndexSorted(N_half+i); % 差种群个体的编号
            popu_num = IndexSorted(i); % 优秀种群个体的编号
            % popu_num = i;
            % popu_num = V_popsIdx(i);  % 优秀种群V_pops个体的编号
            if fit_U(i, :) >= popuFitness(popu_num, :)
                popu(popu_num, :) = U(i, :);
                popuFitness(popu_num, :) = fit_U(i, :);
            end
        end
        % 
        % % 提取popu中的前一半优秀个体
        % goodPops = popu(IndexSorted(1:N_half), :);
        % goodPopsFitness = popuFitness(IndexSorted(1:N_half));
        % 
        % % 将新的种群U与前一半优秀个体合并
        % combinedPops = [goodPops; U];
        % combinedFitness = [goodPopsFitness; fit_U];
        % 
        % % 对合并后的种群按照适应度进行排序
        % [AllCombinedFitnessSorted, CombinedIndexSorted] = sort(combinedFitness, 'descend');
        % 
        % % 提取排序后的前一半个体作为新的优秀个体
        % newGoodPops = combinedPops(CombinedIndexSorted(1:N_half), :);
        % 
        % % 更新popu的前一半个体
        % popu(IndexSorted(N_half+1:N), :) = newGoodPops;


        % if (old_gBest_fitness == gBest_fitness)
        %     num_not_update = num_not_update+1;
        % else
        %     old_gBest_fitness = gBest_fitness;
        % end
        
        %% Evaluatition
        if max(popuFitness) > optimal
            optimal = max(popuFitness);
        else
            count = count +1;
        end
   
        %% Survival
    
        Fbest = gBest_fitness;
        BestChart(iter) = gBest_fitness / wf.power_total;
        BestFitness(iter) = gBest_fitness;
        [best_farmlayout,best_farmlayout_NA]  = gene_layout_by_indices_one(wf,gBest);
        farmlayout(iter,:) = best_farmlayout;
        farmlayout_NA(iter,:) = best_farmlayout_NA;
        fprintf('NA %d Turbine Num:%d Wind %s run: %d iteration: %d  eta %f fitness %f CR %f F %f sit %f\n',NA_type,tn,wt,t,iter,(Fbest / wf.power_total),Fbest, CR, F, self_sy)
    end

end