clc;
clear all;

tic;

format long;
format compact;

% The test suit. Note that the seventeenth problem should be initialized
% within the search space, however, its optimum is out of the search space.
% As a result, the repair operator is not necessary under this condition.



%problem = problemSet(problemIndex)
for  problem = [1 3:30]
    
    varargin{:}=problem;
    
    fhd=str2func('cec17_func');
    
    FbestChart=[];
    % Set the number of variables
    D = 30;
    
    % Set the population size
    popsize = 100;
    
    % Set the number of runs
    totalTime = 30;
    
    % Set the scaling factor and crossover control parameter of DE
    F = 0.5;
    CR = 0.9;
    
    %get the boundary of test functions
    lb = -100;
    ub = 100;
    
    % Record the best results
    outcome = [];
    con_all=[];
    fit=zeros(popsize,1);
    
    % Main body
    time = 1;
    %     maxit = 1500;
    while time <= totalTime
        time            
        count_current = zeros(popsize,1);
        convergence=[];
        fit_all = [];
        iteration = 0;
        
        % Initialize the population
        pop =lb + (ub - lb) * rand(popsize, D);
        
        % Evaluate the population
        fit=feval(fhd,pop',varargin{:});
        fit=fit';
        
        % Compute the number of FES
        FES = 0;count_total = zeros(popsize,1);count_success = zeros(popsize,1);
        
        while FES < D * 10000

            
            if iteration>5 && std(convergence((iteration-5):iteration))==0
                re_de = 0;
            else
                re_de = 1;
            end
            
            
            %          while iteration<maxit
            
            % index_ox: indices for orthogonal crossover
            %index_ox = randi([1, popsize], [1, 1]);
            
            % index_nox: indices for binomial crossover
            %             index_nox = 1 : popsize;
            %index_nox(index_ox) = [];
            
            % V: the set of mutant vectors
            % U: the set of trial vectors
            % fit_U: the set of objective function values of trial vectors
            V = pop;
            U = pop;
            fit_U = fit;
            
            % Get indices for mutation
            [r1, r2, r3, r4] = getindex(popsize);
            
            [value,j]=min(fit);   
            index_j=repmat(j,1,100);
            
            % Implement DE/rand/1 mutation
%             V = pop(r1, :) + F * (pop(r2, :) - pop(r3, :));
%             Implement DE/best/1 mutation
            V = pop(index_j, :) + F * (pop(r2, :) - pop(r3, :));
%             Implement DE/best/2 mutation
%               V = pop(index_j, :) + F * (pop(r1, :) - pop(r2, :) + pop(r3, :) - pop(r4, :));
%             Implement DE/rand-to-best/1 mutation
%               V = pop(r1, :) + F * (pop(index_j, :) - pop(r2, :) + pop(r3, :) - pop(r4, :));              
            
            % Check whether the mutant vector violates the boundaries or not
            V = repair(V, lb,ub);
            

            
            % Implement binomial crossover
            for i = 1:popsize
                
                if  re_de == 0 && i~=j
                    radius=V(i,:) - pop(j,:);%run away from the population best
                    U(i,:) = V(i,:) + (rand(1,1)-0.3) * radius;    %Chaos_p(c_j,c_d)
                 
                    
   
                else
                    j_rand = floor(rand * D) + 1;
                    t = rand(1, D) < CR;
                    t(1, j_rand) = 1;
                    t_ = 1 - t;
                    U(i, :) = t .* V(i, :) + t_ .* pop(i, :);
                end
                
                % Evaluation the trial vectors which are generated by binomial crossover
                %             fit_U(i,:) =  benchmark_func(U(i,:), problem);
            end

            fit_U=feval(fhd,U',varargin{:});
            fit_U=fit_U';
            
            FES = FES + popsize;
            iteration = iteration + 1;
            
            % Select the better one between the target vector and its trial vector

                for i = 1:popsize
                    
                    if fit_U(i, :) <= fit(i, :)
                        
                        pop(i, :) = U(i, :);
                        fit(i, :) = fit_U(i, :);

                    end
                    
                end

            convergence= [convergence; min(fit)];
            fit_all = [fit_all, fit];
        end
        

        outcome = [outcome min(fit)];
        
        time = time + 1;
        FbestChart=[FbestChart, convergence];

    end
    toc;
    xlswrite(['C:\Users\Desktop\DEGLS 17 best1 0.3.xlsx'],FbestChart,['Sheet',num2str(problem)]);
    xlswrite(['C:\Users\Desktop\DEGLS 17 best1 0.3.xlsx'],mean(FbestChart(iteration,:)),['Sheet',num2str(problem)],'A3002');
    xlswrite(['C:\Users\Desktop\DEGLS 17 best1 0.3.xlsx'],std(FbestChart(iteration,:)),['Sheet',num2str(problem)],'B3002');
    
end

