function fit = fitness(p, problem, D, o, A, M)

popsize = size(p, 1);

switch problem

    case 1

        fit = sum(p.^2, 2);

    case 2
        
        fit = 100 * sum((p(:, 2:D) - (p(:, 1:D - 1)).^2).^2, 2) + sum((p(:, 1:(D - 1)) - 1).^2, 2);

    case 3

        fit = 20 + exp(1) - 20 * exp( - 0.2 * (1/D * sum(p.^2, 2)).^0.5) - exp(1/D * sum(cos(2 * pi * p), 2));

    case 4

        fit = sum(p.^2, 2)/4000 - prod(cos(p./(repmat(1:D, popsize, 1)).^0.5), 2) + 1;

    case 5

        fit = 10 * D + sum(p.^2 - 10 * cos(2 * pi * p), 2);

    case 6

        fit = 418.9828872724338 * D - sum(p .* sin((abs(p)).^0.5), 2);

    case 7

        fit =  -cos(2 * pi * (sum(p.^2, 2)).^0.5) + 0.1 * (sum(p.^2, 2)).^0.5 + 1;

    case 8

        temp1 = zeros(popsize, D * D);
        for i = 1:D
            temp1(:, (i - 1) * D + 1:i * D) = p(:, i) * ones(1, D);
        end
        temp2 = repmat(p, 1, D);
        A = 100 * (temp1 - temp2.^2).^2 + (1 - temp2).^2;
        fit = sum(A.^2/4000 - cos(A), 2) + D * D;
        
        clear temp1
        clear temp2

    case 9

        p_ = 1 + 1/4 * (p + 1);
        p_1 = p_(:, 1:D - 1);
        p_2 = p_(:, 2:D);
        p_3 = p;
        temp_1 = find(p>10);
        temp_2 = find(p< -10);
        temp_3 = find(p >= -10 & p <= 10);
        p_3(temp_1) = 100 * (p(temp_1) - 10).^4;
        p_3(temp_2) = 100 * ( -p(temp_2) - 10).^4;
        p_3(temp_3) = 0;
        fit = pi/D * (10 * (sin(pi * p_(:, 1))).^2 + sum((p_1 - 1).^2 .* (1 + 10 * (sin(pi * p_2)).^2), 2) + (p_(:, D) - 1).^2) + sum(p_3, 2);

    case 10

        p_1 = p(:, 1:D - 1);
        p_2 = p(:, 2:D);
        p_3 = p;
        temp_1 = find(p>5);
        temp_2 = find(p< - 5);
        temp_3 = find(p >= -5 & p <= 5);
        p_3(temp_1) = 100 * (p(temp_1) - 5).^4;
        p_3(temp_2) = 100 * ( -p(temp_2) - 5).^4;
        p_3(temp_3) = 0;
        fit = 0.1 * ((sin(pi * 3 * p(:, 1))).^2 + sum((p_1 - 1).^2 .* (1 + (sin(3 * pi * p_2)).^2), 2) + (p(:, D) - 1).^2 .* (1 + (sin(2 * pi * p(:, D))).^2)) + sum(p_3, 2);

    case 11

        [ps, D] = size(p);
        
        if length(o) >= D
            o = o(1:D);
        else
            o =  -100 + 200 * rand(1, D);
        end

        p = p - repmat(o, ps, 1);
        fit = sum(p.^2, 2);

    case 12

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -100 + 200 * rand(1, D);
        end
        
        p = p - repmat(o, ps, 1);
        fit = zeros(ps, 1);
        for i = 1:D
            fit = fit + sum(p(:, 1:i), 2).^2;
        end

    case 13

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -100 + 200 * rand(1, D);
        end        

        p = p - repmat(o, ps, 1);
        p = p * M;
        a = 1e+6;
        fit = zeros(ps, 1);
        for i = 1:D
            fit = fit + a.^((i - 1)/(D - 1)) .* p(:, i).^2;
        end

    case 14

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -100 + 200 * rand(1, D);
        end
        
        p = p - repmat(o, ps, 1);
        fit = zeros(ps, 1);
        for i = 1:D
            fit = fit + sum(p(:, 1:i), 2).^2;
        end
        fit = fit .* (1 + 0.4 .* abs(normrnd(0, 1, ps, 1)));

    case 15

        [ps, D] = size(p);

        if length(o) >= D
            A = A(1:D, 1:D);o = o(1:D);
        else
            o =  -100 + 200 * rand(1, D);
            A = round( - 100 + 2 * 100 .* rand(D, D));
            while det(A) == 0
                A = round( - 100 + 2 * 100 .* rand(D, D));
            end
        end
        o(1:ceil(D/4)) =  -100;o(max(floor(0.75 * D), 1):D) = 100;
        B = A * o';
        
        fit = zeros(ps, 1);

        for i = 1:ps
            fit(i, 1) = max(abs(A * (p(i, :)') - B));
        end

    case 16

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -90 + 180 * rand(1, D);
        end

        p = p - repmat(o, ps, 1) + 1;
        fit = sum(100 .* (p(:, 1:D - 1).^2 - p(:, 2:D)).^2 + (p(:, 1:D - 1) - 1).^2, 2);

    case 17

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -600 + 0 * rand(1, D);
        end
       
        o = o(1:D);

        p = p - repmat(o, ps, 1);
        p = p * M;
                
        fit = sum(p.^2, 2)./4000 - prod(cos(p./(repmat(1:n, ps, 1)).^0.5), 2) + 1;

    case 18

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -30 + 60 * rand(1, D);
        end
        o(2 .* [1:floor(D/2)] - 1) =  - 32;        

        p = p - repmat(o, ps, 1);
        p = p * M;
        fit = sum(p.^2, 2);
        fit = 20 - 20 .* exp( - 0.2 .* sqrt(fit./D)) - exp(sum(cos(2 .* pi .* p), 2)./D) + exp(1);

    case 19

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -5 + 10 * rand(1, D);
        end

        p = p - repmat(o, ps, 1);
        fit = sum(p.^2 - 10 .* cos(2 .* pi .* p) + 10, 2);

    case 20

        [ps, D] = size(p);

        if length(o) >= D
            o = o(1:D);
        else
            o =  -5 + 10 * rand(1, D);
        end       

        p = p - repmat(o, ps, 1);
        p = p * M;
        fit = sum(p.^2 - 10 .* cos(2 .* pi .* p) + 10, 2);

end
