import numpy as np
import numpy.matlib


class DNM(object):
    def __init__(self, M, M_SNU, qs, k, decay):
        self.M = M
        self.M_SNU = M_SNU
        self.qs = qs
        self.k = k
        self.decay = decay

    def load_datast(self, train_data, train_label, test_data, test_label):
        self.train_data = train_data
        self.train_label = train_label
        self.test_data = test_data
        self.test_label = test_label

    def init_param(self):
        self.q = np.zeros([self.M, self.data_dim])
        self.w = np.zeros([self.M, self.data_dim])

    @property
    def train_sample_num(self):
        return self.train_data.shape[0]

    @property
    def test_sample_num(self):
        return self.test_data.shape[0]

    @property
    def data_dim(self):
        return self.train_data.shape[1]

    def test(self):
        Q = np.zeros(self.test_sample_num)
        for h in range(self.test_sample_num):
            temp_data = np.matlib.repmat(self.test_data[h, :], self.M, 1)
            Y = 1 / (1 + np.exp(-self.k * (self.w * temp_data - self.q)))
            Z = np.prod(Y, 1)
            V = np.sum(Z)
            O = 1 / (1 + np.exp(-self.k * (V - self.qs)))
            Q[h] = O
        return Q

    def train(self):
        Q = np.zeros(self.train_sample_num)
        for h in range(self.train_sample_num):
            temp_data = np.matlib.repmat(self.train_data[h, :], self.M, 1)
            Y = 1 / (1 + np.exp(-self.k * (self.w * temp_data - self.q)))
            Z = np.prod(Y, 1)
            V = np.sum(Z)
            O = 1 / (1 + np.exp(-self.k * (V - self.qs)))
            Q[h] = O
        return Q
