import os
import time
import numpy as np
from Model.DNM_Original import DNM
from Methods.BBO import run
from sklearn.model_selection import train_test_split

# Min-Max normalization 
def maxminnorm(array):
    maxcols = array.max(axis=0)
    mincols = array.min(axis=0)
    data_shape = array.shape
    data_rows = data_shape[0]
    data_cols = data_shape[1]
    t = np.empty((data_rows, data_cols))
    for i in range(data_cols):
        t[:, i] = (array[:, i] - mincols[i]) / (maxcols[i] - mincols[i])
    return t

# Load dataset
def load(abs_path, name):
    print('======         Read Dataset        ======')
    data = np.loadtxt(os.path.join(abs_path, 'Dataset', name), delimiter=',')
    train_set, test_set = train_test_split(data, test_size=0.3, random_state=42)
    train_data = train_set[:, :-1]
    train_label = np.int64(train_set[:, -1])
    test_data = test_set[:, :-1]
    test_label = np.int64(test_set[:, -1])
    return train_data, train_label, test_data, test_label




if __name__ == '__main__':
    s_t = time.time()
    abs_path = os.getcwd()
    dataset_name = 'cancer'
    # Parameters of BBO
    popsize = 50; max_iter = 300; KeepRate = 0.2; alpha = 0.9; pMutation = 0.1; runtimes = 30; print_flag = False

    # Parameters of DNM
    M = 10; M_SNU = 5; qs = 0.5; k = 3; decay = 0.8

    train_data, train_label, test_data, test_label = load(abs_path, dataset_name)

    print('======    Initialization DNM       ======')
    dnm = DNM(M, M_SNU, qs, k, decay)
    dnm.load_datast(train_data, train_label, test_data, test_label)
    dim = dnm.data_dim * (M + M_SNU) * 2
    dnm.init_param()

    best_fitness = np.zeros(runtimes)
    classification_acc = np.zeros(runtimes)
    all_best = np.zeros((runtimes, max_iter), dtype=np.float64)
    all_w = np.zeros((runtimes, (M + M_SNU), dnm.data_dim), dtype=np.float64)
    all_q = np.zeros((runtimes, (M + M_SNU), dnm.data_dim), dtype=np.float64)

    for runtime in range(runtimes):
        train_st = time.time()
        result, dnm = run(dnm, popsize, dim, KeepRate, alpha, pMutation, max_iter)
        best_fitness[runtime] = result[-1]

        print('======        Train the model       ======')
        train_fit = dnm.train()
        final_train_fit = np.where(train_fit < 0.5, 0, 1)
        train_classification = final_train_fit == dnm.train_label
        acc = (sum(train_classification) / len(train_classification) * 100)

        print('======        Test the model       ======')
        test_fit = dnm.test()
        final_test_fit = np.where(test_fit < 0.5, 0, 1)
        classification = final_test_fit == dnm.test_label
        test_acc = (sum(classification) / len(classification) * 100)

        print(
            'Iteration %d.\tTraining error %f\nThe Train accuracy :%.2f\tThe Test accuracy :%.2f\tCosting time : %.2f ' % (
                runtime + 1, result[-1], acc, test_acc, time.time() - train_st))
        classification_acc[runtime] = acc

    print("Total time: %f" % (time.time() - s_t))
    average_error = float(np.mean(best_fitness))
    average_accuracy = float(np.mean(classification_acc))
    print('The average error %f\t the average accuracy %f' % (average_error, average_accuracy))

    print(classification_acc)
    print(all_best)

    np.savetxt('all_best.csv', all_best.T, delimiter=',', fmt='%f')

    s_t = time.time()
