import numpy as np
from sklearn.model_selection import train_test_split
import os


# Min-Max normalization 
def maxminnorm(array):
    maxcols = array.max(axis=0)
    mincols = array.min(axis=0)
    data_shape = array.shape
    data_rows = data_shape[0]
    data_cols = data_shape[1]
    t = np.empty((data_rows, data_cols))
    for i in range(data_cols):
        t[:, i] = (array[:, i] - mincols[i]) / (maxcols[i] - mincols[i])
    return t

# Load dataset
def load(abs_path, name):
    print('======         Read Dataset        ======')
    data = np.loadtxt(os.path.join(abs_path, 'Dataset', name), delimiter=',')
    train_set, test_set = train_test_split(data, test_size=0.3, random_state=42)
    train_data = train_set[:, :-1]
    train_label = np.int64(train_set[:, -1])
    test_data = test_set[:, :-1]
    test_label = np.int64(test_set[:, -1])
    return train_data, train_label, test_data, test_label
