% From: Wenyin Gong Parameter extraction of solar cell models using repaired adaptive differential evolution

function  [obj,error_value] = evaluate_normal_fitness(x,func_flag)

switch  func_flag
    case 1
        % PV model with single-diode  SDM
        %  real variables = 5 ; objectives = 1; constraints = 0     
        [obj,error_value] = PV_model_single(x); 
    case 2
        %  PV model with double-diode DDM
        %  real variables = 7 ; objectives = 1; constraints = 0   
        [obj,error_value] = PV_model_double(x);  
    case 3
        %  PV model with triple-diode TDM
        %  PV module model photowatt-pwp201
        %  real variables = 9 ; objectives = 1; constraints = 0   
        [obj,error_value] = PV_model_triple(x);
    case 4
         %  PV module model photowatt-pwp201
        %  real variables = 5 ; objectives = 1; constraints = 0   
        [obj,error_value] = PV_module_pp201(x);
    case 5
        %  PV module model stp6-120/36
        %  real variables = 5 ; objectives = 1; constraints = 0   
        [obj,error_value] = PV_module_stp6(x); 
    case 6
        %  PV module model stm6-40/36
        %  real variables = 5 ; objectives = 1; constraints = 0
        [obj,error_value] = PV_module_stm6(x); 
 end

end


% -------------------------  PV model with single-diode strat
function  result = calculate_objective_single(x,V_L,I_L)

I_ph = x(1);
I_SD = x(2);
R_s	 = x(3);
R_sh = x(4);
n	 = x(5); 
q = 1.60217646e-19;
k = 1.3806503e-23;
T = 273.15 + 33.0;		%  the temperature is set as 33 centi-degree
V_t = k * T / q;
result = I_ph - I_SD * ( exp( (V_L + I_L*R_s) / (V_t*n) ) - 1.0 ) - ( (V_L + I_L*R_s)/R_sh ) - I_L;

end

function [obj,error_value] = PV_model_single(x)

a = load('cell_data.txt');
actual_V_data =  a(:,1);
actual_I_data =  a(:,2);
data_len = length(actual_V_data);
for j=1:data_len
    error_value(j) = calculate_objective_single(x,actual_V_data(j), actual_I_data(j));
end
fitness = sum(error_value.^2);
obj = sqrt(fitness/data_len);

end
% -------------------------  PV model with single-diode end

%**********************************************************************
% -------------------------  PV module photowatt-pwp201 strat
function  result = calculate_objective_module_pp201(x,V_L,I_L)%%%

I_ph = x(1);
I_SD = x(2);
R_s	 = x(3);
R_sh = x(4);
n	 = x(5); 
q = 1.60217646e-19;
k = 1.3806503e-23;
T = 273.15 + 45.0;		%  the temperature is set as 45 centi-degree
V_t = k * T / q;
NS=36;
NP=1;
result = NP*I_ph - NP*I_SD * ( exp( (V_L/NS + (I_L*R_s/NP)) / (V_t*n) ) - 1.0 ) - ( NP*(V_L/NS + (I_L*R_s/NP))/R_sh ) - I_L;

end

function [obj,error_value] = PV_module_pp201(x)

a = load('pvmodule_data.txt');
actual_V_data =  a(:,1);
actual_I_data =  a(:,2);
data_len = length(actual_V_data);
for j=1:data_len
    error_value(j) = calculate_objective_module_pp201(x,actual_V_data(j), actual_I_data(j));
end
fitness = sum(error_value.^2);
obj = sqrt(fitness/data_len);

end
% -------------------------  PV module photowatt-pwp201 end

%**********************************************************************
% -----------------------  PV model with double-diode strat
function  result = calculate_objective_double(x,V_L,I_L)

I_ph	= x(1);
I_SD1	= x(2);
R_s		= x(3);
R_sh	= x(4);
n1		= x(5);
I_SD2	= x(6);
n2		= x(7);
    
q = 1.60217646e-19;
k = 1.3806503e-23;
T = 273.15 + 33.0;		% the temperature is set as 33 centi-degree

result = I_ph - I_SD1 * ( exp( (q*(V_L + I_L*R_s)) / (n1*k*T) ) -1.0 ) - I_SD2 * ( exp( (q*(V_L + I_L*R_s)) / (n2*k*T) ) -1.0 ) - ( (V_L + I_L*R_s)/R_sh ) - I_L;
     
end

function [obj,error_value] = PV_model_double(x)

a = load('cell_data.txt');
 actual_V_data =  a(:,1);
actual_I_data =  a(:,2);
data_len = length(actual_V_data);
for j=1:data_len
    error_value(j) = calculate_objective_double(x,actual_V_data(j), actual_I_data(j));
end
fitness = sum(error_value.^2);
obj = sqrt(fitness/data_len);

end
% -----------------------  PV model with double-diode end

%**********************************************************************
% -----------------------  PV model with triple-diode strat
function  result = calculate_objective_triple(x,V_L,I_L)

I_ph	= x(1);
I_SD1	= x(2);
R_s		= x(3);
R_sh	= x(4);
n1		= x(5);
I_SD2	= x(6);
n2		= x(7);
I_SD3	= x(8);
n3		= x(9);
    
q = 1.60217646e-19;
k = 1.3806503e-23;
T = 273.15 + 33.0;		% the temperature is set as 33 centi-degree

result = I_ph - I_SD1 * ( exp( (q*(V_L + I_L*R_s)) / (n1*k*T) )-1.0 ) - I_SD2 * ( exp( (q*(V_L + I_L*R_s)) / (n2*k*T) ) -1.0 )- I_SD3 * ( exp( (q*(V_L + I_L*R_s)) / (n3*k*T) ) -1.0 ) - ( (V_L + I_L*R_s)/R_sh ) - I_L;
     
end

function [obj,error_value] = PV_model_triple(x)

a = load('cell_data.txt');
actual_V_data =  a(:,1);
actual_I_data =  a(:,2);
data_len = length(actual_V_data);
for j=1:data_len
    error_value(j) = calculate_objective_triple(x,actual_V_data(j), actual_I_data(j));
end
fitness = sum(error_value.^2);
obj = sqrt(fitness/data_len);

end
% -----------------------  PV model with triple-diode end

%**********************************************************************
% -------------------------  PV module stp6-120/36 strat
function  result = calculate_objective_module_stp6(x,V_L,I_L)%%%

I_ph = x(1);
I_SD = x(2);
R_s	 = x(3);
R_sh = x(4);
n	 = x(5); 
q = 1.60217646e-19;
k = 1.3806503e-23;
T = 273.15 + 55.0;		%  the temperature is set as 55 centi-degree
V_t = k * T / q;
NS=36;
NP=1;
result = NP*I_ph - NP*I_SD * ( exp( (V_L/NS + (I_L*R_s/NP)) / (V_t*n) ) - 1.0 ) - ( NP*(V_L/NS + (I_L*R_s/NP))/R_sh ) - I_L;

end

function [obj,error_value] = PV_module_stp6(x)

a = load('STP6_120_36_data.txt');
actual_V_data =  a(:,1);
actual_I_data =  a(:,2);
data_len = length(actual_V_data);
for j=1:data_len
    error_value(j) = calculate_objective_module_stp6(x,actual_V_data(j), actual_I_data(j));
end
fitness = sum(error_value.^2);
obj = sqrt(fitness/data_len);

end
% -------------------------  PV module stp6-120/36 end

%**********************************************************************
% -------------------------  PV module stm6-40/36 strat
function  result = calculate_objective_module_stm6(x,V_L,I_L)%%%

I_ph = x(1);
I_SD = x(2);
R_s	 = x(3);
R_sh = x(4);
n	 = x(5); 
q = 1.60217646e-19;
k = 1.3806503e-23;
T = 273.15 + 51.0;		%  the temperature is set as 51 centi-degree
V_t = k * T / q;
NS=36;
NP=1;
result = NP*I_ph - NP*I_SD * ( exp( (V_L/NS + (I_L*R_s/NP)) / (V_t*n) ) - 1.0 ) - ( NP*(V_L/NS + (I_L*R_s/NP))/R_sh ) - I_L;

end
function [obj,error_value] = PV_module_stm6(x)

a = load('Model_STM6_40_36_data.txt');
actual_V_data =  a(:,1);
actual_I_data =  a(:,2);
data_len = length(actual_V_data);
for j=1:data_len
    error_value(j) = calculate_objective_module_stm6(x,actual_V_data(j), actual_I_data(j));
end
fitness = sum(error_value.^2);
obj = sqrt(fitness/data_len);

end
% -------------------------  PV module stm6-40/36 end
