%% Directional Permutation Differential Evolution Algorithm 
%% This package is a MATLAB/Octave source code of DPDE
%% Please see the following paper:
%% A state-of-the-art differential evolution algorithm for parameter estimation 
%% -of solar photovoltaic models
%% Author: Shangce Gao, Kaiyu Wang, Sichen Tao, Ting Jin, Hongwei Dai, Jiujun Cheng
%% Developed in MATLAB R2018a
%% Email ID: gaosc@eng.u-toyama.ac.jp(S. Gao)
%% Program Starts here
function [PopOld2, Pop, popu, ci, MemI, rd] = DPDE(nFES, FES, PopOld, PopOld2, Fitness, MemCI, MemRD, MemI, PopSize, PbestRate, Ms, ProblemSize)

    %% calculation of z for every individuals

        rand('seed', sum(100 * clock));

        PopOld2 = PopOld2(randperm(PopSize),:);
        Pop = PopOld;
        [~, SortedIndex] = sort(Fitness, 'ascend');

        mem_rand_index = ceil(Ms * rand(PopSize, 1));
        MUci = MemCI(mem_rand_index);
        MUrd = MemRD(mem_rand_index);
        rd = normrnd(MUrd, 0.1);
        Term_Pos = find(MUrd == -1);
        rd(Term_Pos) = 0;
        rd = min(rd, 1);
        rd = max(rd, 0);
        ci = MUci + 0.1 * tan(pi * (rand(PopSize, 1) - 0.5));
        Pos = find(ci <= 0);
        while ~ isempty(Pos)
             ci(Pos) = MUci(Pos) + 0.1 * tan(pi * (rand(length(Pos), 1) - 0.5));
             Pos = find(ci <= 0);
        end
        ci = min(ci, 1);
        r0 = 1 : PopSize;

        [r1, r2, r3] = genR1R2R3(PopSize, size(Pop, 1), r0);
        pNP = max(round(PbestRate * PopSize), 2); 
        randindex = ceil(rand(1, PopSize) .* pNP); 
        randindex = max(1, randindex); 
        pbest = Pop(SortedIndex(randindex), :); 
        %% Towards Advanced
        diff1a = pbest;
        diff1b = PopOld2(r3, :);

        self1 = Pop(r1,:);
        
        compare1 = [self1(:, ProblemSize + 1), diff1a(:, ProblemSize + 1), diff1b(:, ProblemSize + 1)];
        [Compare1,~] = sort(compare1, 2);
        p1 = rand(6,1);

        nFESX = nFES;
        towards1 = 1;
        for i = 1:length(r0)

            ppX = 6 * nFESX/FES;
            if ~isempty(Compare1)
                if self1(i, ProblemSize + 1) == Compare1(i,1)
                    if diff1a == Compare1(i,2)
                        if p1(1) < ppX
                            towards1 = 1;
                        else
                            towards1 = 1;
                        end
                    else                      
                        if p1(1) < ppX
                            towards1 = 1;
                        else
                            towards1 = -1;
                        end
                    end
                else
                    if self1(i, ProblemSize + 1) == Compare1(i, 2)
                        if diff1a == Compare1(i,1)
                            if p1(1) < ppX
                                towards1 = 1;
                            else
                                towards1 = 1;
                            end
                        else                     
                            if p1(1) < ppX
                                towards1 = 1;
                            else
                                towards1 = -1;
                            end
                        end
                    else                        
                        if diff1a == Compare1(i,1)
                            if p1(1) < ppX
                                towards1 = 1;
                            else
                                towards1 = 1;
                            end
                        else                     
                            if p1(1) < ppX
                                towards1 = 1;
                            else
                                towards1 = -1;
                            end
                        end
                    end
                end
            end
           
            vi(i,:) = Pop(i,:) +  ci(i, ones(1, ProblemSize + 1)) .* (towards1 .* (pbest(i,:) - PopOld2(r3(i), :)) - Pop(i,:) + Pop(r1(i), :));
        end
        %% Towards Advanced
        yi = vi;
        yi(:,end) = [];
        %% CrossOver
          for i = 1: PopSize
             j_rand = floor(rand * ProblemSize) + 1;
             t = rand(1, ProblemSize) < rd(i, 1);
             t(1, j_rand) = 1;
             t_ = 1 - t;
             yi(i, :) = t .* yi(i, :) + t_ .* Pop(i, 1:ProblemSize);
          end
          popu = yi;
end     
     

function [r1, r2, r3,r4,r5] = genR1R2R3(NP1, NP2, r0)
NP0 = length(r0);
r3 = randperm(NP0);
r4 = randperm(NP0);
for i = 1: 99999999
    Pos = (r3 == r0);
    if sum(Pos) == 0
        break;
    else
        r3 = randperm(NP0);
    end
     if i > 1000
        error('Can not genrate r3 in 1000 iterations');
     end
end
for i = 1: 99999999
    Pos = (r4 == r0);
    if sum(Pos) == 0
        break;
    else
        r4 = randperm(NP0);
    end
     if i > 1000
        error('Can not genrate r3 in 1000 iterations');
     end
end
r1 = floor(rand(1, NP0) * NP1) + 1;

for i = 1 : 99999999
    Pos = (r1 == r0)|(r3 == r0);
    if sum(Pos) == 0
        break;
    else 
        r1(Pos) = floor(rand(1, sum(Pos)) * NP1) + 1;
    end
    if i > 1000
        error('Can not genrate r1 in 1000 iterations');
    end
end

r2 = floor(rand(1, NP0) * NP2) + 1;

for i = 1 : 99999999
    Pos = ((r2 == r1) | (r2 == r0)) | (r2 == r0);
    if sum(Pos)==0
        break;
    else 
        r2(Pos) = floor(rand(1, sum(Pos)) * NP2) + 1;
    end
    if i > 1000
        error('Can not genrate r2 in 1000 iterations');
    end
end

r5 = floor(rand(1, NP0) * NP2) + 1;

for i = 1 : 99999999
    Pos = ((r2 == r1) | (r2 == r0)) | (r5 == r0);
    if sum(Pos)==0
        break;
    else 
        r5(Pos) = floor(rand(1, sum(Pos)) * NP2) + 1;
    end
    if i > 1000
        error('Can not genrate r2 in 1000 iterations');
    end
end
end


