% the main.m
clc
clear all
%%
% Global parameters setting
warning off
format long;

%Benchmark_Solar
addpath('Benchmark_Solar_Cell');
fun = @evaluate_normal_fitness;

problemIndex = [1:6];
runTime = 30;
analysisChart = [];
addpath('../');

for f = problemIndex
    func_flag = f;    
    resultChart = [];
    PV_Xrange;
    problem = f;
    FES=50000;
    t = 1;
    nFES = 0;
    
    while t <= runTime                
        tic
        optimalChart = [];
        IAEI2 = [];
        rand('seed', sum(100 * clock));
        D = length(Xmax);
        ProblemSize = D;
        popuSize = 18 * D;
        lu = [Xmin;Xmax];
        PopSize = popuSize;
        uSet = zeros(PopSize, D);
        PbestRate = 0.11;
        rd = 0.5;
        c = 0.7;
        Ms = 5;
        
        % program start here
        MAX_PopSize = PopSize;
        MIN_PopSize = 4.0;
        nFES = 0;
        popu = repmat(lu(1, :), PopSize, 1) + rand(PopSize, D) .* (repmat(lu(2, :) - lu(1, :), PopSize, 1));
        popu2 = repmat(lu(1, :), PopSize, 1) + rand(PopSize, D) .* (repmat(lu(2, :) - lu(1, :), PopSize, 1));
        PopOld = popu;
        Pop = PopOld;
        IAEI1 = [];
        for i=1:PopSize
            [popuFitness(i,:),IAEI1(i,:)] = fun(popu(i,:),func_flag);
            nFES=nFES+1;
            FE_best{func_flag}(t,nFES) =  popuFitness(i,:);
        end
        optimal = min(popuFitness);
        optimalChart = [optimalChart;repmat(optimal,PopSize,1)];
        record(1) = min(popuFitness);
        
        index = find(min(popuFitness)==popuFitness);
        BciSolution = popu(index(1),:);
        
        Fitness = popuFitness;
        %% Towards Advanced
        
        popu = [popu, popuFitness];
        popu2 = [popu2, popuFitness];
        PopOld = popu;
        Pop = PopOld;
        PopOld2 = popu2;
        %%
        gBestFit = optimal;
        %==========================================================================
        MemCI = c .* ones(Ms, 1);
        MemRD = rd .* ones(Ms, 1);
        MemI = 1;

        G=1;
        while nFES <  FES                       
            %% Search machine
            G =G +1;
            algorithmDir = 'DPDE';
            searchMachine = @DPDE;
            [PopOld2, Pop, popu, ci, MemI, rd] = searchMachine(nFES, FES, PopOld, PopOld2, Fitness, MemCI, MemRD, MemI, PopSize, PbestRate, Ms, ProblemSize);
                        
            [popu] = BoundaryDetection(popu,lu);
            
            %% Population evaluation
            popuFitness = [];
            for i=1:PopSize
                [popuFitness(i,:),IAEI1(i,:)] = fun(popu(i,:),func_flag);
                nFES=nFES+1;
                FE_best{func_flag}(t,nFES) =  popuFitness(i,:);
                if popuFitness(i) < gBestFit
                    gBestFit = popuFitness(i);
                    BciSolution = popu(i, :);
                    optimal = gBestFit;
                    optimalChart = [optimalChart;optimal];
                    IAEI2 = IAEI1(i,:);
                else
                    optimalChart = [optimalChart;optimal];
                end
            end
            %% Towards Advanced

            popu = [popu ,popuFitness];
            
            %% Update pBest           
            %%===================================================================
            dif = abs(Fitness - popuFitness);
            I = (Fitness > popuFitness);
            GdRD = rd(I == 1);
            GdCI = ci(I == 1);
            DiffVal = dif(I == 1);
            %%===================================================================
            [Fitness, I] = min([Fitness, popuFitness], [], 2);
            PopOld = Pop;
            PopOld(I == 2, :) = popu(I == 2, :);
            PopOld2(I == 2, :) = Pop(I == 2, :);
            %%==================================================================
            NumSucc = numel(GdRD);
            if NumSucc > 0
                SumDif = sum(DiffVal);
                DiffVal = DiffVal / SumDif;
                MemCI(MemI) = (DiffVal' * (GdCI .^ 2)) / (DiffVal' * GdCI);
                if max(GdRD) == 0 || MemRD(MemI)  == -1
                    MemRD(MemI)  = -1;
                else
                    MemRD(MemI) = (DiffVal' * (GdRD .^ 2)) / (DiffVal' * GdRD);
                end
                MemI = MemI + 1;
                if MemI > Ms
                    MemI = 1;
                end
            end
            %%===================================================================
            Plan_PopSize = round((((MIN_PopSize - MAX_PopSize) /FES) * nFES) + MAX_PopSize);
            if PopSize > Plan_PopSize
                RedPop = PopSize - Plan_PopSize;
                if PopSize - RedPop <  MIN_PopSize
                    RedPop = PopSize - MIN_PopSize;
                end
                PopSize = PopSize - RedPop;
                [valBest ,indBest] = sort(Fitness, 'ascend');
                worst_ind = indBest(PopSize - RedPop + 1:PopSize);
                PopOld(worst_ind,:) = [];
                PopOld2(worst_ind,:) = [];
                Pop(worst_ind,:) = [];
                Fitness(worst_ind,:) = [];
            end
            
            
           %% Survival
            % For minimization problems
            optimal = min(Fitness);
            record(G)=min(Fitness);
        end
        cputime(problem,t) = toc;
        fprintf('%s problem %5.0f time %5.0f |%5.0f -----> %9.16f\n', algorithmDir, f,t,nFES,optimal);
        optimalChart = optimalChart(1:50:FES);
        resultChart = [resultChart,optimalChart];
        best_index = find(min(Fitness)==Fitness);
        temporary1 = PopOld(best_index(1),:);
        best_individual{problem,t} = temporary1(1:end-1);
        temporary1 = [];
        outcome(problem, t) = min(Fitness);
        IAEI{problem,t} = IAEI2;
        Record{problem,t}=record;
        t = t + 1;
        nFES = 0;
    end
    analysisChart = [analysisChart;resultChart(end,:)];
    path = ['./',algorithmDir];
    sheetName = ['F',num2str(problem)];
    xlswrite(path,resultChart,[sheetName,'_D',num2str(D)]);
    mean_value=mean(outcome(problem,:),2);
    std_value = std(outcome(problem,:),0,2);
end
mean_ = mean(analysisChart,2);
std_ = std(analysisChart,0,2);
analysisChart = [analysisChart,mean_];
analysisChart = [analysisChart,std_];
xlswrite(path,analysisChart,['Statistic']);
for j = 1:6
    final_data (j,1) = max(outcome(j,:));
    final_data (j,2) = min(outcome(j,:));
    final_data (j,3) = mean(outcome(j,:));
    final_data (j,4) = std(outcome(j,:));
end
save('DPDE','outcome','Record','best_individual','FE_best','cputime','final_data','IAEI')

