clc;
clear
tic;
format long;
format compact;
% classification'XOR' 'Balloon' 'Iris' 'Cancer' 'Heart'
% approximation 'Sigmoid'  'Cosine' 'Sine' 'Sphere' 'Rosenbrock' 'Griewank'
% prediction 'MackeyGlass' 'EEG' 'BoxJenkins','Photovoltaic'
%% read data
problem_name = 'Photovoltaic';
[train_data,train_target,test_data,test_target,normal] = read_data(problem_name);
load Target.mat
load Train.mat

for train_len = 800:800:7200
    test_len = 800;
    
    train_data = Train(1: train_len,:);
    train_target = Target(1: train_len,:);
    test_data = Train(train_len+1:train_len+test_len, :);
    test_target = Target(train_len+1:train_len+test_len, :);
    
    [I,J] = size(train_data);
    
    % train_len = length(train_target);
    % test_len = length(test_target);
    
    
    %% Hyper-parameters
    M = 30;
    qs = 2;
    k = 4;
    
    %% The parameter of DE
    popsize = 50; % the size of population
    D = J * M * 2; % the dimension of sample
    F = 0.5; % scaling factor
    CR = 0.9; % crossover rate
    iter = 250;
    
    %% parameter structure
    Parameter.F = F;
    Parameter.CR = CR;
    Parameter.popsize = popsize;
    Parameter.D = D;
    Parameter.iter = iter;
    Parameter.problem_name = problem_name;
    net.M = M;
    net.qs = qs;
    net.k = k;
    maxruntime = 1;
    FbestChart = zeros(maxruntime,2);
    for runtimes = 1:maxruntime
        disp(['The current running time: ',num2str(runtimes)]);
        %% train
        [w,q,best] = SNDEtrain(Parameter,net,train_data,train_target);
        net.w = w;
        net.q = q;
        
        %% test
        test_fit = my_DNM(test_data,net);
        count = 0;
        
        if problem_name == 'Photovoltaic'
            %         test_len = 450;
            for j=1:test_len
                if test_target(j,1)==0
                    test_fit(j,1)=0;
                end
            end
            
            for k=1:test_len
                if  test_fit(k)<0
                    test_fit(k)=0;
                end
            end
            Test_out_yc_bx_r=mapminmax('reverse',test_fit',normal.out1_normal);
            Test_out_r=mapminmax('reverse',test_target',normal.out1_normal);
            absolute_err_r=(Test_out_yc_bx_r-Test_out_r);
            testrsme_r=sqrt(sumsqr(Test_out_yc_bx_r-Test_out_r)/test_len);
            
            error=zeros(1,test_len);
            for i=1:test_len
                if Test_out_r(i)>340 %%%%ȥΪ0ĵ0ֵ߽Сĵ
                    error(i)=abs(Test_out_yc_bx_r(i)-Test_out_r(i))./abs(Test_out_r(i));
                end
            end
            MAPE=sum(error,2)/test_len*100;
            
            [xxx,ptnum]=size(Test_out_r);
            %         figure
            %         hold on
            %         echo off
            %         axis([0 ptnum 0 20]) %%%%õǰ x  yƷΧ  xmin xmax ymin ymax
            %         set(gca,'FontSize',10,'Fontname', 'Times New Roman');%%%%ͼ
            %         axis on %%%%%%еǩ̶ȡ
            %         box on
            %         plot(1:ptnum,Test_out_r./1000,'k-','LineWidth',1.5)
            %         hold on
            %         plot(1:ptnum,Test_out_yc_bx_r./1000,'r:','LineWidth',1.5)
            %         xlabel('Sample Sequence','FontName','Times New Roman','FontSize',11)
            %         ylabel('PV Power(MW)','FontName','Times New Roman','FontSize',11)
            %         h=legend({'Actual  Data','Pre Data'},'FontName','Times New Roman','FontSize',9);  %%%Export Setup 3.95*6.83
            %         set(gcf,'Position',[100 200 700 400])
            %         break;
        end
        
        for i = 1:test_len
            if test_fit(i) >= 0.5
                test_fit(i) = 1;
            else
                test_fit(i) = 0;
            end
            if test_fit(i) == test_target(i)
                count = count + 1;
            end
        end
        count = count / test_len;
        
        FbestChart(runtimes,1) = testrsme_r;
        FbestChart(runtimes,2) = MAPE;
        % xlswrite

        
    end
end
toc;

function [auc,sensitivity,specificity] = plot_roc(deci,label_y)
[val,ind] = sort(deci,'descend');
roc_y = label_y(ind);
stack_x = cumsum(roc_y == 0)/sum(roc_y == 0);
stack_y = cumsum(roc_y == 1)/sum(roc_y == 1);
auc = sum((stack_x(2:length(roc_y),1)-stack_x(1:length(roc_y)-1,1)).*stack_y(2:length(roc_y),1));
plot(stack_x,stack_y);
xlabel('False Positive Rate');
ylabel('True Positive Rate');
title(['ROC curve of (AUC = ' num2str(auc) ' )']);
TP = sum((roc_y==1)&(val==1));
TN = sum((roc_y==0)&(val==0));
FN = sum((roc_y==1)&(val==0));
FP = sum((roc_y==0)&(val==1));
sensitivity = TP / (TP + FN);
specificity = TN / (TN + FP);
end


