function [w,q,best] = SNDEtrain(Parameter,net,train_data,train_target)
%% parameter input
F = Parameter.F;
CR = Parameter.CR;
popsize = Parameter.popsize;
D = Parameter.D;
n = D;
iter = Parameter.iter;

M = net.M;
valParents = zeros(popsize,1);
[~,J] =size(train_data); % J: the dimension of samples

%% initial population
lu = [-1 * ones(1, D); 1 * ones(1, D)];
popnew = repmat(lu(1, :), popsize, 1) + rand(popsize, D) .* (repmat(lu(2, :) - lu(1, :), popsize, 1));

% objective function

% fitness = evolution(Parameter,pop,train_data,train_target,net);
for popindex = 1:popsize
    w = popnew(popindex,1:J*M);
    q = popnew(popindex,J*M+1:D);
    w=reshape(w,J,M);
    q=reshape(q,J,M);
    net.w = w;
    net.q = q;
    train_fit = my_DNM(train_data,net);
    cost = (train_fit - train_target).^2;
    valParents(popindex) = mean(cost);
end

m = 0.1 * popsize;
degree = randi([2, m]);
% degree = 5;
pNP = m;

CRm = 0.9;
Fm = 0.7;
goodCR = CRm;
goodF = Fm;
stdCR = 0.1;
stdF = 0.1;

%% the values and indices of the best solutions
[valBest, indBest] = sort(valParents, 'ascend');
%%
for k_circle = 1:iter
    
    if k_circle == 1
        popold = popnew;
    end
    CRm = mean(goodCR);
    Fm = mean(goodF);
    [F, CR] = randFCR(popsize, CRm, stdCR, Fm, stdF);
    
    randindex = ceil(rand(1, popsize) * pNP);    % select from [1, 2, 3, ..., pNP]
    randindex = max(1, randindex);               % to avoid the problem that rand = 0 and thus ceil(rand) = 0
    pbest = popnew(indBest(randindex), :);
    
    % Generate a scale-free network
    seed = ones(m, m);
    for i = 1:m
        seed(m, m) = 0;
    end
    scale_net = SFNG(popsize, degree, seed);
    
    % sort the scale-free network according to individuals' degree
    [~, order_de] = sort(sum(scale_net,2),1,'descend');
    
    order1 = zeros(popsize,1);
    order2 = zeros(popsize,1);
    for i = 1:popsize
        
        j = indBest == i;% find the individual's fitness order
        % order_de(j)Ϊinetеλ
        [~,k] = find(scale_net(order_de(j), :) == 1);% õnetĵ
        pop_order = zeros(1, length(k));
        value_fr = zeros(1, length(k));
        Rank = zeros(1, length(k));
        for ii = 1:length(k)
            pop_order(ii) = indBest(order_de == k(ii));% ҵiĵpopе
            value_fr(ii) = valParents(pop_order(ii));
        end
        [~, nb_order] = sort(value_fr, 'ascend');% еĸ㰴fitness
        jj = 1;
        ll = length(k);
        sum_Rank = 0;
        while ll ~= 0 % iĵrankֵ
            Rank(nb_order(ll)) = jj;
            sum_Rank = sum_Rank + Rank(nb_order(ll));
            ll = ll - 1;
            jj = jj + 1;
        end
        
        %̶ѡбselect1select2
        rr = rand;
        rrr = rand;
        p1 = zeros(1, length(Rank));
        for kk = 1:length(Rank)
            p1(kk) = Rank(kk)/sum_Rank;
        end
        select1 = 1;
        sum_P = 0;
        while sum_P < rr
            sum_P = sum_P + p1(select1);
            select1 = select1 + 1;
        end
        select1 = select1 - 1;
        sum_Rank = sum_Rank - Rank(select1);
        order1(i,:) = pop_order(nb_order(select1));
        Rank(select1) = [];
        nb_order(select1) = [];
        
        % select2
        p2 = zeros(1,length(Rank));
        for mm = 1:length(Rank)
            p2(mm) = Rank(mm)/sum_Rank;
        end
        select2 = 1;
        sum_P = 0;
        while sum_P < rrr
            sum_P = sum_P + p2(select2);
            select2 = select2 + 1;
        end
        select2 = select2 - 1;
        order2(i,:) = pop_order(nb_order(select2));
        
    end
    vi = popnew + F(:, ones(1, n)) .* (pbest - popold + popnew(order1, :) - popnew(order2, :));
    %                                     vi = popnew + F(:, ones(1, n)) .* (pbest - popnew + popnew(order1, :) - popnew(order2, :));
    vi = boundConstraint(vi, popnew, lu);
    
    mask = rand(popsize, n) > CR(:, ones(1, n));                      % mask is used to indicate which elements of ui comes from the parent
    rows = (1 : popsize)'; cols = floor(rand(popsize, 1) * n)+1;      % choose one position where the element of ui doesn't come from the parent
    jrand = sub2ind([popsize n], rows, cols); mask(jrand) = false;
    ui = vi; ui(mask) = popnew(mask);
    
    U = ui;
    
    % objective function
    for popindex = 1:popsize
        w = U(popindex,1:J*M);
        q = U(popindex,J*M+1:D);
        w=reshape(w,J,M);
        q=reshape(q,J,M);
        net.w = w;
        net.q = q;
        train_fit = my_DNM(train_data,net);
        cost = (train_fit - train_target).^2;
        valOffspring(popindex,1) = mean(cost);
    end
    [valParents, I] = min([valParents, valOffspring], [], 2);
    popold = popnew;
    
    popnew(I == 2, :) = ui(I == 2, :);
    
    goodCR = CR(indBest(1:m));
    goodF = F(indBest(1:m));
    stdCR = std(goodCR);
    stdF = std(goodF);
    
%     [valBest, indBest] = sort(valParents, 'ascend');
    
    best = min(valParents);
    %     disp(['The iteration ' num2str(i) ' error:' num2str(best)]);
end
%%
[~,index] = min(valParents);
best_population = popnew(index,:);
w = best_population(1:J*M);
q = best_population(J*M+1:D);
w=reshape(w,J,M);
q=reshape(q,J,M);
net.w = w;
net.q = q;
end