function fitness = evolution(Parameter,population,train_data,train_target,net)

popsize = Parameter.popsize;
D = Parameter.D;
M = net.M;
fitness = zeros(popsize,1);
[~,J] =size(train_data); % J: the dimension of samples

problem_name = Parameter.problem_name;
switch problem_name
    case 'Sphere'
        
        in_x = train_data(1:21,:);
        in_y = train_data(1:21,:);
        out = train_target;
        for popindex = 1:popsize
            w = population(popindex,1:J*M);
            q = population(popindex,J*M+1:D);
            
            w=reshape(w,J,M);
            q=reshape(q,J,M);
            net.w = w;
            net.q = q;
            cost = 0;
            for p1 = 1:21                  
                for p2 = 1:21
                    actualvalue = my_DNM([in_x(p1,p2) ,in_y(p1,p2)],net );  %
                    cost=cost+(out(p1,p2)-actualvalue)^2;
                end
            end
            
            fitness(popindex) = mean(cost);
            fitness(popindex) = fitness(popindex) / (21*21);
        end
    otherwise
        
        for popindex = 1:popsize
            w = population(popindex,1:J*M);
            q = population(popindex,J*M+1:D);
            w=reshape(w,J,M);
            q=reshape(q,J,M);
            net.w = w;
            net.q = q;
            train_fit = my_DNM(train_data,net);
            cost = (train_fit - train_target).^2;
            fit_U(popindex) = mean(cost);
        end
end

