function [F,CR] = randFCR(NP, CRm, CRsigma, Fm,  Fsigma)

CRsigma = max(CRsigma, 0.1);
Fsigma = max(Fsigma, 0.1);
%% generate CR
CR = CRm + CRsigma * randn(NP, 1);
CR = min(1, max(0, CR));                % truncated to [0 1]

%% generate F
F = Fm + Fsigma * randn(NP, 1);
F = min(1, F);                          % truncation

% we don't want F = 0. So, if F<=0, we regenerate F (instead of trucating it to 0)
pos = find(F <= 0);
while ~ isempty(pos)
%     F(pos) = randCauchy(length(pos), 1, Fm, Fsigma);
    F(pos) = Fm + Fsigma * randn(length(pos), 1);
    F = min(1, F);                      % truncation
    pos = find(F <= 0);
end

% Cauchy distribution: cauchypdf = @(x, mu, delta) 1/pi*delta./((x-mu).^2+delta^2)
function result = randCauchy(m, n, mu, delta)

% http://en.wikipedia.org/wiki/Cauchy_distribution
result = mu + delta * tan(pi * (rand(m, n) - 0.5));
