function [train_data,train_target,test_data,test_target,normal] = read_data(problem_name)

% addpath('../Dataset/');
normal = [];
switch problem_name
    %% classification
    
    case 'XOR'
        load('XOR.mat','data');
        load('XOR.mat','target');
        train_data = data;
        train_target = target;
        
        test_data = data;
        test_target = target;
    case 'Balloon'
        data = load('Balloon.txt');
        train_data = data(:,1:4);
        train_target = data(:,5);
        
        test_data = data(:,1:4);
        test_target = data(:,5);
    case 'Iris'
        data = load('Iris.txt');
        train_data = data(:,1:4);
        train_target = data(:,5);
        test_data = data(:,1:4);
        test_target = data(:,5);
    case 'Cancer'
        data = load('Cancer.txt');
        
        % ݴ
        temp_data=data(1:699,2:11);
        for iii=1:699
            for jjj=1:9
                temp_data(iii,jjj)=((temp_data(iii,jjj)-1)/9);
            end
        end
        [trainInd,testInd] = dividerand(699,0.7,0.3);
        train_data = temp_data(trainInd,1:9);
        train_target = temp_data(trainInd,10) / 2 - 1;
        test_data = temp_data(testInd,1:9);
        test_target = temp_data(testInd,10) / 2 -1 ;
    case 'Heart'
        load('Heart297.mat','heart297');
        [len,~] = size(heart297);
        [trainInd,testInd] = dividerand(len,0.7,0.3);
        train_data = heart297(trainInd,1:10);
        train_target = heart297(trainInd,11);
        test_data = heart297(testInd,1:10);
        test_target = heart297(testInd,11);
        %% approximation
    case 'Sigmoid'
        train_data = -3:0.1:3;
        test_data = -3:0.05:3;
        train_data = train_data';
        test_data = test_data';
        train_target = fitfun_sigmoid(train_data);
        test_target = fitfun_sigmoid(test_data);
        
        
    case 'Cosine'
        train_data = 1.25:0.05:2.75;
        test_data = 1.25:0.04:2.75;
        train_data = train_data';
        test_data = test_data';
        train_target = fitfun_cosine(train_data);
        test_target = fitfun_cosine(test_data);
    case 'Sine'
        
        train_data = -2*pi:0.1:2*pi;
        test_data = -2*pi:0.05:2*pi;
        train_data = train_data';
        test_data = test_data';
        train_target = fitfun_sine(train_data);
        test_target = fitfun_sine(test_data);
    case 'Sphere'
        train_data = [];
        test_data = [];
        train_target = [];
        test_target = [];
        
        [train_data_x,train_data_y] = meshgrid(-2:0.2:2 , -2:0.2:2 );
        [x1,y1] = size(train_data_x);
        train_out = fitfun_sphere(train_data_x,train_data_y);
        train_out = train_out./8;
        for p1 = 1:x1
            for p2 = 1:y1
                train_data = [train_data;[train_data_x(p1,p2) ,train_data_y(p1,p2)]];
                train_target = [train_target;train_out(p1,p2)];
            end
        end
        
        
        [test_data_x,test_data_y] = meshgrid(-2:0.1:2 , -2:0.1:2 );
        [x2,y2] = size(test_data_x);
        test_out = fitfun_sphere(test_data_x,test_data_y);
        test_out = test_out./8;
        for p1 = 1:x2                  % ѵݸ
            for p2 = 1:y2
                test_data = [test_data;[test_data_x(p1,p2) ,test_data_y(p1,p2)]];
                test_target = [test_target;test_out(p1,p2)];
            end
        end
        
    case 'Rosenbrock'
        train_data = [];
        train_target = [];
        test_data = [];
        test_target = [];
        x1 = -5:3:5;
        x2 = -5:3:5;
        x3 = -5:3:5;
        x4 = -5:3:5;
        x5 = -5:3:5;
        buff(4,4,4,4,4) = 0;
        for a=1:4
            for b=1:4
                for c=1:4
                    for d=1:4
                        for e=1:4
                            buff(a,b,c,d,e) = fitfun_rosenbrock([x1(a),x2(b),x3(c),x4(d),x5(e)]);
                        end
                    end
                end
            end
        end
        train_out = buff/120;
        
        for a=1:4
            for b=1:4
                for c=1:4
                    for d=1:4
                        for e=1:4
                            train_data = [train_data;[x1(a),x2(b),x3(c),x4(d),x5(e)]];
                            train_target = [train_target;train_out(a,b,c,d,e)];
                        end
                    end
                end
            end
        end
        
        
        
        
        x1 = -5:2:5;
        x2 = -5:2:5;
        x3 = -5:2:5;
        x4 = -5:2:5;
        x5 = -5:2:5;
        buff(6,6,6,6,6) = 0;
        for a=1:6
            for b=1:6
                for c=1:6
                    for d=1:6
                        for e=1:6
                            buff(a,b,c,d,e) = fitfun_rosenbrock([x1(a),x2(b),x3(c),x4(d),x5(e)]);
                        end
                    end
                end
            end
        end
        test_out = buff/120; % 鵽0-1  úԭķΧ0-120
        for a=1:6
            for b=1:6
                for c=1:6
                    for d=1:6
                        for e=1:6
                            test_data = [test_data;[x1(a),x2(b),x3(c),x4(d),x5(e)]];
                            test_target = [test_target;test_out(a,b,c,d,e)];
                        end
                    end
                end
            end
        end
        
        
    case 'Griewank'
        
        train_data = [];
        train_target = [];
        test_data = [];
        test_target = [];
        
        
        [in_x,in_y] = meshgrid(-2:0.2:2 , -2:0.2:2);
        buff(21,21)=0;
        for m= 1:21
            for n = 1:21
                buff(m,n) = fitfun_griewank( in_x(m,n) , in_y(m,n) );
            end
        end
        train_out = buff/2; % 鵽0-1  úԭķΧ0-2
        for p1 = 1:21                  % ѵݸ
            for p2 = 1:21
                train_data = [train_data;[in_x(p1,p2) ,in_y(p1,p2) ]];
                train_target = [train_target;train_out(p1,p2)];
            end
        end
        
        
        
        [in_x,in_y] = meshgrid(-2:0.1:2 , -2:0.1:2);
        buff(41,41)=0;
        for m= 1:41
            for n = 1:41
                buff(m,n) = fitfun_griewank( in_x(m,n) , in_y(m,n) );
            end
        end
        test_out = buff/2; % 鵽0-1  úԭķΧ0-2
        for p1 = 1:41                  % ѵݸ
            for p2 = 1:41
                test_data = [test_data;[in_x(p1,p2) ,in_y(p1,p2) ]];
                test_target = [test_target;test_out(p1,p2)];
            end
        end
        
        
        
        %% Prediction
        
    case 'MackeyGlass'
        load MackeyGlass
        a = mapminmax(MackeyGlass',0,1);
        trainboundary = 450;
        dend = 981;
        input = zeros(dend,4);
        train_out = zeros(dend,1);
        for i= 1: dend
            input(i,1) = a(i);
            input(i,2) = a(i+6);
            input(i,3) = a(i+12);
            input(i,4) = a(i+18);
            train_out(i) = a(i+19);
        end
        
        train_data = input(1:450,:);
        train_target = train_out(1:450);
        
        test_data = input(451:end,:);
        test_target = train_out(451:end);
        
    case 'EEG'
        load eegdata_task1
        a = mapminmax(eegdata_task1(1,:),0,1);  %һ
        
        trainboundary = 1000;  %ѵ
        dend = 2492;           %ܹ
        
        %
        input = zeros(dend,4);  % dend  4
        train_out = zeros(dend,1);
        for i= 1: dend
            input(i,1) = a(i);
            input(i,2) = a(i+4);
            input(i,3) = a(i+6);
            input(i,4) = a(i+7);
            train_out(i) = a(i+8);
        end
        train_data = input(1:1000,:);
        train_target = train_out(1:1000);
        
        test_data = input(1001:end,:);
        test_target = train_out(1001:end);
    case 'BoxJenkins'
        load BoxJenkins
        a = mapminmax(BoxJenkins',0,1);  %һ
        
        trainboundary = 140;  %ѵ
        dend = 292;           %ܹ
        
        %
        input = zeros(dend,2);  % dend  4
        train_out = zeros(dend,1);
        for i= 1: dend
            input(i,1) = a(1,i+3);
            input(i,2) = a(2,i);
            train_out(i) = a(1,i+4);
        end
        train_data = input(1:trainboundary,:);
        train_target = train_out(1:trainboundary);
        
        test_data = input(trainboundary+1:end,:);
        test_target = train_out(trainboundary+1:end);
    case 'Photovoltaic'
        load('photovolatic.mat','train_data','train_target','test_data','test_target','normal')
        
end
end

