import os
from scipy import io
import numpy as np
import time
import argparse

st = time.time()
parse = argparse.ArgumentParser()

parse.add_argument('--data_path', '-dt', type=str,
                   default='/home/lzy/UltrasonicPrediction/UltrasonicPrediction/result/test_non',
                   help='1: normalized_data OR 0:non_normalized_data')

parse.add_argument('--input_size', '-size', type=int, default=1)
parse.add_argument('--remove', '-r', type=int, default=0)

# params
args = parse.parse_args()
data_path = args.data_path

remove_flag = args.remove
input_size = args.input_size
print(input_size)
if remove_flag:
    nz = 896
else:
    nz = 1024

"""
test_save_path = os.path.join(save_path, 'image%d.mat' % num)
sci_io.savemat(test_save_path, {'pre_outputs': predict_output, 'true_outputs': true_y,
                                'nx': data_loader.input_size, 'nz': data_loader.num_seq,
                                'ndat': data_loader.seq_len, 'index': test_index[0, num]})
"""

for num in os.listdir(data_path):

    image_path = os.path.join(data_path, num)

    print(image_path)
    data = io.loadmat(image_path)
    pre_outputs = data['pre_outputs']
    true_outputs = data['true_outputs']

    recove_pre = np.zeros((nz, 96))
    recove_true = np.zeros((nz, 96))
    for i in range(nz):
        for j in range(96):
            index = i * 96 + j
            recove_pre[i, j] = pre_outputs[int(index / input_size), (index % input_size)]
            recove_true[i, j] = true_outputs[int(index / input_size), (index % input_size)]

    io.savemat(image_path, {'pre_outputs': recove_pre, 'true_outputs': recove_true})


